/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWMBlocks;
import betterwithmods.blocks.BWMBlock;
import betterwithmods.craft.KilnInteraction;
import betterwithmods.craft.heat.BWMHeatRegistry;
import betterwithmods.util.InvUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class BlockKiln
extends BWMBlock {
    public static final PropertyInteger COOK = PropertyInteger.func_177719_a((String)"cook", (int)0, (int)8);

    public BlockKiln() {
        super(Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public int func_149738_a(World world) {
        return 20;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, 20, 5);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int oldCookTime = this.getCookCounter((IBlockAccess)world, pos);
        BlockPos down = pos.func_177977_b();
        BlockPos up = pos.func_177984_a();
        if (world.func_180495_p(down).func_177230_c() != BWMBlocks.STOKED_FLAME) {
            int meta;
            boolean intenseFlame;
            Block block = world.func_180495_p(down).func_177230_c();
            boolean bl = intenseFlame = BWMHeatRegistry.contains(block, meta = block.func_180651_a(world.func_180495_p(down))) && BWMHeatRegistry.get((Block)block, (int)meta).value > 4;
            if (!intenseFlame) {
                world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)COOK, (Comparable)Integer.valueOf(0)));
                if (oldCookTime > 0) {
                    world.func_175715_c(0, up, -1);
                }
                return;
            }
        }
        int currentTickRate = 20;
        boolean canCook = false;
        Block above = world.func_180495_p(up).func_177230_c();
        int aboveMeta = world.func_180495_p(up).func_177230_c().func_180651_a(world.func_180495_p(up));
        if (!world.func_175623_d(up) && KilnInteraction.INSTANCE.contains(above, aboveMeta) && this.checkKilnIntegrity((IBlockAccess)world, pos)) {
            canCook = true;
        }
        if (canCook) {
            int newCookTime = oldCookTime + 1;
            if (newCookTime > 7) {
                newCookTime = 0;
                this.cookBlock(world, pos.func_177984_a());
                this.setCookCounter(world, pos, 0);
            } else {
                if (newCookTime > 0) {
                    world.func_175715_c(0, up, newCookTime + 2);
                }
                currentTickRate = this.calculateTickRate((IBlockAccess)world, pos);
            }
            this.setCookCounter(world, pos, newCookTime);
            if (newCookTime == 0) {
                world.func_175715_c(0, up, -1);
                this.setCookCounter(world, pos, 0);
                world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
            }
        } else if (oldCookTime != 0) {
            world.func_175715_c(0, up, -1);
            this.setCookCounter(world, pos, 0);
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
        }
        world.func_180497_b(pos, (Block)this, currentTickRate, 5);
    }

    private int calculateTickRate(IBlockAccess world, BlockPos pos) {
        int secondaryFire = 0;
        for (int xP = -1; xP < 2; ++xP) {
            for (int zP = -1; zP < 2; ++zP) {
                BlockPos bPos;
                if (xP == 0 && zP == 0 || !BWMHeatRegistry.contains(world.func_180495_p(bPos = pos.func_177982_a(xP, -1, zP)).func_177230_c(), world.func_180495_p(bPos).func_177230_c().func_180651_a(world.func_180495_p(bPos))) || BWMHeatRegistry.get((Block)world.func_180495_p((BlockPos)bPos).func_177230_c(), (int)world.func_180495_p((BlockPos)bPos).func_177230_c().func_180651_a((IBlockState)world.func_180495_p((BlockPos)bPos))).value <= 4) continue;
                ++secondaryFire;
            }
        }
        return 60 * (8 - secondaryFire) / 8 + 20;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150336_V);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        int cookTime = this.getCookCounter((IBlockAccess)world, pos);
        BlockPos above = pos.func_177984_a();
        BlockPos below = pos.func_177977_b();
        IBlockState aboveBlock = world.func_180495_p(above);
        IBlockState belowBlock = world.func_180495_p(below);
        if (cookTime > 0 && !KilnInteraction.INSTANCE.contains(aboveBlock.func_177230_c(), aboveBlock.func_177230_c().func_180651_a(aboveBlock)) && (!BWMHeatRegistry.contains(belowBlock.func_177230_c(), belowBlock.func_177230_c().func_180651_a(belowBlock)) || BWMHeatRegistry.contains(belowBlock.func_177230_c(), belowBlock.func_177230_c().func_180651_a(state)) && BWMHeatRegistry.get((Block)belowBlock.func_177230_c(), (int)belowBlock.func_177230_c().func_180651_a((IBlockState)belowBlock)).value < 5) && this.getCookCounter((IBlockAccess)world, pos) > 0) {
            world.func_175715_c(0, above, -1);
            this.setCookCounter(world, pos, 0);
        }
        world.func_180497_b(pos, (Block)this, 20, 5);
    }

    @Override
    public boolean canRotateOnTurntable(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canRotateHorizontally(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canRotateVertically(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int getCookCounterFromMeta(int meta) {
        return meta & 7;
    }

    public int getCookCounter(IBlockAccess world, BlockPos pos) {
        return this.getCookCounterFromMeta((Integer)world.func_180495_p(pos).func_177229_b((IProperty)COOK));
    }

    public void setCookCounter(World world, BlockPos pos, int cookCounter) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)COOK, (Comparable)Integer.valueOf(cookCounter)));
    }

    private void cookBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        int meta = world.func_180495_p(pos).func_177230_c().func_180651_a(world.func_180495_p(pos));
        if (block != null && KilnInteraction.INSTANCE.contains(block, meta)) {
            List<ItemStack> result = KilnInteraction.INSTANCE.getProducts(block, meta);
            InvUtils.ejectStackWithOffset(world, pos, result);
            world.func_175698_g(pos);
        }
    }

    private boolean checkKilnIntegrity(IBlockAccess world, BlockPos pos) {
        int brickCount = 0;
        for (int i = 1; i <= 5; ++i) {
            Block block = world.func_180495_p(pos.func_177984_a().func_177972_a(EnumFacing.func_82600_a((int)i))).func_177230_c();
            if (block == Blocks.field_150336_V || block == BWMBlocks.KILN) {
                ++brickCount;
                continue;
            }
            if (!Loader.isModLoaded((String)"terrafirmacraft") || block != Block.field_149771_c.func_82594_a((Object)new ResourceLocation("terrafirmacraft", "FireBrick"))) continue;
            ++brickCount;
        }
        return brickCount > 2;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)COOK, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)COOK);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COOK});
    }
}

