/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWMBlocks;
import betterwithmods.api.block.IAxle;
import betterwithmods.api.block.IMechanical;
import betterwithmods.blocks.BWMBlock;
import betterwithmods.util.DirUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockMillGenerator
extends BWMBlock
implements IMechanical,
IAxle {
    public static final PropertyBool ISACTIVE = PropertyBool.func_177716_a((String)"ison");
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
    static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);

    public BlockMillGenerator(Material material) {
        super(material);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public int getPowerLevel(IBlockAccess world, BlockPos pos) {
        return this.getPowerLevelFromState(world.func_180495_p(pos));
    }

    public int getPowerLevelFromState(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ISACTIVE) != false ? 4 : 0;
    }

    @Override
    public int getMechPowerLevelToFacing(World world, BlockPos pos, EnumFacing dir) {
        if (((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ISACTIVE)).booleanValue()) {
            EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(pos).func_177229_b(AXIS);
            if (dir.func_176740_k() == axis) {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public boolean isAxleOrientedToFacing(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(pos).func_177229_b(AXIS);
        return dir.func_176740_k() == axis;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, ISACTIVE});
    }

    public int func_176201_c(IBlockState state) {
        int meta = DirUtils.getLegacyAxis((EnumFacing.Axis)state.func_177229_b(AXIS));
        if (((Boolean)state.func_177229_b((IProperty)ISACTIVE)).booleanValue()) {
            meta += 8;
        }
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        boolean active;
        boolean bl = active = meta > 7;
        if (active) {
            meta -= 8;
        }
        return this.getAxisState(DirUtils.getAxisFromLegacy(meta)).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(active));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return X_AABB;
            }
            case Y: {
                return Y_AABB;
            }
        }
        return Z_AABB;
    }

    public int func_149738_a(World world) {
        return 20;
    }

    public abstract ItemStack getGenStack(IBlockState var1);

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack(BWMBlocks.AXLE));
        drops.add(this.getGenStack(state));
        return drops;
    }

    public IBlockState getAxisState(EnumFacing.Axis axis) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)axis);
    }

    @Override
    public int getAxisAlignment(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            return DirUtils.getLegacyAxis((EnumFacing.Axis)state.func_177229_b(AXIS));
        }
        return DirUtils.getLegacyAxis(EnumFacing.Axis.Y);
    }

    @Override
    public boolean isMechanicalJunction() {
        return true;
    }
}

