/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWMBlocks;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.blocks.BWMBlock;
import betterwithmods.blocks.BlockAesthetic;
import betterwithmods.config.BWConfig;
import betterwithmods.craft.SawInteraction;
import betterwithmods.damagesource.BWDamageSource;
import betterwithmods.event.MobDropEvent;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import betterwithmods.util.MechanicalUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSaw
extends BWMBlock
implements IMechanicalBlock {
    public static final PropertyBool ISACTIVE = PropertyBool.func_177716_a((String)"isactive");
    private static final float HEIGHT = 0.71875f;
    private static final AxisAlignedBB D_AABB = new AxisAlignedBB(0.0, 0.28125, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB U_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.71875, 1.0);
    private static final AxisAlignedBB N_AABB = new AxisAlignedBB(0.0, 0.0, 0.28125, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB S_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.71875);
    private static final AxisAlignedBB W_AABB = new AxisAlignedBB(0.28125, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB E_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.71875, 1.0, 1.0);

    public BlockSaw() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.UP));
    }

    public int func_149738_a(World world) {
        return 10;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float flX, float flY, float flZ, int meta, EntityLivingBase placer, ItemStack stack) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, flX, flY, flZ, meta, placer, stack);
        return this.setFacingInBlock(state, DirUtils.getOpposite(facing));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_185899_b(world, pos);
        EnumFacing facing = this.getFacingFromBlockState(state);
        switch (facing) {
            case DOWN: {
                return D_AABB;
            }
            case UP: {
                return U_AABB;
            }
            case NORTH: {
                return N_AABB;
            }
            case SOUTH: {
                return S_AABB;
            }
            case WEST: {
                return W_AABB;
            }
        }
        return E_AABB;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        if (block == BWMBlocks.AXLE || block == BWMBlocks.HAND_CRANK) {
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
        } else {
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(6), 5);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean powered = this.isInputtingMechPower(world, pos);
        boolean isOn = this.isBlockOn((IBlockAccess)world, pos);
        if (isOn != powered) {
            this.emitSawParticles(world, pos, rand);
            this.setMechanicalOn(world, pos, powered);
            if (powered) {
                world.func_180497_b(pos, (Block)this, this.func_149738_a(world) + rand.nextInt(6), 5);
                world.func_184133_a(null, pos, SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 1.0f + rand.nextFloat() * 0.1f, 1.5f + rand.nextFloat() * 0.1f);
            } else {
                world.func_184133_a(null, pos, SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 1.0f + rand.nextFloat() * 0.1f, 0.75f + rand.nextFloat() * 0.1f);
            }
        } else if (powered) {
            this.sawBlockInFront(world, pos, rand);
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world) + rand.nextInt(6), 5);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.isMechanicalOn((IBlockAccess)world, pos) && entity instanceof EntityLivingBase) {
            EnumFacing dir = this.getFacing((IBlockAccess)world, pos);
            BWDamageSource source = BWDamageSource.saw;
            int damage = 4;
            boolean unobstructed = true;
            for (int i = 0; i < 3; ++i) {
                BlockPos pos2 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - i, pos.func_177952_p()).func_177972_a(dir);
                Block block = world.func_180495_p(pos2).func_177230_c();
                IBlockState blockState = world.func_180495_p(pos2);
                if (block == BWMBlocks.AESTHETIC && ((BlockAesthetic.EnumType)((Object)blockState.func_177229_b(BlockAesthetic.blockType))).getMeta() < 2) {
                    source = BWDamageSource.choppingBlock;
                    damage *= 3;
                    if (((BlockAesthetic.EnumType)((Object)blockState.func_177229_b(BlockAesthetic.blockType))).getMeta() != 0 || !unobstructed) break;
                    world.func_175656_a(pos2, BWMBlocks.AESTHETIC.func_176223_P().func_177226_a(BlockAesthetic.blockType, (Comparable)((Object)BlockAesthetic.EnumType.CHOPBLOCKBLOOD)));
                    break;
                }
                if (!world.func_175623_d(pos2) && !(block instanceof BlockLiquid) && !(block instanceof IFluidBlock)) break;
                if (world.func_175623_d(pos2)) continue;
                unobstructed = false;
            }
            if (entity instanceof EntityMob && ((EntityLivingBase)entity).func_110143_aJ() <= (float)damage) {
                ((EntityLivingBase)entity).field_70718_bc = 60;
                if (world instanceof WorldServer) {
                    this.performLastHit(entity, damage);
                }
            } else if (entity.func_70097_a((DamageSource)source, (float)damage)) {
                ((EntityLivingBase)entity).field_70718_bc = 60;
                world.func_184133_a(null, pos, SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 1.0f + world.field_73012_v.nextFloat() * 0.1f, 1.5f + world.field_73012_v.nextFloat() * 0.1f);
            }
        }
    }

    private void performLastHit(Entity entity, float damage) {
        entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)MobDropEvent.player), damage);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != this.getFacingFromBlockState(state);
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return this.getFacingFromBlockState(world.func_180495_p(pos));
    }

    @Override
    public EnumFacing getFacingFromBlockState(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
    }

    @Override
    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    @Override
    public boolean canRotateOnTurntable(IBlockAccess world, BlockPos pos) {
        return this.getFacing(world, pos) != EnumFacing.DOWN && this.getFacing(world, pos) != EnumFacing.UP;
    }

    @Override
    public boolean canRotateVertically(IBlockAccess world, BlockPos pos) {
        return this.canRotateOnTurntable(world, pos);
    }

    @Override
    public void rotateAroundYAxis(World world, BlockPos pos, boolean reverse) {
        if (DirUtils.rotateAroundY(this, world, pos, reverse)) {
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
            MechanicalUtil.destoryHorizontalAxles(world, pos);
        }
    }

    public boolean isBlockOn(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ISACTIVE);
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechPower(World world, BlockPos pos) {
        return MechanicalUtil.isBlockPoweredByAxle(world, pos, this);
    }

    @Override
    public boolean isOutputtingMechPower(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canInputPowerToSide(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return dir != this.getFacing(world, pos);
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        this.breakSaw(world, pos);
    }

    public void breakSaw(World world, BlockPos pos) {
        if (BWConfig.dropsSaw) {
            InvUtils.ejectBrokenItems(world, pos, new ResourceLocation("betterwithmods", "block/saw"));
        }
        world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
        world.func_175698_g(pos);
    }

    @Override
    public boolean isMechanicalOn(IBlockAccess world, BlockPos pos) {
        return this.isBlockOn(world, pos);
    }

    @Override
    public void setMechanicalOn(World world, BlockPos pos, boolean isOn) {
        boolean active = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ISACTIVE);
        if (isOn != active) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(isOn)));
        }
    }

    public void emitSawParticles(World world, BlockPos pos, Random rand) {
        EnumFacing facing = this.getFacing((IBlockAccess)world, pos);
        float xPos = pos.func_177958_n();
        float yPos = pos.func_177956_o();
        float zPos = pos.func_177952_p();
        float xExtent = 0.0f;
        float zExtent = 0.0f;
        switch (facing) {
            case DOWN: {
                xPos += 0.5f;
                zPos += 0.5f;
                xExtent = 1.0f;
                break;
            }
            case UP: {
                xPos += 0.5f;
                zPos += 0.5f;
                yPos += 1.0f;
                xExtent = 1.0f;
                break;
            }
            case NORTH: {
                xPos += 0.5f;
                yPos += 0.5f;
                xExtent = 1.0f;
                break;
            }
            case SOUTH: {
                xPos += 0.5f;
                yPos += 0.5f;
                zPos += 1.0f;
                xExtent = 1.0f;
                break;
            }
            case WEST: {
                yPos += 0.5f;
                zPos += 0.5f;
                zExtent = 1.0f;
                break;
            }
            default: {
                yPos += 0.5f;
                zPos += 0.5f;
                xPos += 1.0f;
                zExtent = 1.0f;
            }
        }
        for (int i = 0; i < 5; ++i) {
            float smokeX = xPos + (rand.nextFloat() - 0.5f) * xExtent;
            float smokeY = yPos + rand.nextFloat() * 0.1f;
            float smokeZ = zPos + (rand.nextFloat() - 0.5f) * zExtent;
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void sawBlockInFront(World world, BlockPos pos, Random rand) {
        int harvestMeta;
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return;
        }
        BlockPos pos2 = pos.func_177972_a(this.getFacing((IBlockAccess)world, pos));
        Block block = world.func_180495_p(pos2).func_177230_c();
        if (SawInteraction.INSTANCE.contains(block, harvestMeta = block.func_180651_a(world.func_180495_p(pos2)))) {
            List<ItemStack> products = SawInteraction.INSTANCE.getProducts(block, harvestMeta);
            world.func_175698_g(pos2);
            if (!products.isEmpty()) {
                InvUtils.ejectStackWithOffset(world, pos2, products);
            }
            world.func_184133_a(null, pos2, SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 1.5f + rand.nextFloat() * 0.1f, 2.0f + rand.nextFloat() * 0.1f);
        }
    }

    @Override
    public boolean isMechanicalOnFromState(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ISACTIVE);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isMechanicalOn((IBlockAccess)world, pos)) {
            this.emitSawParticles(world, pos, rand);
            List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)));
            if (!entities.isEmpty() && entities.size() > 0) {
                this.emitBloodParticles(world, pos);
            }
        }
    }

    private void emitBloodParticles(World world, BlockPos pos) {
        EnumFacing facing = this.getFacing((IBlockAccess)world, pos);
        float xPos = pos.func_177958_n();
        float yPos = pos.func_177956_o();
        float zPos = pos.func_177952_p();
        float xExtent = 0.0f;
        float zExtent = 0.0f;
        switch (facing) {
            case DOWN: {
                xPos += 0.5f;
                zPos += 0.5f;
                xExtent = 1.0f;
                break;
            }
            case UP: {
                xPos += 0.5f;
                zPos += 0.5f;
                yPos += 1.0f;
                xExtent = 1.0f;
                break;
            }
            case NORTH: {
                xPos += 0.5f;
                yPos += 0.5f;
                xExtent = 1.0f;
                break;
            }
            case SOUTH: {
                xPos += 0.5f;
                yPos += 0.5f;
                zPos += 1.0f;
                xExtent = 1.0f;
                break;
            }
            case WEST: {
                yPos += 0.5f;
                zPos += 0.5f;
                zExtent = 1.0f;
                break;
            }
            default: {
                yPos += 0.5f;
                zPos += 0.5f;
                xPos += 1.0f;
                zExtent = 1.0f;
            }
        }
        for (int i = 0; i < 20; ++i) {
            float smokeX = xPos + (world.field_73012_v.nextFloat() - 0.5f) * xExtent;
            float smokeY = yPos + world.field_73012_v.nextFloat() * 0.1f;
            float smokeZ = zPos + (world.field_73012_v.nextFloat() - 0.5f) * zExtent;
            world.func_175688_a(EnumParticleTypes.REDSTONE, (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public IBlockState func_176203_a(int meta) {
        boolean isActive;
        boolean bl = isActive = meta > 7;
        if (isActive) {
            meta -= 8;
        }
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(isActive)).func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Boolean)state.func_177229_b((IProperty)ISACTIVE) != false ? 8 : 0;
        return meta += ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ISACTIVE, DirUtils.FACING});
    }
}

