/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWMBlocks;
import betterwithmods.BWMItems;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.items.ItemMaterial;
import betterwithmods.util.HardcoreFunctions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStump
extends Block
implements IMultiVariants {
    private static final int MIN_TRUNK_HEIGHT = 2;

    public BlockStump() {
        super(Material.field_151575_d);
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149711_c(6.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.OAK));
        this.setHarvestLevel("axe", 0);
    }

    public static boolean canPlaceStump(World worldIn, BlockPos position) {
        for (int i = 0; i < 2; ++i) {
            IBlockState state = worldIn.func_180495_p(position.func_177981_b(i));
            if (state.func_177230_c() != Blocks.field_150364_r && state.func_177230_c() != Blocks.field_150363_s) {
                return false;
            }
            if (i != 0 || !state.func_177228_b().containsKey((Object)BlockLog.field_176299_a) || state.func_177229_b((IProperty)BlockLog.field_176299_a) == BlockLog.EnumAxis.Y) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static IBlockState getStump(IBlockState log) {
        BlockPlanks.EnumType variant = HardcoreFunctions.getWoodType(log);
        if (variant == null) {
            return null;
        }
        return BWMBlocks.STUMP.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)variant);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (state.func_177228_b().containsKey((Object)BlockPlanks.field_176383_a)) {
            ret.add(new ItemStack(BWMItems.BARK, 1, ((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockPlanks.field_176383_a)).func_176839_a()));
        }
        for (int i = 0; i < 6; ++i) {
            ret.add(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST));
        }
        return ret;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        for (int i = 0; i < 4; ++i) {
            BlockStump.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST, 1));
        }
    }

    public MapColor func_180659_g(IBlockState state) {
        BlockPlanks.EnumType type = (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockPlanks.field_176383_a);
        return type.func_181070_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (BlockPlanks.EnumType blockplanks$enumtype : BlockPlanks.EnumType.values()) {
            list.add(new ItemStack(itemIn, 1, blockplanks$enumtype.func_176839_a()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockPlanks.field_176383_a, (Comparable)BlockPlanks.EnumType.func_176837_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockPlanks.field_176383_a)).func_176839_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockPlanks.field_176383_a});
    }

    public int func_180651_a(IBlockState state) {
        return ((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockPlanks.field_176383_a)).func_176839_a();
    }

    @Override
    public String[] getVariants() {
        ArrayList<String> variants = new ArrayList<String>();
        for (BlockPlanks.EnumType blockplanks$enumtype : BlockPlanks.EnumType.values()) {
            variants.add("variant=" + blockplanks$enumtype.func_176610_l());
        }
        return variants.toArray(new String[BlockPlanks.EnumType.values().length]);
    }
}

