/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.mini;

import betterwithmods.BWMBlocks;
import betterwithmods.blocks.BWMBlock;
import betterwithmods.blocks.BlockAesthetic;
import betterwithmods.blocks.mini.TileEntityMultiType;
import betterwithmods.util.InvUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMini
extends BWMBlock {
    public static final Material MINI = new Material(MapColor.field_151663_o);
    public static final PropertyInteger TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)6);
    public static final PropertyInteger ORIENTATION = BlockMini.createOrientation();

    public BlockMini(Material material, String name) {
        super(material);
        this.func_149672_a(material == MINI ? SoundType.field_185848_a : SoundType.field_185851_d);
        if (material == MINI) {
            this.setHarvestLevel("axe", 0);
        } else {
            this.setHarvestLevel("pickaxe", 0);
        }
    }

    public static PropertyInteger createOrientation() {
        return PropertyInteger.func_177719_a((String)"orientation", (int)0, (int)5);
    }

    public int getMaxOrientation() {
        return 5;
    }

    public boolean rotate(World world, BlockPos pos, IBlockState state, EntityPlayer player, PropertyInteger property) {
        boolean emptyHands;
        boolean bl = emptyHands = player.func_184586_b(EnumHand.MAIN_HAND) == null && player.func_184586_b(EnumHand.OFF_HAND) == null && player.func_70093_af();
        if (world.field_72995_K && emptyHands) {
            return true;
        }
        if (!world.field_72995_K && emptyHands) {
            int nextOrient = ((Integer)state.func_177229_b((IProperty)property) + 1) % (this.getMaxOrientation() + 1);
            world.func_184133_a(null, pos, this.getSoundType(state, world, pos, (Entity)player).func_185841_e(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            world.func_175656_a(pos, state.func_177226_a((IProperty)property, (Comparable)Integer.valueOf(nextOrient)));
            world.func_175685_c(pos, (Block)this);
            world.func_180497_b(pos, (Block)this, 10, 5);
            return true;
        }
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.rotate(world, pos, state, player, ORIENTATION);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack stack) {
        return this.metaBlockPlace(facing, hitX, hitY, hitZ);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityMultiType) {
            int meta = stack.func_77952_i();
            ((TileEntityMultiType)world.func_175625_s(pos)).setCosmeticType(meta);
            world.func_175656_a(pos, state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(meta)));
        }
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityMultiType) {
            return new ItemStack((Block)this, 1, ((TileEntityMultiType)world.func_175625_s(pos)).getCosmeticType());
        }
        return new ItemStack((Block)this, 1, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < 6; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        stack = new ItemStack((Block)this, 1, ((Integer)state.func_177229_b((IProperty)TYPE)).intValue());
        InvUtils.ejectStackWithOffset(world, pos, stack);
    }

    public abstract IBlockState metaBlockPlace(EnumFacing var1, float var2, float var3, float var4);

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityMultiType();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int type = 0;
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityMultiType) {
            type = ((TileEntityMultiType)world.func_175625_s(pos)).getCosmeticType();
        }
        return state.func_177226_a((IProperty)TYPE, (Comparable)Integer.valueOf(type));
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ORIENTATION, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)ORIENTATION);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, ORIENTATION});
    }

    public static enum EnumType {
        STONE(0, "stone", Blocks.field_150348_b),
        STONEBRICK(1, "stone_brick", Blocks.field_150417_aV),
        WHITESTONE(2, "whitestone", new ItemStack(BWMBlocks.AESTHETIC, 1, BlockAesthetic.EnumType.WHITESTONE.getMeta())),
        NETHERBRICK(3, "nether_brick", Blocks.field_150385_bj),
        BRICK(4, "brick", Blocks.field_150336_V),
        SANDSTONE(5, "sandstone", Blocks.field_150322_A);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final ItemStack block;

        private EnumType(int metaIn, String nameIn, Block blockIn) {
            this(metaIn, nameIn, new ItemStack(blockIn));
        }

        private EnumType(int metaIn, String nameIn, ItemStack blockIn) {
            this.meta = metaIn;
            this.name = nameIn;
            this.block = blockIn;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public int getMetadata() {
            return this.meta;
        }

        public String getName() {
            return this.name;
        }

        public ItemStack getBlock() {
            return this.block;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockmini$enumtype;
                EnumType.META_LOOKUP[blockmini$enumtype.getMetadata()] = blockmini$enumtype = enumTypeArray[i];
            }
        }
    }
}

