/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile;

import betterwithmods.BWMItems;
import betterwithmods.blocks.tile.TileEntityCookingPot;
import betterwithmods.craft.bulk.CraftingManagerBulk;
import betterwithmods.craft.bulk.CraftingManagerCauldron;
import betterwithmods.craft.bulk.CraftingManagerCauldronStoked;
import betterwithmods.items.ItemMaterial;
import betterwithmods.util.InvUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public class TileEntityCauldron
extends TileEntityCookingPot {
    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("CauldronCookTime")) {
            this.cookCounter = tag.func_74762_e("CauldronCookTime");
        }
        if (tag.func_74764_b("RenderCooldown")) {
            this.stokedCooldownCounter = tag.func_74762_e("RenderCooldown");
        }
        if (tag.func_74764_b("ContainsValidIngredients")) {
            this.containsValidIngredients = tag.func_74767_n("ContainsValidIngredients");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74768_a("CauldronCookTime", this.cookCounter);
        t.func_74768_a("RenderCooldown", this.stokedCooldownCounter);
        t.func_74757_a("ContainsValidIngredients", this.containsValidIngredients);
        return t;
    }

    @Override
    public void validateContents() {
        this.containsValidIngredients = false;
        if (this.fireIntensity > 0 && this.fireIntensity < 5) {
            if (InvUtils.getFirstOccupiedStackOfItem((IItemHandler)this.inventory, ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG)) > -1 && this.hasNonFoulFood()) {
                this.containsValidIngredients = true;
            } else if (CraftingManagerCauldron.getInstance().getCraftingResult(this.inventory) != null) {
                this.containsValidIngredients = true;
            }
        } else if (this.fireIntensity > 5) {
            if (this.containsExplosives()) {
                this.containsValidIngredients = true;
            } else if (CraftingManagerCauldronStoked.getInstance().getCraftingResult(this.inventory) != null) {
                this.containsValidIngredients = true;
            }
        }
    }

    @Override
    protected CraftingManagerBulk getCraftingManager(boolean stoked) {
        if (stoked) {
            return CraftingManagerCauldronStoked.getInstance();
        }
        return CraftingManagerCauldron.getInstance();
    }

    @Override
    protected boolean attemptToCookNormal() {
        int dung = InvUtils.getFirstOccupiedStackOfItem((IItemHandler)this.inventory, ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG));
        if (dung > -1 && this.hasNonFoulFood()) {
            return this.spoilFood();
        }
        return super.attemptToCookNormal();
    }

    private boolean hasNonFoulFood() {
        for (int i = 0; i < 27; ++i) {
            Item item;
            if (this.inventory.getStackInSlot(i) == null || (item = this.inventory.getStackInSlot(i).func_77973_b()) == null || !(item instanceof ItemFood)) continue;
            return true;
        }
        return false;
    }

    private boolean spoilFood() {
        boolean foodSpoiled = false;
        for (int i = 0; i < 27; ++i) {
            Item item;
            if (this.inventory.getStackInSlot(i) == null || (item = this.inventory.getStackInSlot(i).func_77973_b()) == null || item == BWMItems.FERTILIZER || !(item instanceof ItemFood)) continue;
            int stackSize = this.inventory.getStackInSlot((int)i).field_77994_a;
            ItemStack spoiled = new ItemStack(BWMItems.FERTILIZER, stackSize);
            this.inventory.setStackInSlot(i, spoiled);
            foodSpoiled = true;
        }
        return foodSpoiled;
    }

    @Override
    public String getName() {
        return "inv.cauldron.name";
    }
}

