/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile;

import betterwithmods.blocks.BlockMechMachines;
import betterwithmods.blocks.tile.SimpleItemStackHandler;
import betterwithmods.blocks.tile.TileEntityFilteredHopper;
import betterwithmods.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.craft.bulk.CraftingManagerBulk;
import betterwithmods.craft.heat.BWMHeatRegistry;
import betterwithmods.craft.heat.BWMHeatSource;
import betterwithmods.items.ItemMaterial;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import betterwithmods.util.MechanicalUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class TileEntityCookingPot
extends TileEntityVisibleInventory {
    public int cookCounter = 0;
    public int stokedCooldownCounter;
    public int scaledCookCounter = 0;
    public boolean containsValidIngredients = false;
    public int fireIntensity = -1;
    public int facing;
    private boolean forceValidation = true;

    public TileEntityCookingPot() {
        this.occupiedSlots = 0;
        this.facing = 1;
    }

    @Override
    public SimpleItemStackHandler createItemStackHandler() {
        return new SimpleItemStackHandler(this, true, 27);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.fireIntensity = tag.func_74764_b("fireIntensity") ? tag.func_74762_e("fireIntensity") : -1;
        this.facing = tag.func_74764_b("facing") ? tag.func_74762_e("facing") : 1;
        this.validateInventory();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74768_a("fireIntensity", this.fireIntensity);
        t.func_74768_a("facing", this.facing);
        return t;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMechMachines) {
            IBlockState state;
            boolean stateChanged;
            BlockMechMachines block = (BlockMechMachines)this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c();
            if (block.isCurrentStateValid(this.func_145831_w(), this.field_174879_c)) {
                this.func_145831_w().func_180497_b(this.field_174879_c, (Block)block, block.func_149738_a(this.func_145831_w()), 5);
            }
            boolean bl = stateChanged = (state = this.func_145831_w().func_180495_p(this.field_174879_c)).func_177229_b((IProperty)DirUtils.TILTING) != EnumFacing.func_82600_a((int)this.facing);
            if (this.func_145831_w() != null && stateChanged) {
                this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
            }
            if (this.fireIntensity != this.getFireIntensity()) {
                this.validateFireIntensity();
                this.forceValidation = true;
            }
            if (!block.isMechanicalOn((IBlockAccess)this.func_145831_w(), this.field_174879_c)) {
                this.facing = 1;
                this.entityCollision();
                if (this.fireIntensity > 0) {
                    if (this.forceValidation) {
                        this.validateContents();
                        this.forceValidation = false;
                    }
                    if (this.fireIntensity > 4) {
                        if (this.stokedCooldownCounter < 1) {
                            this.cookCounter = 0;
                        }
                        this.stokedCooldownCounter = 20;
                        this.performStokedFireUpdate(this.getCurrentFireIntensity());
                    } else if (this.stokedCooldownCounter > 0) {
                        --this.stokedCooldownCounter;
                        if (this.stokedCooldownCounter < 1) {
                            this.cookCounter = 0;
                        }
                    } else if (this.stokedCooldownCounter == 0 && this.fireIntensity > 0 && this.fireIntensity < 5) {
                        this.performNormalFireUpdate(this.getCurrentFireIntensity());
                    }
                } else {
                    this.cookCounter = 0;
                }
            } else {
                this.cookCounter = 0;
                EnumFacing power = EnumFacing.UP;
                if (((Boolean)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMechMachines.ISACTIVE)).booleanValue()) {
                    for (EnumFacing f : EnumFacing.field_176754_o) {
                        if (power != EnumFacing.UP) {
                            MechanicalUtil.destoryHorizontalAxles(this.func_145831_w(), this.func_174877_v().func_177972_a(f));
                        }
                        if (!MechanicalUtil.isBlockPoweredByAxleOnSide(this.func_145831_w(), this.field_174879_c, f) && !MechanicalUtil.isPoweredByCrankOnSide(this.func_145831_w(), this.field_174879_c, f)) continue;
                        power = f;
                    }
                }
                this.facing = power.func_176745_a();
                EnumFacing dumpToward = DirUtils.rotateFacingAroundY(power, false);
                if (power != EnumFacing.UP && this.filledSlots() > 0) {
                    this.ejectInventory(dumpToward);
                }
            }
        }
        this.validateInventory();
        this.scaledCookCounter = this.cookCounter * 1000 / 4350;
    }

    private void entityCollision() {
        boolean flag = false;
        if (!this.isFull()) {
            flag = this.captureDroppedItems();
        }
        if (flag) {
            this.func_145831_w().func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.func_145831_w()), 5);
            this.func_70296_d();
        }
    }

    private boolean isFull() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack != null && itemstack.field_77994_a == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public List<EntityItem> getCaptureItems(World worldIn, BlockPos pos) {
        return worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 1.0), EntitySelectors.field_94557_a);
    }

    private boolean captureDroppedItems() {
        List<EntityItem> items = this.getCaptureItems(this.func_145831_w(), this.func_174877_v());
        if (items.size() > 0) {
            boolean flag = false;
            for (EntityItem item : items) {
                flag = TileEntityFilteredHopper.putDropInInventoryAllSlots((IItemHandler)this.inventory, item) || flag;
            }
            if (flag) {
                this.func_145831_w().func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                if (this.validateInventory()) {
                    this.func_145831_w().func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.func_145831_w()), 5);
                }
                return true;
            }
        }
        return false;
    }

    public void ejectInventory(EnumFacing facing) {
        int index = InvUtils.getFirstOccupiedStackNotOfItem((IItemHandler)this.inventory, Items.field_151118_aC);
        if (index >= 0 && index < this.inventory.getSlots()) {
            boolean ejectIntoWorld;
            ItemStack stack = this.inventory.getStackInSlot(index);
            int ejectStackSize = 8;
            if (8 > stack.field_77994_a) {
                ejectStackSize = stack.field_77994_a;
            }
            BlockPos target = this.field_174879_c.func_177972_a(facing);
            ItemStack eject = new ItemStack(stack.func_77973_b(), ejectStackSize, stack.func_77952_i());
            InvUtils.copyTags(eject, stack);
            IBlockState targetState = this.func_145831_w().func_180495_p(target);
            boolean bl = ejectIntoWorld = this.func_145831_w().func_175623_d(target) || targetState.func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), target) || !targetState.func_185904_a().func_76220_a() || targetState.func_185900_c((IBlockAccess)this.func_145831_w(), (BlockPos)target).field_72337_e < 0.5;
            if (ejectIntoWorld) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.2f, ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.ejectStack(this.func_145831_w(), target, facing, eject);
                this.inventory.extractItem(index, ejectStackSize, false);
            }
        }
    }

    public void ejectStack(World world, BlockPos pos, EnumFacing facing, ItemStack stack) {
        BlockPos vec = new BlockPos(0, 0, 0).func_177972_a(facing);
        EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f) - (double)vec.func_177958_n() / 4.0, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5 - (double)vec.func_177952_p() / 4.0, stack);
        float velocity = 0.05f;
        item.field_70159_w = (float)vec.func_177958_n() * velocity;
        item.field_70181_x = (double)((float)vec.func_177956_o() * velocity) * 0.1;
        item.field_70179_y = (float)vec.func_177952_p() * velocity;
        item.func_174869_p();
        world.func_72838_d((Entity)item);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.forceValidation = true;
        if (this.func_145831_w() != null) {
            this.validateInventory();
        }
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public abstract void validateContents();

    protected abstract CraftingManagerBulk getCraftingManager(boolean var1);

    public int getCurrentFireIntensity() {
        int fireFactor = 0;
        if (this.fireIntensity > 0) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int meta;
                    int yPos = -1;
                    BlockPos target = this.field_174879_c.func_177982_a(x, yPos, z);
                    Block block = this.func_145831_w().func_180495_p(target).func_177230_c();
                    if (BWMHeatRegistry.get(block, meta = this.func_145831_w().func_180495_p(target).func_177230_c().func_180651_a(this.func_145831_w().func_180495_p(target))) == null) continue;
                    fireFactor += BWMHeatRegistry.get((Block)block, (int)meta).value;
                }
            }
            if (fireFactor < 5) {
                fireFactor = 5;
            }
        }
        return fireFactor;
    }

    private void performNormalFireUpdate(int fireIntensity) {
        if (this.containsValidIngredients) {
            this.cookCounter += fireIntensity;
            if (this.cookCounter >= 4350) {
                this.attemptToCookNormal();
                this.cookCounter = 0;
            }
        } else {
            this.cookCounter = 0;
        }
    }

    private void performStokedFireUpdate(int fireIntensity) {
        if (this.containsValidIngredients) {
            this.cookCounter += fireIntensity;
            if (this.cookCounter >= 4350) {
                if (this.containsExplosives()) {
                    this.explode();
                } else {
                    this.attemptToCookStoked();
                }
                this.cookCounter = 0;
            }
        } else {
            this.cookCounter = 0;
        }
    }

    protected boolean containsExplosives() {
        return this.containsItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST)) || this.containsItem(Item.func_150898_a((Block)Blocks.field_150335_W)) || this.containsItem(Items.field_151016_H) || this.containsItem(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BLASTING_OIL));
    }

    private boolean containsItem(Item item) {
        return this.containsItem(item, Short.MAX_VALUE);
    }

    private boolean containsItem(ItemStack stack) {
        return this.containsItem(stack.func_77973_b(), stack.func_77960_j());
    }

    private boolean containsItem(Item item, int meta) {
        return InvUtils.getFirstOccupiedStackOfItem((IItemHandler)this.inventory, item, meta) > -1;
    }

    private void explode() {
        int hellfire = InvUtils.countItemsInInventory((IItemHandler)this.inventory, ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST));
        float expSize = (float)hellfire * 10.0f / 64.0f;
        expSize += (float)InvUtils.countItemsInInventory((IItemHandler)this.inventory, Items.field_151016_H) * 10.0f / 64.0f;
        expSize += (float)InvUtils.countItemsInInventory((IItemHandler)this.inventory, ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BLASTING_OIL)) * 10.0f / 64.0f;
        if (InvUtils.countItemsInInventory((IItemHandler)this.inventory, Item.func_150898_a((Block)Blocks.field_150335_W)) > 0) {
            if (expSize < 4.0f) {
                expSize = 4.0f;
            }
            expSize += (float)InvUtils.countItemsInInventory((IItemHandler)this.inventory, Item.func_150898_a((Block)Blocks.field_150335_W));
        }
        if (expSize < 2.0f) {
            expSize = 2.0f;
        } else if (expSize > 10.0f) {
            expSize = 10.0f;
        }
        InvUtils.clearInventory((IItemHandlerModifiable)this.inventory);
        this.func_145831_w().func_175698_g(this.field_174879_c);
        this.func_145831_w().func_72876_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, expSize, true);
    }

    protected boolean attemptToCookNormal() {
        return this.attemptToCookWithManager(this.getCraftingManager(false));
    }

    protected boolean attemptToCookStoked() {
        return this.attemptToCookWithManager(this.getCraftingManager(true));
    }

    private boolean attemptToCookWithManager(CraftingManagerBulk man) {
        ItemStack[] output;
        if (man != null && man.getCraftingResult(this.inventory) != null && (output = man.craftItem(this.inventory)) != null) {
            for (ItemStack out : output) {
                ItemStack stack;
                if (out == null || InvUtils.addItemStackToInv((IItemHandler)this.inventory, stack = out.func_77946_l())) continue;
                InvUtils.ejectStackWithOffset(this.func_145831_w(), this.field_174879_c.func_177984_a(), stack);
            }
            return true;
        }
        return false;
    }

    public int getCookingProgressScaled(int scale) {
        return this.scaledCookCounter * scale / 1000;
    }

    public boolean isCooking() {
        return this.scaledCookCounter > 0;
    }

    private boolean validateInventory() {
        boolean stateChanged = false;
        byte currentSlots = (byte)InvUtils.getOccupiedStacks((IItemHandler)this.inventory);
        if (currentSlots != this.occupiedSlots) {
            this.occupiedSlots = currentSlots;
            stateChanged = true;
        }
        if (this.func_145831_w() != null && stateChanged) {
            IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
        }
        return stateChanged;
    }

    public int getFireIntensity() {
        int meta;
        BlockPos down = this.field_174879_c.func_177977_b();
        Block block = this.func_145831_w().func_180495_p(down).func_177230_c();
        BWMHeatSource source = BWMHeatRegistry.get(block, meta = block.func_180651_a(this.func_145831_w().func_180495_p(down)));
        if (source != null) {
            return source.value;
        }
        return -1;
    }

    private void validateFireIntensity() {
        int meta;
        BlockPos down = this.field_174879_c.func_177977_b();
        Block block = this.func_145831_w().func_180495_p(down).func_177230_c();
        BWMHeatSource source = BWMHeatRegistry.get(block, meta = block.func_180651_a(this.func_145831_w().func_180495_p(down)));
        this.fireIntensity = source != null ? source.value : -1;
    }

    @Override
    public int getMaxVisibleSlots() {
        return 27;
    }
}

