/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile;

import betterwithmods.BWMBlocks;
import betterwithmods.api.block.ISoulSensitive;
import betterwithmods.blocks.BlockMechMachines;
import betterwithmods.blocks.tile.IMechSubtype;
import betterwithmods.blocks.tile.SimpleItemStackHandler;
import betterwithmods.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.client.model.filters.ModelWithResource;
import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.craft.HopperFilters;
import betterwithmods.craft.HopperInteractions;
import betterwithmods.util.InvUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityFilteredHopper
extends TileEntityVisibleInventory
implements IMechSubtype {
    public short filterType = 0;
    public boolean outputBlocked = false;
    public byte power;
    public int soulsRetained = 0;
    private ItemStack filterStack;
    private int ejectCounter = 0;
    private int containedXP = 0;
    private int xpDropDelay = 10;
    private String filter;

    public TileEntityFilteredHopper() {
        this.occupiedSlots = 0;
        this.filterStack = null;
        this.filter = "";
    }

    public static ItemStack attemptToInsert(IItemHandler inv, ItemStack stack) {
        ItemStack leftover = null;
        for (int slot = 0; slot < inv.getSlots() - 1 && (leftover = inv.insertItem(slot, stack, false)) != null; ++slot) {
        }
        return leftover;
    }

    public static boolean putDropInInventoryAllSlots(IItemHandler inv, EntityItem entityItem) {
        boolean putAll = false;
        if (entityItem == null) {
            return false;
        }
        ItemStack itemstack = entityItem.func_92059_d().func_77946_l();
        ItemStack leftovers = TileEntityFilteredHopper.attemptToInsert(inv, itemstack);
        if (leftovers != null && leftovers.field_77994_a != 0) {
            entityItem.func_92058_a(leftovers);
        } else {
            putAll = true;
            entityItem.func_70106_y();
        }
        return putAll;
    }

    private static List<EntityXPOrb> getCollidingXPOrbs(World world, BlockPos pos) {
        return world.func_72872_a(EntityXPOrb.class, new AxisAlignedBB((double)pos.func_177958_n() - 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() - 0.5, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5));
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("EjectCounter")) {
            this.ejectCounter = tag.func_74762_e("EjectCounter");
        }
        if (tag.func_74764_b("XPCount")) {
            this.containedXP = tag.func_74762_e("XPCount");
        }
        if (tag.func_74764_b("FilterType")) {
            this.filterType = tag.func_74765_d("FilterType");
        }
        if (tag.func_74764_b("Souls")) {
            this.soulsRetained = tag.func_74762_e("Souls");
        }
        if (tag.func_74764_b("IsPowered")) {
            byte by = this.power = tag.func_74767_n("IsPowered") ? (byte)1 : 0;
        }
        if (tag.func_74764_b("FilterType")) {
            this.filter = tag.func_74779_i("FilterType");
        }
        this.validateInventory();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74768_a("EjectCounter", this.ejectCounter);
        t.func_74768_a("XPCount", this.containedXP);
        t.func_74777_a("FilterType", this.filterType);
        t.func_74768_a("Souls", this.soulsRetained);
        t.func_74757_a("IsPowered", this.power > 1);
        t.func_74778_a("FilterType", this.filter);
        return t;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!(this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMechMachines)) {
            return;
        }
        boolean isOn = false;
        if (this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMechMachines) {
            isOn = ((BlockMechMachines)BWMBlocks.SINGLE_MACHINES).isMechanicalOn((IBlockAccess)this.func_145831_w(), this.field_174879_c);
        }
        this.entityCollision();
        if (isOn) {
            this.attemptToEjectXPFromInv();
            if (!this.outputBlocked) {
                ++this.ejectCounter;
                if (this.ejectCounter > 2) {
                    this.attemptToEjectStackFromInv();
                    this.ejectCounter = 0;
                }
            } else {
                this.ejectCounter = 0;
            }
        } else {
            this.ejectCounter = 0;
            this.xpDropDelay = 0;
        }
        if (this.soulsRetained > 0) {
            this.processSouls();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145831_w() != null) {
            this.outputBlocked = false;
            this.validateInventory();
            this.setFilter(this.getFilterType());
        }
    }

    private void setFilter(short filter) {
        this.filterType = filter;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        int z;
        int y;
        int x = this.field_174879_c.func_177958_n();
        return player.func_70092_e((double)x + 0.5, (double)(y = this.field_174879_c.func_177956_o()) + 0.5, (double)(z = this.field_174879_c.func_177952_p()) + 0.5) <= 64.0;
    }

    private boolean validateInventory() {
        byte slotsOccupied;
        boolean stateChanged = false;
        short currentFilter = this.getFilterType();
        if (currentFilter != this.filterType) {
            this.filterType = currentFilter;
            stateChanged = true;
            if (this.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                ItemStack stack = ((IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)).getStackInSlot(18);
                if (stack != null) {
                    String check = stack.func_77973_b().toString() + stack.func_77960_j();
                    if (!this.filter.equals(check)) {
                        this.filter = check;
                        this.func_70296_d();
                    }
                } else {
                    this.filter = "";
                    this.func_70296_d();
                }
            }
        }
        if ((slotsOccupied = (byte)InvUtils.getOccupiedStacks((IItemHandler)this.inventory, 0, 17)) != this.occupiedSlots) {
            this.occupiedSlots = slotsOccupied;
            stateChanged = true;
        }
        if (this.func_145831_w() != null && stateChanged) {
            IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
        }
        return stateChanged;
    }

    private short getFilterType() {
        ItemStack filter = this.inventory.getStackInSlot(18);
        if (filter != null && filter.field_77994_a > 0) {
            this.filterStack = filter;
            return (short)HopperFilters.getFilterType(filter);
        }
        return 0;
    }

    private boolean canFilterProcessItem(ItemStack stack) {
        if (this.filterType > 0 && HopperFilters.getAllowedItems(this.filterType) != null) {
            return HopperFilters.getAllowedItems(this.filterType).test(stack);
        }
        return true;
    }

    private void entityCollision() {
        boolean flag = false;
        if (!this.isFull()) {
            flag = this.captureDroppedItems();
        }
        if (!this.isXPFull()) {
            if (this.captureXP()) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 1.0f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.45f);
            }
            boolean bl = flag = this.captureXP() || flag;
        }
        if (flag) {
            this.func_145831_w().func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.func_145831_w()), 5);
            this.func_70296_d();
        }
    }

    public List<EntityItem> getCaptureItems(World worldIn, BlockPos pos) {
        return worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 1.0), EntitySelectors.field_94557_a);
    }

    private boolean captureDroppedItems() {
        List<EntityItem> items = this.getCaptureItems(this.func_145831_w(), this.func_174877_v());
        if (items.size() > 0) {
            boolean flag = false;
            for (EntityItem item : items) {
                ItemStack stack = item.func_92059_d();
                if (HopperInteractions.attemptToCraft(this.filterType(), this.func_145831_w(), this.func_174877_v(), item)) {
                    this.func_145831_w().func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                if (!this.canFilterProcessItem(stack) || !(flag = TileEntityFilteredHopper.putDropInInventoryAllSlots((IItemHandler)this.inventory, item) || flag)) continue;
                this.func_145831_w().func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            if (flag) {
                this.func_145831_w().func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                if (this.validateInventory()) {
                    this.func_145831_w().func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.func_145831_w()), 5);
                }
                return true;
            }
        }
        return false;
    }

    private boolean captureXP() {
        List<EntityXPOrb> xpOrbs = TileEntityFilteredHopper.getCollidingXPOrbs(this.func_145831_w(), this.func_174877_v());
        if (xpOrbs.size() > 0 && this.filterType() == 6) {
            boolean flag = false;
            for (EntityXPOrb orb : xpOrbs) {
                flag = this.attemptToSwallowXPOrb(this.func_145831_w(), this.field_174879_c, orb) || flag;
            }
            if (flag) {
                return true;
            }
        }
        return false;
    }

    private boolean isXPFull() {
        return this.containedXP > 99;
    }

    private boolean isFull() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack != null && itemstack.field_77994_a == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private void attemptToEjectStackFromInv() {
        int stackIndex = InvUtils.getFirstOccupiedStackInRange((IItemHandler)this.inventory, 0, 17);
        if (stackIndex > -1 && stackIndex < 18) {
            List carts;
            ItemStack invStack = this.inventory.getStackInSlot(stackIndex);
            int ejectStackSize = 8;
            if (8 > invStack.field_77994_a) {
                ejectStackSize = invStack.field_77994_a;
            }
            ItemStack ejectStack = new ItemStack(invStack.func_77973_b(), ejectStackSize, invStack.func_77952_i());
            InvUtils.copyTags(ejectStack, invStack);
            BlockPos down = this.field_174879_c.func_177977_b();
            boolean ejectIntoWorld = false;
            if (this.func_145831_w().func_175623_d(down)) {
                ejectIntoWorld = true;
            } else if (this.func_145831_w().func_180495_p(down).func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), down)) {
                ejectIntoWorld = true;
            } else {
                Block block = this.func_145831_w().func_180495_p(down).func_177230_c();
                if (block == null || !block.func_176212_b((IBlockAccess)this.func_145831_w(), down, EnumFacing.UP) && (this.func_145831_w().func_175625_s(down) == null || !this.func_145831_w().func_175625_s(down).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP))) {
                    ejectIntoWorld = true;
                } else {
                    TileEntity tile = this.func_145831_w().func_175625_s(down);
                    if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                        IItemHandler below = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                        for (int slot = 0; slot < below.getSlots(); ++slot) {
                            ItemStack leftover = below.insertItem(slot, ejectStack, false);
                            if (leftover == null) {
                                this.inventory.extractItem(stackIndex, ejectStackSize, false);
                                break;
                            }
                            this.inventory.extractItem(stackIndex, ejectStack.field_77994_a - leftover.field_77994_a, false);
                            ejectStack = leftover;
                        }
                    } else if (tile != null) {
                        if (InvUtils.addItemStackToInv((IItemHandler)this.inventory, ejectStack) || ejectStack.field_77994_a != ejectStackSize) {
                            this.inventory.extractItem(stackIndex, ejectStackSize - ejectStack.field_77994_a, false);
                        }
                    } else {
                        this.outputBlocked = true;
                    }
                }
            }
            if (ejectIntoWorld && (carts = this.func_145831_w().func_72872_a(EntityMinecart.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() + 0.4f), (double)((float)this.field_174879_c.func_177956_o() - 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.4f), (double)((float)this.field_174879_c.func_177958_n() + 0.6f), (double)this.field_174879_c.func_177956_o(), (double)((float)this.field_174879_c.func_177952_p() + 0.6f)))) != null && carts.size() > 0) {
                for (EntityMinecart cart : carts) {
                    if (!cart.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
                    IItemHandler items = (IItemHandler)cart.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    int itemsStored = InvUtils.addItemStackToInv(items, ejectStack) || ejectStack.field_77994_a != ejectStackSize ? ejectStackSize - ejectStack.field_77994_a : ejectStackSize - ejectStack.field_77994_a;
                    if (itemsStored > 0) {
                        this.inventory.extractItem(stackIndex, itemsStored, false);
                        this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    ejectIntoWorld = false;
                    break;
                }
            }
            if (ejectIntoWorld) {
                this.ejectStack(ejectStack);
                this.inventory.extractItem(stackIndex, ejectStackSize, false);
                if (this.validateInventory()) {
                    this.func_145831_w().func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.func_145831_w()), 5);
                }
            }
        }
    }

    private void ejectStack(ItemStack stack) {
        float xOff = this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.45f;
        float yOff = -0.35f;
        float zOff = this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.45f;
        EntityItem item = new EntityItem(this.func_145831_w(), (double)((float)this.field_174879_c.func_177958_n() + xOff), (double)((float)this.field_174879_c.func_177956_o() + yOff), (double)((float)this.field_174879_c.func_177952_p() + zOff), stack);
        item.field_70159_w = 0.0;
        item.field_70181_x = -0.01f;
        item.field_70179_y = 0.0;
        item.func_174869_p();
        this.func_145831_w().func_72838_d((Entity)item);
    }

    private void attemptToEjectXPFromInv() {
        boolean shouldResetEjectCount = true;
        if (this.containedXP > 19) {
            BlockPos down = this.field_174879_c.func_177977_b();
            boolean canEjectIntoWorld = false;
            if (this.func_145831_w().func_175623_d(down)) {
                canEjectIntoWorld = true;
            } else {
                Block block = this.func_145831_w().func_180495_p(down).func_177230_c();
                int meta = block.func_180651_a(this.func_145831_w().func_180495_p(down));
                if (block instanceof BlockMechMachines && (meta == 4 || meta == 12)) {
                    shouldResetEjectCount = this.attemptToEjectXPIntoHopper(down);
                } else if (block.func_176200_f((IBlockAccess)this.func_145831_w(), down)) {
                    canEjectIntoWorld = true;
                } else if (!this.func_145831_w().func_180495_p(down).func_185904_a().func_76220_a()) {
                    canEjectIntoWorld = true;
                }
            }
            if (canEjectIntoWorld) {
                if (this.xpDropDelay < 1) {
                    this.ejectXPOrb(20);
                    this.containedXP -= 20;
                } else {
                    shouldResetEjectCount = false;
                }
            }
        }
        if (shouldResetEjectCount) {
            this.resetXPEjectCount();
        } else {
            --this.xpDropDelay;
        }
    }

    private boolean attemptToEjectXPIntoHopper(BlockPos pos) {
        int spaceRemaining;
        short filterType;
        TileEntityFilteredHopper tile = (TileEntityFilteredHopper)this.func_145831_w().func_175625_s(pos);
        if (tile != null && (filterType = tile.filterType) == 6 && (spaceRemaining = 100 - tile.containedXP) > 0) {
            if (this.xpDropDelay < 1) {
                int xpEjected = 20;
                if (spaceRemaining < xpEjected) {
                    xpEjected = spaceRemaining;
                }
                tile.containedXP += xpEjected;
                this.containedXP -= xpEjected;
            } else {
                return false;
            }
        }
        return true;
    }

    private void resetXPEjectCount() {
        this.xpDropDelay = 10 + this.func_145831_w().field_73012_v.nextInt(3);
    }

    private void ejectXPOrb(int value) {
        double xOff = this.func_145831_w().field_73012_v.nextDouble() * 0.1 + 0.45;
        double yOff = -0.2;
        double zOff = this.func_145831_w().field_73012_v.nextDouble() * 0.1 + 0.45;
        EntityXPOrb orb = new EntityXPOrb(this.func_145831_w(), (double)this.field_174879_c.func_177958_n() + xOff, (double)this.field_174879_c.func_177956_o() + yOff, (double)this.field_174879_c.func_177952_p() + zOff, value);
        orb.field_70159_w = 0.0;
        orb.field_70181_x = 0.0;
        orb.field_70179_y = 0.0;
        this.func_145831_w().func_72838_d((Entity)orb);
    }

    private boolean attemptToSwallowXPOrb(World world, BlockPos pos, EntityXPOrb entity) {
        int remainingSpace = 100 - this.containedXP;
        if (remainingSpace > 0 && entity.field_70530_e > 0) {
            if (entity.field_70530_e <= remainingSpace) {
                this.containedXP += entity.field_70530_e;
                entity.func_70106_y();
                return true;
            }
            entity.field_70530_e -= remainingSpace;
            this.containedXP = 100;
        }
        return false;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager mgr, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    private void processSouls() {
        boolean isOn = ((BlockMechMachines)BWMBlocks.SINGLE_MACHINES).isMechanicalOn((IBlockAccess)this.func_145831_w(), this.field_174879_c);
        BlockPos down = this.field_174879_c.func_177977_b();
        if (this.filterType == 6) {
            Block blockBelow = this.func_145831_w().func_180495_p(down).func_177230_c();
            if (this.soulsRetained > 0 && blockBelow instanceof ISoulSensitive && ((ISoulSensitive)blockBelow).isSoulSensitive((IBlockAccess)this.func_145831_w(), down)) {
                int soulsConsumed = ((ISoulSensitive)blockBelow).processSouls(this.func_145831_w(), down, this.soulsRetained);
                if (((ISoulSensitive)blockBelow).consumeSouls(this.func_145831_w(), down, soulsConsumed)) {
                    this.soulsRetained -= soulsConsumed;
                }
            } else if (isOn) {
                this.soulsRetained = 0;
            } else if (this.soulsRetained > 7) {
                if (this.spawnGhast()) {
                    this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_189105_bM, SoundCategory.BLOCKS, 1.0f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.8f);
                }
                if (this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() == BWMBlocks.SINGLE_MACHINES) {
                    ((BlockMechMachines)this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c()).breakHopper(this.func_145831_w(), this.field_174879_c);
                }
            }
        } else {
            this.soulsRetained = 0;
        }
    }

    private boolean spawnGhast() {
        EntityGhast ghast = new EntityGhast(this.func_145831_w());
        for (int i = 0; i < 200; ++i) {
            double xPos = (double)this.field_174879_c.func_177958_n() + (this.func_145831_w().field_73012_v.nextDouble() - this.func_145831_w().field_73012_v.nextDouble()) * 10.0;
            double yPos = this.field_174879_c.func_177956_o() + this.func_145831_w().field_73012_v.nextInt(21) - 10;
            double zPos = (double)this.field_174879_c.func_177952_p() + (this.func_145831_w().field_73012_v.nextDouble() - this.func_145831_w().field_73012_v.nextDouble()) * 10.0;
            ghast.func_70012_b(xPos, yPos, zPos, this.func_145831_w().field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!ghast.func_70601_bi()) continue;
            this.func_145831_w().func_72838_d((Entity)ghast);
            return true;
        }
        return false;
    }

    public void increaseSoulCount(int numSouls) {
        this.soulsRetained += numSouls;
    }

    @Override
    public SimpleItemStackHandler createItemStackHandler() {
        return new SimpleItemStackHandler(this, true, 19);
    }

    @Override
    public String getName() {
        return "inv.filtered_hopper.name";
    }

    @Override
    public int getSubtype() {
        return this.filterType;
    }

    @Override
    public void setSubtype(int type) {
        this.filterType = (short)Math.min(type, 7);
    }

    public int filterType() {
        return this.filterType;
    }

    @Override
    public int getMaxVisibleSlots() {
        return 18;
    }

    public ItemStack getFilterStack() {
        return this.filterStack;
    }

    public ModelWithResource getModel() {
        return RenderUtils.getModelFromStack(this.filter);
    }
}

