/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile;

import betterwithmods.api.block.IMechanical;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.api.capabilities.MechanicalCapability;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.blocks.BlockAdvGearbox;
import betterwithmods.util.MechanicalUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityGearbox
extends TileEntity
implements ITickable,
IMechanicalPower {
    private int powerLevel;
    private byte outputs;
    private int refreshTime = 0;

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 1;
    }

    public void func_73660_a() {
        if (this.func_145838_q() instanceof BlockAdvGearbox) {
            if (((BlockAdvGearbox)this.func_145838_q()).isGearboxOn((IBlockAccess)this.func_145831_w(), this.field_174879_c)) {
                if (this.refreshTime == 20) {
                    this.findOutputs();
                } else {
                    ++this.refreshTime;
                }
            } else if (this.powerLevel != 0) {
                this.powerLevel = 0;
            }
        }
    }

    private void findOutputs() {
        this.outputs = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (((BlockAdvGearbox)this.func_145838_q()).canInputPowerToSide((IBlockAccess)this.func_145831_w(), this.field_174879_c, facing)) {
                if (this.powerLevel == this.getMechanicalInput(facing)) continue;
                this.powerLevel = this.getMechanicalInput(facing);
                continue;
            }
            if (!MechanicalUtil.isAxle(this.func_145831_w().func_180495_p(this.field_174879_c.func_177972_a(facing)).func_177230_c())) continue;
            this.outputs = (byte)(this.outputs + 1);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        return capability == MechanicalCapability.MECHANICAL_POWER || super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == MechanicalCapability.MECHANICAL_POWER) {
            return (T)MechanicalCapability.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        if (this.func_145838_q() instanceof IMechanical && ((IMechanical)this.func_145838_q()).getMechPowerLevelToFacing(this.func_145831_w(), this.field_174879_c, facing) > 0) {
            if (this.outputs > 0) {
                return this.powerLevel / this.outputs;
            }
            return this.powerLevel;
        }
        return 0;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        int power = this.powerLevel;
        if (this.func_145838_q() instanceof IMechanicalBlock && ((IMechanicalBlock)this.func_145838_q()).canInputPowerToSide((IBlockAccess)this.func_145831_w(), this.func_174877_v(), facing)) {
            power = Math.min(MechanicalUtil.searchForAdvMechanical(this.func_145831_w(), this.func_174877_v(), facing), this.getMaximumInput(facing));
        }
        return power;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 100;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readFromTag(tag);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        this.writeToTag(t);
        return t;
    }

    @Override
    public void readFromTag(NBTTagCompound tag) {
        this.powerLevel = tag.func_74762_e("Power");
        this.outputs = tag.func_74771_c("Outputs");
    }

    @Override
    public NBTTagCompound writeToTag(NBTTagCompound tag) {
        tag.func_74768_a("Power", this.powerLevel);
        tag.func_74774_a("Outputs", this.outputs);
        return tag;
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

