/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile;

import betterwithmods.BWMBlocks;
import betterwithmods.BWSounds;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.blocks.BlockMechMachines;
import betterwithmods.blocks.tile.SimpleItemStackHandler;
import betterwithmods.blocks.tile.TileBasicInventory;
import betterwithmods.craft.bulk.CraftingManagerMill;
import betterwithmods.util.InvUtils;
import betterwithmods.util.MechanicalUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMill
extends TileBasicInventory
implements ITickable,
IMechanicalPower {
    public int grindCounter = 0;
    private int grindType = 0;
    private boolean validateContents = true;
    private boolean containsIngredientsToGrind;
    private int powerLevel;
    private int counter;

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 1;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        Block block = this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c();
        if (block == null || !(block instanceof BlockMechMachines)) {
            return;
        }
        BlockMechMachines mill = (BlockMechMachines)block;
        if (this.counter == 20) {
            this.powerLevel = this.getMechanicalInput(EnumFacing.DOWN);
            this.powerLevel = Math.min(this.powerLevel + this.getMechanicalInput(EnumFacing.UP), this.getMaximumInput(EnumFacing.UP));
            this.counter = 0;
        } else {
            ++this.counter;
        }
        if (this.validateContents) {
            this.validateContents();
        }
        if (mill.isMechanicalOn((IBlockAccess)this.func_145831_w(), this.field_174879_c) && this.func_145831_w().field_73012_v.nextInt(20) == 0) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, BWSounds.STONEGRIND, SoundCategory.BLOCKS, 0.5f + this.func_145831_w().field_73012_v.nextFloat() * 0.1f, 0.5f + this.func_145831_w().field_73012_v.nextFloat() * 0.1f);
        }
        if (this.containsIngredientsToGrind && mill.isMechanicalOn((IBlockAccess)this.func_145831_w(), this.field_174879_c)) {
            if (!this.func_145831_w().field_72995_K) {
                if (this.grindType == 2) {
                    if (this.func_145831_w().field_73012_v.nextInt(25) < 2) {
                        this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187555_bJ, SoundCategory.BLOCKS, 0.75f, this.func_145831_w().field_73012_v.nextFloat() * 0.4f + 0.8f);
                    }
                } else if (this.grindType == 3 && this.func_145831_w().field_73012_v.nextInt(20) < 2) {
                    this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187863_gH, SoundCategory.BLOCKS, 2.0f, (this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.2f + 1.0f);
                }
            }
            this.grindCounter += 1 + this.getGrindingBonus();
            if (this.grindCounter > 199) {
                this.grindContents();
                this.grindCounter = 0;
                this.validateContents = true;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("GrindCounter")) {
            this.grindCounter = tag.func_74762_e("GrindCounter");
        }
    }

    @Override
    public SimpleItemStackHandler createItemStackHandler() {
        return new SimpleItemStackHandler(this, true, 3);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("GrindCounter", this.grindCounter);
        return tag;
    }

    public int getGrindType() {
        return this.grindType;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            if (this.isCompanionCubeInInventory()) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187871_gL, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
            this.validateContents = true;
        }
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    private void ejectStack(ItemStack stack) {
        IBlockState down;
        ArrayList<EnumFacing> validDirections = new ArrayList<EnumFacing>();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            IBlockState check = this.func_145831_w().func_180495_p(this.field_174879_c.func_177972_a(facing));
            if (!check.func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), this.field_174879_c.func_177972_a(facing)) && !this.func_145831_w().func_175623_d(this.field_174879_c.func_177972_a(facing))) continue;
            validDirections.add(facing);
        }
        if (validDirections.isEmpty() && ((down = this.func_145831_w().func_180495_p(this.field_174879_c.func_177972_a(EnumFacing.DOWN))).func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), this.field_174879_c.func_177972_a(EnumFacing.DOWN)) || this.func_145831_w().func_175623_d(this.field_174879_c.func_177972_a(EnumFacing.DOWN)))) {
            validDirections.add(EnumFacing.DOWN);
        }
        BlockPos offset = validDirections.size() > 1 ? this.field_174879_c.func_177972_a((EnumFacing)validDirections.get(this.func_145831_w().field_73012_v.nextInt(validDirections.size()))) : (validDirections.isEmpty() ? this.field_174879_c.func_177972_a(EnumFacing.UP) : this.field_174879_c.func_177972_a((EnumFacing)validDirections.get(0)));
        InvUtils.ejectStackWithOffset(this.func_145831_w(), offset, stack);
    }

    public int getGrindProgressScaled(int scale) {
        return this.grindCounter * scale / 200;
    }

    public boolean isGrinding() {
        return this.grindCounter > 0;
    }

    public boolean isCompanionCubeInInventory() {
        for (int i = 0; i < 3; ++i) {
            Item item;
            if (this.inventory.getStackInSlot(i) == null || (item = this.inventory.getStackInSlot(i).func_77973_b()) == null || item != Item.func_150898_a((Block)BWMBlocks.WOLF)) continue;
            return true;
        }
        return false;
    }

    private boolean grindContents() {
        CraftingManagerMill mill = CraftingManagerMill.getInstance();
        List<Object> ingredients = mill.getValidCraftingIngredients(this.inventory);
        if (ingredients != null) {
            for (Object ingredient : ingredients) {
                Item item;
                ItemStack stack;
                if (!(ingredient instanceof ItemStack) || (stack = ((ItemStack)ingredient).func_77946_l()) == null || (item = stack.func_77973_b()) != Item.func_150898_a((Block)BWMBlocks.WOLF)) continue;
                this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187859_gF, SoundCategory.BLOCKS, 1.0f, 1.0f);
                break;
            }
            ItemStack[] output = mill.craftItem(this.inventory);
            assert (output != null && output.length > 0);
            for (ItemStack anOutput : output) {
                ItemStack stack = anOutput.func_77946_l();
                if (stack == null) continue;
                this.ejectStack(stack);
            }
            return true;
        }
        return false;
    }

    private void validateContents() {
        int oldGrindType = this.getGrindType();
        int newGrindType = 0;
        List<Object> ingredients = CraftingManagerMill.getInstance().getValidCraftingIngredients(this.inventory);
        if (ingredients != null) {
            this.containsIngredientsToGrind = true;
            newGrindType = 1;
            for (Object ingredient : ingredients) {
                ItemStack stack;
                if (!(ingredient instanceof ItemStack) || (stack = ((ItemStack)ingredient).func_77946_l()) == null) continue;
                Item item = stack.func_77973_b();
                if (item == Item.func_150898_a((Block)BWMBlocks.WOLF)) {
                    newGrindType = 3;
                } else {
                    if (item != Item.func_150898_a((Block)Blocks.field_150424_aL)) continue;
                    newGrindType = 2;
                }
                break;
            }
        } else {
            this.grindCounter = 0;
            this.containsIngredientsToGrind = false;
        }
        this.validateContents = false;
        if (oldGrindType != newGrindType) {
            this.grindType = newGrindType;
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("t", this.grindType);
        return new SPacketUpdateTileEntity(this.field_174879_c, 4, tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager mgr, SPacketUpdateTileEntity pkt) {
        if (!this.func_145831_w().field_72995_K) {
            return;
        }
        NBTTagCompound tag = pkt.func_148857_g();
        if (tag.func_74764_b("t")) {
            if (tag.func_74762_e("t") != this.grindType) {
                this.func_145831_w().func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.func_145831_w()), 5);
            }
            this.grindType = tag.func_74762_e("t");
        }
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return 0;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        int power = 0;
        if (this.func_145838_q() instanceof IMechanicalBlock && ((IMechanicalBlock)this.func_145838_q()).canInputPowerToSide((IBlockAccess)this.func_145831_w(), this.func_174877_v(), facing)) {
            power = Math.min(MechanicalUtil.searchForAdvMechanical(this.func_145831_w(), this.func_174877_v(), facing), this.getMaximumInput(facing));
        }
        return power;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 10;
    }

    @Override
    public void readFromTag(NBTTagCompound tag) {
        this.powerLevel = tag.func_74762_e("Power");
    }

    @Override
    public NBTTagCompound writeToTag(NBTTagCompound tag) {
        tag.func_74768_a("Power", this.powerLevel);
        return tag;
    }

    private int getGrindingBonus() {
        return this.powerLevel / 3;
    }
}

