/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile;

import betterwithmods.api.capabilities.SteamCapability;
import betterwithmods.api.tile.ISteamPower;
import betterwithmods.blocks.tile.TileEntityFilteredHopper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntitySteamPipe
extends TileEntity
implements ITickable,
ISteamPower {
    private int heatUnits = 0;
    private int steamPower = 0;
    private boolean update = false;
    private Random rand = new Random();

    public void func_73660_a() {
        List<EnumFacing> low;
        if (this.update) {
            this.calculateSteamPower(null);
            this.update = false;
        }
        if (!(low = this.findLowestTransfer(false)).isEmpty()) {
            int exits = low.size();
            EnumFacing facing = low.get(this.rand.nextInt(exits));
            TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tile == null || tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
                // empty if block
            }
        }
    }

    private List<EnumFacing> findLowestTransfer(boolean heat) {
        ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>();
        if (!heat) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null) continue;
                if (this.isPipelineExit(tile, facing)) {
                    dirs.add(facing);
                    continue;
                }
                if (!tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing) || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing) || !((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing)).canTransferItem()) continue;
                if (facing == EnumFacing.DOWN) {
                    if (((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing)).getSteamPower(facing.func_176734_d()) != 0) continue;
                    dirs.add(facing);
                    continue;
                }
                if (((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing)).getSteamPower(facing.func_176734_d()) >= this.steamPower) continue;
                dirs.add(facing);
            }
        } else {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile == null || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing) || facing == EnumFacing.DOWN || ((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing)).getSteamPower(facing.func_176734_d()) >= this.steamPower) continue;
                dirs.add(facing);
            }
        }
        return dirs;
    }

    @Override
    public void calculateSteamPower(EnumFacing facing) {
        TileEntity tile;
        int currentPower = this.steamPower;
        int highestNeighbor = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(side));
            if (side == EnumFacing.UP || tile == null || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, side) || ((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, side)).getSteamPower(side.func_176734_d()) <= highestNeighbor) continue;
            highestNeighbor = ((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, side)).getSteamPower(side.func_176734_d());
        }
        currentPower = highestNeighbor > currentPower ? highestNeighbor - 1 : (currentPower > 0 ? --currentPower : 0);
        if (this.steamPower != currentPower) {
            this.steamPower = currentPower;
            for (EnumFacing side : EnumFacing.field_82609_l) {
                tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(side));
                if (tile == null || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, side)) continue;
                ((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, side)).setSteamUpdate(true);
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readSteamPower(tag);
    }

    @Override
    public void readSteamPower(NBTTagCompound tag) {
        if (tag.func_74764_b("Steam")) {
            this.steamPower = tag.func_74762_e("Steam");
        }
        if (tag.func_74764_b("Heat")) {
            this.heatUnits = tag.func_74762_e("Heat");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        this.writeSteamPower(t);
        return t;
    }

    @Override
    public NBTTagCompound writeSteamPower(NBTTagCompound tag) {
        tag.func_74768_a("Steam", this.steamPower);
        tag.func_74768_a("Heat", this.heatUnits);
        return tag;
    }

    @Override
    public int getHeatUnits(EnumFacing facing) {
        int transfer = this.findLowestTransfer(true).size();
        if (transfer > 0) {
            return this.heatUnits / transfer;
        }
        return this.heatUnits;
    }

    @Override
    public int getSteamPower(EnumFacing facing) {
        return this.steamPower;
    }

    @Override
    public void calculateHeatUnits() {
        List<EnumFacing> low = this.findLowestTransfer(true);
        this.heatUnits = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile;
            if (low.contains(facing) || (tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing)) continue;
            this.heatUnits = ((ISteamPower)tile.getCapability(SteamCapability.STEAM_CAPABILITY, facing)).getHeatUnits(facing.func_176734_d());
        }
    }

    @Override
    public void setSteamUpdate(boolean update) {
        if (this.update != update) {
            this.update = update;
        }
    }

    private boolean isPipelineExit(TileEntity tile, EnumFacing facing) {
        return tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing) && !tile.hasCapability(SteamCapability.STEAM_CAPABILITY, facing) && !(tile instanceof TileEntityHopper) && !(tile instanceof TileEntityFilteredHopper);
    }

    @Override
    public boolean canTransferItem() {
        return true;
    }
}

