/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile;

import betterwithmods.BWMBlocks;
import betterwithmods.api.block.ITurnable;
import betterwithmods.blocks.BlockMechMachines;
import betterwithmods.blocks.tile.IMechSubtype;
import betterwithmods.craft.TurntableInteraction;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import betterwithmods.util.RecipeUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTurntable
extends TileEntity
implements IMechSubtype,
ITickable {
    private static final int[] ticksToRotate = new int[]{10, 20, 40, 80};
    public byte timerPos = 0;
    private int potteryRotation = 0;
    private boolean potteryRotated = false;
    private double[] offsets = new double[]{0.25, 0.375, 0.5, 0.625};
    private boolean asynchronous = false;
    private int rotationTime = 0;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("SwitchSetting")) {
            this.timerPos = tag.func_74771_c("SwitchSetting");
            if (this.timerPos > 3) {
                this.timerPos = (byte)3;
            }
        }
        if (tag.func_74764_b("PotteryRotation")) {
            this.potteryRotation = tag.func_74762_e("PotteryRotation");
        }
        if (tag.func_74764_b("Asynchronous")) {
            this.asynchronous = tag.func_74767_n("Asynchronous");
        }
        if (tag.func_74764_b("RotationTime")) {
            this.rotationTime = tag.func_74762_e("RotationTime");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("PotteryRotation", this.potteryRotation);
        tag.func_74774_a("SwitchSetting", this.timerPos);
        tag.func_74757_a("Asynchronous", this.asynchronous);
        if (this.asynchronous || this.rotationTime != 0) {
            tag.func_74768_a("RotationTime", this.rotationTime);
        }
        return tag;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() != null && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMechMachines && ((BlockMechMachines)this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c()).isMechanicalOn((IBlockAccess)this.func_145831_w(), this.field_174879_c)) {
            if (!this.asynchronous && this.func_145831_w().func_82737_E() % (long)ticksToRotate[this.timerPos] == 0L) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.05f, 1.0f);
                this.rotateTurntable();
            } else if (this.asynchronous) {
                ++this.rotationTime;
                if (this.rotationTime >= ticksToRotate[this.timerPos]) {
                    this.rotationTime = 0;
                    this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.05f, 1.0f);
                    this.rotateTurntable();
                }
            }
        }
    }

    public boolean processRightClick(EntityPlayer player) {
        if (player.func_184586_b(EnumHand.MAIN_HAND) != null) {
            if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_151113_aN) {
                this.toggleAsynchronous(player);
                return true;
            }
        } else if (player.func_184614_ca() == null) {
            this.advanceTimerPos();
            this.func_145831_w().func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.func_145831_w()), 5);
            this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.6f);
            return true;
        }
        return false;
    }

    public void toggleAsynchronous(EntityPlayer player) {
        if (!this.func_145831_w().func_82736_K().func_82766_b("doDaylightCycle")) {
            if (!this.asynchronous) {
                this.asynchronous = true;
            } else if (player != null) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("message.bwm:async.unavailable", new Object[0]));
            }
        } else {
            boolean async;
            boolean isSneaking = player.func_70093_af();
            String isOn = "enabled";
            boolean bl = async = !this.asynchronous;
            if (!async && !isSneaking || async && isSneaking) {
                isOn = "disabled";
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("message.bwm:async." + isOn, new Object[0]));
            if (!isSneaking) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.05f, 1.0f);
                this.asynchronous = async;
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager mgr, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void rotateTurntable() {
        boolean reverse = ((BlockMechMachines)this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c()).isRedstonePowered(this.func_145831_w(), this.field_174879_c);
        this.potteryRotated = false;
        for (int tempY = 1; tempY < 3; ++tempY) {
            BlockPos searchPos = this.field_174879_c.func_177982_a(0, tempY, 0);
            boolean canTransmitHorizontally = this.canBlockTransmitRotationHorizontally(searchPos);
            boolean canTransmitVertically = this.canBlockTransmitRotationVertically(searchPos);
            this.rotateBlock(searchPos, reverse);
            if (canTransmitHorizontally) {
                this.rotateBlocksAttached(searchPos, reverse);
            }
            if (!canTransmitVertically) break;
        }
        if (!this.potteryRotated) {
            this.potteryRotation = 0;
        }
        this.func_145831_w().func_180496_d(this.field_174879_c, BWMBlocks.SINGLE_MACHINES);
    }

    public byte getTimerPos() {
        return this.timerPos;
    }

    public double getOffset() {
        return this.offsets[this.timerPos];
    }

    public void advanceTimerPos() {
        this.timerPos = (byte)(this.timerPos + 1);
        if (this.timerPos > 3) {
            this.timerPos = 0;
        }
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    private boolean canBlockTransmitRotationHorizontally(BlockPos pos) {
        Block target = this.func_145831_w().func_180495_p(pos).func_177230_c();
        if (target instanceof ITurnable) {
            return ((ITurnable)target).canRotateHorizontally((IBlockAccess)this.func_145831_w(), pos);
        }
        if (target == Blocks.field_150359_w || target == Blocks.field_150399_cn) {
            return true;
        }
        if (target instanceof BlockPistonBase) {
            IBlockState state = this.func_145831_w().func_180495_p(pos);
            return (Boolean)state.func_177229_b((IProperty)BlockPistonBase.field_176320_b) == false;
        }
        if (target == Blocks.field_180384_M || target == Blocks.field_150332_K) {
            return false;
        }
        return this.func_145831_w().func_175677_d(pos, false);
    }

    private boolean canBlockTransmitRotationVertically(BlockPos pos) {
        Block target = this.func_145831_w().func_180495_p(pos).func_177230_c();
        if (target instanceof ITurnable) {
            return ((ITurnable)target).canRotateVertically((IBlockAccess)this.func_145831_w(), pos);
        }
        if (target == Blocks.field_150359_w) {
            return true;
        }
        if (target == Blocks.field_150435_aG) {
            return false;
        }
        if (target instanceof BlockPistonBase) {
            IBlockState state = this.func_145831_w().func_180495_p(pos);
            return (Boolean)state.func_177229_b((IProperty)BlockPistonBase.field_176320_b) == false;
        }
        if (target == Blocks.field_180384_M || target == Blocks.field_150332_K) {
            return false;
        }
        return this.func_145831_w().func_175677_d(pos, false);
    }

    private void rotateBlocksAttached(BlockPos pos, boolean reverse) {
        int i;
        Block[] newBlocks = new Block[4];
        for (i = 0; i < 4; ++i) {
            newBlocks[i] = null;
        }
        for (i = 2; i < 6; ++i) {
            EnumFacing facing;
            BlockPos offset = pos.func_177972_a(EnumFacing.func_82600_a((int)i));
            Block block = this.func_145831_w().func_180495_p(offset).func_177230_c();
            IBlockState state = this.func_145831_w().func_180495_p(offset);
            boolean attached = false;
            if (block instanceof BlockTorch) {
                facing = (EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a);
                if (facing == EnumFacing.func_82600_a((int)i)) {
                    attached = true;
                    if (block == Blocks.field_150437_az) {
                        block = Blocks.field_150429_aA;
                    }
                }
            } else if (block instanceof BlockLadder) {
                int meta = ((EnumFacing)state.func_177229_b((IProperty)BlockLadder.field_176382_a)).func_176745_a();
                if (meta == i) {
                    attached = true;
                }
            } else if (block == Blocks.field_150444_as) {
                int meta = ((EnumFacing)state.func_177229_b((IProperty)BlockWallSign.field_176412_a)).func_176745_a();
                if (meta == i) {
                    block.func_176226_b(this.func_145831_w(), offset, state, 0);
                    this.func_145831_w().func_175698_g(offset);
                }
            } else if (block instanceof BlockButton) {
                facing = (EnumFacing)state.func_177229_b((IProperty)BlockButton.field_176387_N);
                if (facing == EnumFacing.func_82600_a((int)i)) {
                    block.func_176226_b(this.func_145831_w(), offset, state, 0);
                    this.func_145831_w().func_175698_g(offset);
                }
            } else if (block == Blocks.field_150442_at && (facing = (BlockLever.EnumOrientation)state.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c() == EnumFacing.func_82600_a((int)i)) {
                block.func_176226_b(this.func_145831_w(), offset, state, 0);
                this.func_145831_w().func_175698_g(offset);
            }
            if (!attached) continue;
            EnumFacing destFacing = DirUtils.rotateFacingAroundY(EnumFacing.func_82600_a((int)i), reverse);
            newBlocks[destFacing.ordinal() - 2] = block;
            this.func_145831_w().func_175698_g(offset);
        }
        for (i = 0; i < 4; ++i) {
            int meta;
            Block block = newBlocks[i];
            if (block == null) continue;
            int facing = i + 2;
            BlockPos offset = pos.func_177972_a(EnumFacing.func_82600_a((int)facing));
            IBlockState state = this.func_145831_w().func_180495_p(offset);
            if (block instanceof BlockTorch) {
                int targetFacing = 0;
                if (facing == 2) {
                    targetFacing = 4;
                } else if (facing == 3) {
                    targetFacing = 3;
                } else if (facing == 4) {
                    targetFacing = 2;
                } else if (facing == 5) {
                    targetFacing = 1;
                }
                meta = targetFacing;
                state = ((BlockTorch)block).func_176203_a(meta);
            } else if (block instanceof BlockLadder) {
                meta = facing;
                state = ((BlockLadder)block).func_176203_a(meta);
            }
            if (this.func_145831_w().func_180495_p(offset).func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), offset)) {
                this.func_145831_w().func_175656_a(offset, state);
                continue;
            }
            EnumFacing oldFacing = DirUtils.rotateFacingAroundY(EnumFacing.func_82600_a((int)facing), !reverse);
            BlockPos oldPos = pos.func_177972_a(oldFacing);
            block.func_176226_b(this.func_145831_w(), oldPos, state, 0);
        }
    }

    private void rotateBlock(BlockPos pos, boolean reverse) {
        Rotation rot;
        if (this.func_145831_w().func_175623_d(pos)) {
            return;
        }
        IBlockState state = this.func_145831_w().func_180495_p(pos);
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state));
        Block target = state.func_177230_c();
        Rotation rotation = rot = reverse ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        if (TurntableInteraction.INSTANCE.contains(stack) && TurntableInteraction.INSTANCE.getRecipe(stack) != null) {
            if (target instanceof ITurnable) {
                ITurnable block = (ITurnable)target;
                if (block.canRotateOnTurntable((IBlockAccess)this.func_145831_w(), pos)) {
                    block.rotateAroundYAxis(this.func_145831_w(), pos, reverse);
                }
            } else if (state != state.func_185907_a(rot)) {
                this.func_145831_w().func_175656_a(pos, state.func_185907_a(rot));
            }
            this.rotateCraftable(state, (TurntableInteraction.TurntableRecipe)TurntableInteraction.INSTANCE.getRecipe(stack), pos, reverse);
            this.potteryRotated = true;
        } else if (target instanceof ITurnable) {
            ITurnable block = (ITurnable)target;
            if (block.canRotateOnTurntable((IBlockAccess)this.func_145831_w(), pos)) {
                block.rotateAroundYAxis(this.func_145831_w(), pos, reverse);
            }
        } else {
            BlockRailBase rail;
            BlockRailBase.EnumRailDirection dir;
            IBlockState newState = state.func_185907_a(rot);
            if (!(target instanceof BlockRailBase || target instanceof BlockPistonExtension || target instanceof BlockPistonMoving || state == newState)) {
                if (target instanceof BlockPistonBase) {
                    if (!((Boolean)state.func_177229_b((IProperty)BlockPistonBase.field_176320_b)).booleanValue()) {
                        this.func_145831_w().func_175656_a(pos, newState);
                    }
                } else {
                    this.func_145831_w().func_175656_a(pos, newState);
                }
            } else if (target instanceof BlockRailBase && (dir = (BlockRailBase.EnumRailDirection)state.func_177229_b((rail = (BlockRailBase)target).func_176560_l())) != BlockRailBase.EnumRailDirection.ASCENDING_NORTH && dir != BlockRailBase.EnumRailDirection.ASCENDING_EAST && dir != BlockRailBase.EnumRailDirection.ASCENDING_SOUTH && dir != BlockRailBase.EnumRailDirection.ASCENDING_WEST && state != newState) {
                this.func_145831_w().func_175656_a(pos, newState);
            }
        }
    }

    private void rotateCraftable(IBlockState input, TurntableInteraction.TurntableRecipe craft, BlockPos pos, boolean reverse) {
        Block block = input.func_177230_c();
        ++this.potteryRotation;
        if (this.potteryRotation > 7) {
            if (!craft.getOutputs().isEmpty() && craft.getOutputs().size() > 0) {
                for (ItemStack scrap : craft.getOutputs()) {
                    InvUtils.ejectStackWithOffset(this.func_145831_w(), pos.func_177984_a(), scrap.func_77946_l());
                }
            }
            this.func_145831_w().func_175656_a(pos, RecipeUtils.getStateFromStack(craft.getResult()));
            this.potteryRotation = 0;
        }
        this.func_145831_w().func_175688_a(EnumParticleTypes.BLOCK_DUST, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)input)});
        this.func_145831_w().func_184133_a(null, pos, block.getSoundType(input, this.func_145831_w(), pos, null).func_185841_e(), SoundCategory.BLOCKS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.8f);
    }

    @Override
    public int getSubtype() {
        return this.timerPos + 8;
    }

    @Override
    public void setSubtype(int type) {
        this.timerPos = (byte)Math.min(type, 3);
    }
}

