/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.container.other;

import betterwithmods.blocks.tile.TileEntityInfernalEnchanter;
import betterwithmods.items.ItemArcaneScroll;
import betterwithmods.util.InvUtils;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerInfernalEnchanter
extends Container {
    public int[] enchantLevels;
    public int xpSeed;
    private TileEntityInfernalEnchanter tile;
    private ItemStackHandler handler;

    public ContainerInfernalEnchanter(EntityPlayer player, TileEntityInfernalEnchanter tile) {
        int i;
        this.tile = tile;
        this.enchantLevels = new int[5];
        this.handler = new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                ContainerInfernalEnchanter.this.onContextChanged((IItemHandler)this);
            }
        };
        this.xpSeed = player.func_175138_ci();
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 0, 17, 37));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler, 1, 17, 75));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler(playerInv, j + i * 9 + 9, 8 + j * 18, 129 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(playerInv, i, 8 + i * 18, 187));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id > 0 && id < 3) {
            this.enchantLevels[id] = data;
        } else if (id == 3) {
            this.xpSeed = data;
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            this.broadcastData(listener);
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.broadcastData(listener);
    }

    public void broadcastData(IContainerListener listener) {
        listener.func_71112_a((Container)this, 0, this.enchantLevels[0]);
        listener.func_71112_a((Container)this, 1, this.enchantLevels[1]);
        listener.func_71112_a((Container)this, 2, this.enchantLevels[2]);
        listener.func_71112_a((Container)this, 3, this.xpSeed & 0xFFFFFFF0);
    }

    public void onContextChanged(IItemHandler handler) {
        ItemStack scroll = handler.getStackInSlot(0);
        ItemStack toEnchant = handler.getStackInSlot(1);
        Enchantment enchantment = null;
        int enchantCount = 1;
        int maxBookcase = this.tile.getBookcaseCount();
        if (scroll != null && toEnchant != null) {
            enchantment = scroll.func_77978_p() != null ? Enchantment.func_185262_c((int)scroll.func_77978_p().func_74762_e("enchant")) : null;
            enchantCount = EnchantmentHelper.func_82781_a((ItemStack)toEnchant).size() + 1;
            System.out.println(enchantment.func_77316_c(-1) + "," + enchantCount + "," + maxBookcase + "," + enchantment.func_77325_b());
        }
        for (int i = 1; i <= this.enchantLevels.length; ++i) {
            this.enchantLevels[i - 1] = enchantment == null || i > enchantment.func_77325_b() ? 0 : (int)Math.ceil(30 / Math.min(this.enchantLevels.length, enchantment.func_77325_b())) * i * enchantCount;
        }
        this.func_75142_b();
    }

    @Nullable
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack previous = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack current = slot.func_75211_c();
            previous = current.func_77946_l();
            try {
                if (index > 1 ? (current.func_77973_b() instanceof ItemArcaneScroll ? !this.func_75135_a(current, 0, 1, true) : !this.func_75135_a(current, 1, 2, true)) : !this.func_75135_a(current, 2, this.field_75151_b.size() - 2, false)) {
                    return null;
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            if (current.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (current.field_77994_a == previous.field_77994_a) {
                return null;
            }
            slot.func_82870_a(playerIn, current);
        }
        return previous;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (stack == null || playerIn.func_130014_f_().field_72995_K) continue;
            InvUtils.ejectStack(playerIn.func_130014_f_(), playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, stack);
        }
    }
}

