/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.config;

import betterwithmods.config.ConfigSyncHandler;
import betterwithmods.network.AbstractPacket;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ConfigSyncPacket
extends AbstractPacket {
    public final List<ConfigCategory> categories = Lists.newLinkedList();

    @Override
    public IMessage handleClient(NetHandlerPlayClient net) {
        ConfigSyncHandler.syncConfig(this.categories);
        return null;
    }

    @Override
    public IMessage handleServer(NetHandlerPlayServer net) {
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        short categoryCount = buf.readShort();
        for (short i = 0; i < categoryCount; i = (short)(i + 1)) {
            int propCount = buf.readInt();
            String categoryName = ByteBufUtils.readUTF8String((ByteBuf)buf);
            ConfigCategory category = new ConfigCategory(categoryName);
            this.categories.add(category);
            for (int j = 0; j < propCount; ++j) {
                String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
                char type = buf.readChar();
                String value = ByteBufUtils.readUTF8String((ByteBuf)buf);
                category.put(name, new Property(name, value, Property.Type.tryParse((char)type)));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.categories.size());
        for (ConfigCategory category : this.categories) {
            buf.writeInt(category.values().size());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)category.getName());
            for (Property prop : category.values()) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)prop.getName());
                buf.writeChar((int)prop.getType().getID());
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)prop.getString());
            }
        }
    }
}

