/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.craft;

import betterwithmods.BWMod;
import betterwithmods.craft.BlockMetaRecipe;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public abstract class BlockMetaHandler {
    private final ArrayList<BlockMetaRecipe> recipes = Lists.newArrayList();
    private final String type;

    public BlockMetaHandler(String type) {
        this.type = type;
    }

    public void addRecipe(ItemStack input, ItemStack ... products) {
        if (input.func_77973_b() != null && input.func_77973_b() instanceof ItemBlock) {
            this.addRecipe(((ItemBlock)input.func_77973_b()).func_179223_d(), input.func_77960_j(), products);
        } else {
            BWMod.logger.info("BlockMeta input: %s must be a block", new Object[]{input});
        }
    }

    public void addRecipe(Block block, int meta, ItemStack ... products) {
        this.addRecipe(new BlockMetaRecipe(this.type, block, meta, Arrays.asList(products)));
    }

    public void addRecipe(BlockMetaRecipe recipe) {
        this.recipes.add(recipe);
    }

    public boolean contains(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemBlock)) {
            return false;
        }
        return this.contains(((ItemBlock)stack.func_77973_b()).func_179223_d(), stack.func_77960_j());
    }

    public boolean contains(Block block, int meta) {
        return this.recipes.stream().filter(r -> r.equals(block, meta)).findFirst().isPresent();
    }

    public ArrayList<BlockMetaRecipe> getRecipes() {
        return this.recipes;
    }

    public BlockMetaRecipe getRecipe(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        assert (stack.func_77973_b() instanceof ItemBlock);
        return this.getRecipe(((ItemBlock)stack.func_77973_b()).func_179223_d(), stack.func_77960_j());
    }

    public BlockMetaRecipe getRecipe(Block block, int meta) {
        Optional<BlockMetaRecipe> recipe = this.recipes.stream().filter(r -> r.equals(block, meta)).findFirst();
        if (recipe.isPresent()) {
            return recipe.get();
        }
        return null;
    }

    public List<ItemStack> getProducts(Block block, int meta) {
        BlockMetaRecipe recipe = this.getRecipe(block, meta);
        if (recipe != null) {
            return recipe.getOutputs();
        }
        return null;
    }

    public List<BlockMetaRecipe> removeRecipes(ItemStack input) {
        ArrayList removed = Lists.newArrayList();
        for (BlockMetaRecipe ir : this.recipes) {
            if (!ir.getInput().func_77969_a(input)) continue;
            removed.add(ir);
        }
        return removed;
    }
}

