/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.craft;

import betterwithmods.util.InvUtils;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class DyeWithTagRecipe
extends ShapelessOreRecipe {
    private final ItemStack taggedItem;
    private final String dye;

    public DyeWithTagRecipe(ItemStack output, ItemStack taggedItem, String dye) {
        super(output, new Object[]{taggedItem, dye});
        this.taggedItem = taggedItem;
        this.dye = dye;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.isMatch((IInventory)inv);
    }

    private ItemStack getTagStack(IInventory inv) {
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack slot = inv.func_70301_a(x);
            if (!OreDictionary.itemMatches((ItemStack)this.taggedItem, (ItemStack)slot, (boolean)false)) continue;
            return slot.func_77946_l();
        }
        return null;
    }

    @Nonnull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack output = this.output.func_77946_l();
        ItemStack tagStack = this.getTagStack((IInventory)inv);
        if (tagStack != null && tagStack.func_77942_o()) {
            NBTTagCompound tag = tagStack.func_77978_p();
            if (tag != null) {
                output.func_77982_d(tag.func_74737_b());
            }
            return output;
        }
        return output;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isMatch(IInventory inv) {
        boolean hasItem = false;
        boolean hasDye = false;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            boolean inRecipe = false;
            ItemStack slot = inv.func_70301_a(x);
            if (slot == null) continue;
            if (OreDictionary.itemMatches((ItemStack)this.taggedItem, (ItemStack)slot, (boolean)false)) {
                if (hasItem) return false;
                hasItem = true;
                inRecipe = true;
            } else if (InvUtils.listContains(slot, OreDictionary.getOres((String)this.dye))) {
                if (hasDye) return false;
                hasDye = true;
                inRecipe = true;
            }
            if (inRecipe) continue;
            return false;
        }
        if (!hasItem) return false;
        if (!hasDye) return false;
        return true;
    }
}

