/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.craft;

import betterwithmods.BWMBlocks;
import betterwithmods.blocks.tile.SimpleItemStackHandler;
import betterwithmods.blocks.tile.TileEntityFilteredHopper;
import betterwithmods.items.ItemMaterial;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class HopperInteractions {
    public static final ArrayList<HopperRecipe> recipes = new ArrayList();

    public static boolean attemptToCraft(int filterType, World world, BlockPos pos, EntityItem input) {
        for (HopperRecipe recipe : recipes) {
            if (!recipe.isRecipe(filterType, input) || !recipe.canCraft(world, pos)) continue;
            recipe.craft(input, world, pos);
            return true;
        }
        return false;
    }

    static {
        recipes.add(new SoulUrn(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GROUND_NETHERRACK), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST)));
        recipes.add(new SoulUrn(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SOUL_DUST), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST)));
        recipes.add(new HopperRecipe(5, new ItemStack(Blocks.field_150351_n), new ItemStack(Items.field_151145_ak), new ItemStack[]{new ItemStack((Block)Blocks.field_150354_m), new ItemStack((Block)Blocks.field_150354_m, 1, 1)}){

            @Override
            public void craft(EntityItem inputStack, World world, BlockPos pos) {
                InvUtils.ejectStackWithOffset(world, inputStack.func_180425_c(), this.output.func_77946_l());
                TileEntityFilteredHopper tile = (TileEntityFilteredHopper)world.func_175625_s(pos);
                SimpleItemStackHandler inventory = tile.inventory;
                ItemStack sand = ((ItemStack)this.secondaryOutput.get(world.field_73012_v.nextInt(this.secondaryOutput.size()))).func_77946_l();
                if (!InvUtils.addItemStackToInv((IItemHandler)inventory, sand)) {
                    InvUtils.ejectStackWithOffset(world, inputStack.func_180425_c(), sand);
                }
                this.onCraft(world, pos, inputStack);
            }
        });
        recipes.add(new HopperRecipe(6, new ItemStack((Block)Blocks.field_150354_m, 1, Short.MAX_VALUE), null, new ItemStack[]{new ItemStack(Blocks.field_150425_aM)}){

            @Override
            public void craft(EntityItem inputStack, World world, BlockPos pos) {
                this.onCraft(world, pos, inputStack);
            }

            @Override
            public void onCraft(World world, BlockPos pos, EntityItem item) {
                TileEntityFilteredHopper hopper = (TileEntityFilteredHopper)world.func_175625_s(pos);
                int stackSize = hopper.soulsRetained;
                if (stackSize > item.func_92059_d().field_77994_a) {
                    stackSize = item.func_92059_d().field_77994_a;
                }
                hopper.soulsRetained -= stackSize;
                item.func_92059_d().field_77994_a -= stackSize;
                EntityItem soul = new EntityItem(world, item.field_70142_S, item.field_70137_T, item.field_70136_U, new ItemStack(Blocks.field_150425_aM, stackSize));
                if (!InvUtils.addItemStackToInv((IItemHandler)hopper.inventory, soul.func_92059_d())) {
                    soul.func_174869_p();
                    world.func_72838_d((Entity)soul);
                }
                if (item.func_92059_d().field_77994_a < 1) {
                    item.func_70106_y();
                }
            }
        });
    }

    public static abstract class HopperRecipe {
        final ItemStack input;
        final ItemStack output;
        final List<ItemStack> secondaryOutput;
        private final int filterType;

        public HopperRecipe(int filterType, ItemStack input, ItemStack output, ItemStack ... secondaryOutput) {
            this.filterType = filterType;
            this.input = input;
            this.output = output;
            this.secondaryOutput = Lists.newArrayList((Object[])secondaryOutput);
        }

        public boolean isRecipe(int filterType, EntityItem inputStack) {
            if (filterType == this.filterType) {
                if (inputStack != null) {
                    ItemStack i = inputStack.func_92059_d();
                    return i.func_77973_b().equals(this.input.func_77973_b()) && i.func_77960_j() == this.input.func_77960_j() && i.field_77994_a >= this.input.field_77994_a;
                }
                return false;
            }
            return false;
        }

        public void craft(EntityItem inputStack, World world, BlockPos pos) {
            InvUtils.ejectStackWithOffset(world, inputStack.func_180425_c(), this.output.func_77946_l());
            for (int i = 0; i < inputStack.func_92059_d().field_77994_a; ++i) {
                InvUtils.ejectStackWithOffset(world, inputStack.func_180425_c(), this.secondaryOutput);
            }
            this.onCraft(world, pos, inputStack);
        }

        public void onCraft(World world, BlockPos pos, EntityItem item) {
            --item.func_92059_d().field_77994_a;
            if (item.func_92059_d().field_77994_a <= 0) {
                item.func_70106_y();
            }
        }

        public int getFilterType() {
            return this.filterType;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public List<ItemStack> getSecondaryOutput() {
            return this.secondaryOutput;
        }

        public boolean canCraft(World world, BlockPos pos) {
            TileEntityFilteredHopper tile = (TileEntityFilteredHopper)world.func_175625_s(pos);
            SimpleItemStackHandler inventory = tile.inventory;
            boolean flag = true;
            if (!this.secondaryOutput.isEmpty()) {
                for (ItemStack stack : this.secondaryOutput) {
                    if (InvUtils.checkItemStackInsert((IItemHandler)inventory, stack)) continue;
                    flag = false;
                    break;
                }
            }
            return flag;
        }
    }

    public static class SoulUrn
    extends HopperRecipe {
        public SoulUrn(ItemStack input, ItemStack output) {
            super(6, input, output, new ItemStack(BWMBlocks.URN, 1, 8));
        }

        @Override
        public void craft(EntityItem inputStack, World world, BlockPos pos) {
            InvUtils.ejectStackWithOffset(world, inputStack.func_180425_c(), this.output.func_77946_l());
            this.onCraft(world, pos, inputStack);
        }

        @Override
        public void onCraft(World world, BlockPos pos, EntityItem item) {
            ((TileEntityFilteredHopper)world.func_175625_s(pos)).increaseSoulCount(item.func_92059_d().field_77994_a);
            if (!world.field_72995_K) {
                world.func_184133_a(null, pos, SoundEvents.field_187551_bH, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
            }
            super.onCraft(world, pos, item);
        }

        @Override
        public boolean canCraft(World world, BlockPos pos) {
            return true;
        }
    }
}

