/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.craft;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreStack {
    private final String oreName;
    private final List<ItemStack> oreStacks;
    private int stackSize;

    public OreStack(String name) {
        this(name, 1);
    }

    public OreStack(String name, int stack) {
        this.oreName = name;
        this.stackSize = stack;
        this.oreStacks = this.generateOreStacks(name, stack);
    }

    public OreStack(String name, int stack, ItemStack[] ores) {
        this.oreName = name;
        this.stackSize = stack;
        this.oreStacks = new ArrayList<ItemStack>();
        for (ItemStack ore : ores) {
            this.oreStacks.add(ore.func_77946_l());
        }
    }

    public OreStack copy() {
        return new OreStack(this.oreName, this.stackSize);
    }

    public String getOreName() {
        return this.oreName;
    }

    public List<ItemStack> getOres() {
        if (OreDictionary.getOres((String)this.oreName).size() > 0) {
            return OreDictionary.getOres((String)this.oreName);
        }
        return null;
    }

    private List<ItemStack> generateOreStacks(String name, int amount) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack stack : OreDictionary.getOres((String)name)) {
            items.add(new ItemStack(stack.func_77973_b(), amount, stack.func_77960_j()));
        }
        return items;
    }

    public void addToStack(int amount) {
        this.stackSize += amount;
    }

    public List<ItemStack> getOreStacks() {
        return this.oreStacks;
    }

    public int getStackSize() {
        return this.stackSize;
    }
}

