/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.craft.bulk;

import betterwithmods.craft.OreStack;
import betterwithmods.util.InvUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BulkRecipe {
    protected String type;
    protected ItemStack output = null;
    protected ItemStack secondary = null;
    protected ArrayList<Object> input = new ArrayList();
    protected ArrayList<List<ItemStack>> jeiInput = new ArrayList();

    public BulkRecipe(String type, ItemStack output, Object ... input) {
        this(type, output, null, input);
    }

    public BulkRecipe(String type, ItemStack output, ItemStack secondaryOutput, Object ... input) {
        this.type = type;
        this.output = output.func_77946_l();
        if (secondaryOutput != null) {
            this.secondary = secondaryOutput.func_77946_l();
        }
        int place = -1;
        ArrayList<Object> inputs = new ArrayList<Object>();
        for (Object in : input) {
            if (in instanceof Integer || in == null) continue;
            ++place;
            if (in instanceof ItemStack) {
                inputs.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                inputs.add(new ItemStack((Item)in, 1, Short.MAX_VALUE));
                continue;
            }
            if (in instanceof Block) {
                inputs.add(new ItemStack((Block)in, 1, Short.MAX_VALUE));
                continue;
            }
            if (in instanceof String) {
                if (place + 1 < input.length) {
                    if (input[place + 1] instanceof Integer) {
                        inputs.add(new OreStack((String)in, (Integer)input[place + 1]));
                        continue;
                    }
                    inputs.add(new OreStack((String)in, 1));
                    continue;
                }
                inputs.add(new OreStack((String)in, 1));
                continue;
            }
            if (in instanceof OreStack) {
                inputs.add(((OreStack)in).copy());
                continue;
            }
            String ret = "Invalid " + type + " recipe: ";
            for (Object tmp : input) {
                ret = ret + tmp + ", ";
            }
            ret = ret + "Output: " + output;
            if (secondaryOutput != null) {
                ret = ret + ", Secondary: " + secondaryOutput;
            }
            throw new RuntimeException(ret);
        }
        this.condenseInputs(inputs);
    }

    private void condenseInputs(ArrayList<Object> list) {
        ArrayList<Object> inputs = new ArrayList<Object>();
        ArrayList jeiInputs = new ArrayList();
        for (Object obj : list) {
            int contain = InvUtils.listContains(obj, inputs);
            if (contain > -1) {
                if (obj instanceof ItemStack) {
                    ((ItemStack)inputs.get((int)contain)).field_77994_a += ((ItemStack)obj).field_77994_a;
                    continue;
                }
                if (!(obj instanceof OreStack)) continue;
                ((OreStack)inputs.get(contain)).addToStack(((OreStack)obj).getStackSize());
                continue;
            }
            inputs.add(obj);
        }
        for (Object obj : inputs) {
            ArrayList<ItemStack> in = new ArrayList<ItemStack>();
            if (obj instanceof ItemStack) {
                in.add((ItemStack)obj);
            } else if (obj instanceof OreStack) {
                in.addAll(this.getOreList((OreStack)obj));
            }
            jeiInputs.add(in);
        }
        this.input = inputs;
        this.jeiInput = jeiInputs;
    }

    private List<ItemStack> getOreList(OreStack stack) {
        int stackSize = stack.getStackSize();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (stack.getOres() != null && !stack.getOres().isEmpty()) {
            for (ItemStack s : stack.getOres()) {
                list.add(new ItemStack(s.func_77973_b(), stackSize, s.func_77952_i()));
            }
        }
        return list;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack getSecondary() {
        return this.secondary;
    }

    public ArrayList<List<ItemStack>> getInput() {
        return this.jeiInput;
    }

    public ArrayList<Object> getRecipeInput() {
        return this.input;
    }

    public boolean matches(ItemStackHandler inv) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        if (required != null && required.size() > 0) {
            for (Object obj : required) {
                Object stack;
                if (!(obj instanceof ItemStack ? (stack = (ItemStack)obj) != null && InvUtils.countItemStacksInInventory((IItemHandler)inv, (ItemStack)stack) < ((ItemStack)stack).field_77994_a : obj instanceof OreStack && (stack = (OreStack)obj) != null && InvUtils.countOresInInventory((IItemHandler)inv, ((OreStack)stack).getOres()) < ((OreStack)stack).getStackSize())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matches(BulkRecipe recipe) {
        if (this.getOutput() != null && recipe.getOutput() != null) {
            boolean match = this.stacksMatch(this.getOutput(), recipe.getOutput());
            if (match && (this.getSecondary() != null || recipe.getSecondary() != null)) {
                boolean bl = match = this.getSecondary() != null && recipe.getSecondary() != null;
                if (match) {
                    match = this.stacksMatch(this.getSecondary(), recipe.getSecondary());
                }
            }
            return match;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public boolean consumeInvIngredients(ItemStackHandler inv) {
        boolean success = true;
        ArrayList<Object> required = this.input;
        if (required != null && required.size() > 0) {
            for (Object obj : required) {
                Object stack;
                if (obj instanceof ItemStack) {
                    stack = (ItemStack)obj;
                    if (stack == null || InvUtils.consumeItemsInInventory((IItemHandlerModifiable)inv, (ItemStack)stack, ((ItemStack)stack).field_77994_a)) continue;
                    success = false;
                    continue;
                }
                if (!(obj instanceof OreStack) || (stack = (OreStack)obj) == null || InvUtils.consumeOresInInventory((IItemHandlerModifiable)inv, ((OreStack)stack).getOres(), ((OreStack)stack).getStackSize())) continue;
                success = false;
            }
        }
        return success;
    }

    private boolean stacksMatch(ItemStack first, ItemStack second) {
        return first.func_77973_b() == second.func_77973_b() && first.func_77952_i() == second.func_77952_i() && first.field_77994_a == second.field_77994_a;
    }
}

