/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.craft.bulk;

import betterwithmods.craft.OreStack;
import betterwithmods.craft.bulk.BulkRecipe;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public abstract class CraftingManagerBulk {
    private final String craftType;
    private List<BulkRecipe> recipes;

    public CraftingManagerBulk(String craftType) {
        this.craftType = craftType;
        this.recipes = new ArrayList<BulkRecipe>();
    }

    public void addOreRecipe(ItemStack output, Object[] inputs) {
        this.addOreRecipe(output, (ItemStack)null, inputs);
    }

    public void addOreRecipe(ItemStack output, ItemStack secondary, Object input) {
        Object[] inputs = new Object[]{input};
        this.addOreRecipe(output, secondary, inputs);
    }

    public void addOreRecipe(ItemStack output, Object input) {
        this.addOreRecipe(output, null, input);
    }

    public void addOreRecipe(ItemStack output, ItemStack secondary, Object[] inputs) {
        BulkRecipe recipe = this.createRecipe(output, secondary, inputs);
        this.recipes.add(recipe);
    }

    public void addRecipe(ItemStack output, ItemStack[] inputs) {
        this.addRecipe(output, null, inputs);
    }

    public void addRecipe(ItemStack output, ItemStack secondary, ItemStack input) {
        ItemStack[] inputs = new ItemStack[]{input.func_77946_l()};
        this.addRecipe(output, secondary, inputs);
    }

    public void addRecipe(ItemStack output, ItemStack input) {
        this.addRecipe(output, null, input);
    }

    public void addRecipe(ItemStack output, ItemStack secondary, ItemStack[] inputs) {
        BulkRecipe recipe = this.createRecipe(output, secondary, inputs);
        this.recipes.add(recipe);
    }

    public List<BulkRecipe> removeRecipes(ItemStack output) {
        ArrayList removed = Lists.newArrayList();
        for (BulkRecipe ir : this.recipes) {
            if (!ir.getOutput().func_77969_a(output)) continue;
            removed.add(ir);
        }
        return removed;
    }

    public List<BulkRecipe> removeRecipes(ItemStack output, Object ... inputs) {
        ArrayList removed = Lists.newArrayList();
        for (BulkRecipe ir : this.recipes) {
            if (!ir.getOutput().func_77969_a(output)) continue;
            if (inputs.length > 0) {
                Object input;
                boolean match = true;
                Object[] objectArray = inputs;
                int n = objectArray.length;
                for (int i = 0; i < n && (match = this.hasMatch(input = objectArray[i], ir.getRecipeInput())); ++i) {
                }
                if (!match) continue;
                removed.add(ir);
                continue;
            }
            removed.add(ir);
        }
        return removed;
    }

    private boolean hasMatch(Object input, List<Object> inputs) {
        block3: {
            block2: {
                if (!(input instanceof String)) break block2;
                for (Object in : inputs) {
                    if (!(in instanceof OreStack ? input.equals(((OreStack)in).getOreName()) : in instanceof ItemStack && InvUtils.listContains((ItemStack)in, OreDictionary.getOres((String)((String)input))))) continue;
                    return true;
                }
                break block3;
            }
            if (!(input instanceof ItemStack)) break block3;
            for (Object in : inputs) {
                if (!(in instanceof ItemStack ? ((ItemStack)input).func_77969_a((ItemStack)in) : in instanceof OreStack && InvUtils.listContains((ItemStack)input, ((OreStack)in).getOres()))) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack[] getCraftingResult(ItemStackHandler inv) {
        BulkRecipe recipe = this.getMostValidRecipe(inv);
        if (recipe != null && recipe.matches(inv)) {
            ItemStack[] ret = new ItemStack[1];
            if (recipe.getSecondary() != null) {
                ret = new ItemStack[2];
                ret[1] = recipe.getSecondary();
            }
            ret[0] = recipe.getOutput();
            return ret;
        }
        return null;
    }

    private BulkRecipe getMostValidRecipe(ItemStackHandler inv) {
        HashMap<Integer, BulkRecipe> recipes = this.getValidRecipes(inv);
        if (!recipes.isEmpty()) {
            for (int i = 0; i < recipes.size(); ++i) {
                BulkRecipe recipe = recipes.get(i);
                if (!recipe.matches(inv)) continue;
                return recipe;
            }
        }
        return null;
    }

    private HashMap<Integer, BulkRecipe> getValidRecipes(ItemStackHandler inv) {
        HashMap<Integer, BulkRecipe> recipe = new HashMap<Integer, BulkRecipe>();
        int order = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            BulkRecipe single = null;
            if (inv.getStackInSlot(i) != null) {
                ItemStack stack = inv.getStackInSlot(i).func_77946_l();
                for (BulkRecipe r : this.recipes) {
                    if (!this.containsIngredient(r.getRecipeInput(), stack)) continue;
                    if (r.getRecipeInput().size() > 1) {
                        recipe.put(order, r);
                        ++order;
                        continue;
                    }
                    single = r;
                }
            }
            if (single == null) continue;
            recipe.put(order, single);
            ++order;
        }
        return recipe;
    }

    private boolean containsIngredient(List<Object> list, ItemStack stack) {
        for (Object obj : list) {
            if (obj instanceof ItemStack) {
                if (!ItemStack.func_179545_c((ItemStack)((ItemStack)obj), (ItemStack)stack) && (((ItemStack)obj).func_77952_i() != Short.MAX_VALUE || stack.func_77973_b() != ((ItemStack)obj).func_77973_b())) continue;
                return !((ItemStack)obj).func_77942_o() || ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)obj));
            }
            if (!(obj instanceof OreStack) || !InvUtils.listContains(stack, ((OreStack)obj).getOres())) continue;
            return true;
        }
        return false;
    }

    public List<Object> getValidCraftingIngredients(ItemStackHandler inv) {
        BulkRecipe recipe = this.getMostValidRecipe(inv);
        if (recipe != null) {
            return recipe.getRecipeInput();
        }
        return null;
    }

    public ItemStack[] craftItem(ItemStackHandler inv) {
        BulkRecipe recipe = this.getMostValidRecipe(inv);
        if (recipe != null) {
            ItemStack[] ret = new ItemStack[1];
            if (recipe.getSecondary() != null) {
                ret = new ItemStack[2];
                ret[1] = recipe.getSecondary();
            }
            if (recipe.getOutput() == null) {
                return null;
            }
            ret[0] = recipe.getOutput();
            recipe.consumeInvIngredients(inv);
            return ret;
        }
        return null;
    }

    private BulkRecipe createRecipe(ItemStack output, ItemStack secondary, Object[] inputs) {
        return new BulkRecipe(this.craftType, output, secondary, inputs);
    }

    private int getMatchingRecipeIndex(BulkRecipe recipe) {
        for (int i = 0; i < this.recipes.size(); ++i) {
            BulkRecipe tempRecipe = this.recipes.get(i);
            if (!tempRecipe.matches(recipe)) continue;
            return i;
        }
        return -1;
    }

    public List<BulkRecipe> getRecipes() {
        return this.recipes;
    }

    public void refreshRecipes() {
        List<BulkRecipe> recipes = this.getRecipes();
        if (!recipes.isEmpty()) {
            this.recipes = new ArrayList<BulkRecipe>();
            for (BulkRecipe r : recipes) {
                this.recipes.add(this.createRecipe(r.getOutput(), r.getSecondary(), r.input.toArray()));
            }
        }
    }
}

