/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.entity.item;

import betterwithmods.util.item.ItemExt;
import com.google.common.base.Optional;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityItemBuoy
extends EntityItem {
    public EntityItemBuoy(EntityItem orig) {
        super(orig.func_130014_f_(), orig.field_70165_t, orig.field_70163_u, orig.field_70161_v, orig.func_92059_d());
        NBTTagCompound originalData = new NBTTagCompound();
        orig.func_70014_b(originalData);
        this.func_70037_a(originalData);
        String thrower = orig.func_145800_j();
        EntityPlayer entity = thrower == null ? null : orig.func_130014_f_().func_72924_a(thrower);
        double tossSpeed = entity != null && entity.func_70051_ag() ? 2.0 : 1.0;
        this.field_70159_w = orig.field_70159_w * tossSpeed;
        this.field_70181_x = orig.field_70181_x * tossSpeed;
        this.field_70179_y = orig.field_70179_y * tossSpeed;
    }

    public EntityItemBuoy(World world) {
        super(world);
    }

    private void setAge(int age) {
        this.field_70292_b = age;
    }

    private int getAge0() {
        return this.field_70292_b;
    }

    private DataParameter<Optional<ItemStack>> getITEM() {
        return field_184533_c;
    }

    private int getPickupDelay() {
        return this.field_145804_b;
    }

    public void func_70071_h_() {
        ItemStack stack = (ItemStack)((Optional)this.func_184212_Q().func_187225_a(this.getITEM())).orNull();
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b().onEntityItemUpdate((EntityItem)this)) {
            return;
        }
        if (this.func_92059_d() == null) {
            this.func_70106_y();
        } else {
            boolean flag;
            if (!this.func_130014_f_().field_72995_K) {
                this.func_70052_a(6, this.func_184202_aL());
            }
            this.func_70030_z();
            if (this.getPickupDelay() > 0 && this.getPickupDelay() != Short.MAX_VALUE) {
                this.func_174867_a(this.getPickupDelay() - 1);
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.04f;
            }
            this.updateBuoy();
            this.field_70145_X = this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            boolean bl = flag = (int)this.field_70169_q != (int)this.field_70165_t || (int)this.field_70167_r != (int)this.field_70163_u || (int)this.field_70166_s != (int)this.field_70161_v;
            if (flag || this.field_70173_aa % 25 == 0) {
                if (this.func_130014_f_().func_180495_p(new BlockPos((Entity)this)).func_185904_a() == Material.field_151587_i) {
                    this.field_70181_x = 0.2f;
                    this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
                    this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
                    this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
                }
                if (!this.func_130014_f_().field_72995_K) {
                    this.func_85054_d();
                }
            }
            float f = 0.98f;
            if (this.field_70122_E) {
                f = this.func_130014_f_().func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.98f;
            }
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)f;
            if (this.field_70122_E) {
                this.field_70181_x *= -0.5;
            }
            if (this.getAge0() != Short.MIN_VALUE) {
                this.setAge(this.getAge0() + 1);
            }
            ItemStack item = (ItemStack)((Optional)this.func_184212_Q().func_187225_a(this.getITEM())).orNull();
            if (!this.func_130014_f_().field_72995_K && this.getAge0() >= this.lifespan) {
                int hook = ForgeEventFactory.onItemExpire((EntityItem)this, (ItemStack)item);
                if (hook < 0) {
                    this.func_70106_y();
                } else {
                    this.lifespan += hook;
                }
            }
            if (item != null && item.field_77994_a <= 0) {
                this.func_70106_y();
            }
        }
    }

    private void updateBuoy() {
        int maxIterations = 10;
        double waterAccumulator = 0.0;
        double offset = 0.1;
        for (int i = 0; i < 10; ++i) {
            double low = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)i * 0.375 + 0.1;
            double high = this.func_174813_aQ().field_72338_b + (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * (double)(i + 1) * 0.375 + 0.1;
            AxisAlignedBB boundingBox = new AxisAlignedBB(this.func_174813_aQ().field_72340_a, low, this.func_174813_aQ().field_72339_c, this.func_174813_aQ().field_72336_d, high, this.func_174813_aQ().field_72334_f);
            if (!this.func_130014_f_().func_72830_b(boundingBox, Material.field_151586_h)) break;
            waterAccumulator += 0.1;
        }
        if (waterAccumulator > 0.001) {
            if (!this.isDrifted()) {
                float buoyancy = ItemExt.getBuoyancy(this.func_92059_d()) + 1.0f;
                this.field_70181_x += 0.04 * (double)buoyancy * waterAccumulator;
            }
            this.field_70159_w *= 0.9;
            this.field_70181_x *= 0.9;
            this.field_70179_y *= 0.9;
        }
    }

    private boolean isDrifted() {
        int minX = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72340_a);
        int maxX = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72336_d + 1.0));
        int minY = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int maxY = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72337_e + 1.0));
        int minZ = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72334_f + 1.0));
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    if (!this.checkBlockDrifting(x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkBlockDrifting(int x, int y, int z) {
        for (int height = y - 1; height <= y + 1; ++height) {
            int meta;
            IBlockState blockState = this.func_130014_f_().func_180495_p(new BlockPos(x, height, z));
            if (blockState.func_177230_c() != Blocks.field_150358_i && blockState.func_177230_c() != Blocks.field_150355_j || (meta = blockState.func_177230_c().func_176201_c(blockState)) < 8) continue;
            return true;
        }
        return false;
    }
}

