/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.config.BWConfig;
import betterwithmods.util.HardcoreFunctions;
import betterwithmods.world.BWMapGenScatteredFeature;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BWMWorldGenEvent {
    public static boolean isInRadius(World world, BlockPos pos) {
        return BWMWorldGenEvent.isInRadius(world, pos.func_177958_n(), pos.func_177952_p());
    }

    public static boolean isInRadius(World world, int x, int z) {
        BlockPos center = world.func_175694_M();
        return Math.sqrt(Math.pow(x - center.func_177958_n(), 2.0) + Math.pow(z - center.func_177952_p(), 2.0)) < 2000.0;
    }

    @SubscribeEvent
    public void overrideScatteredFeature(InitMapGenEvent event) {
        if (!BWConfig.hardcoreStructures) {
            return;
        }
        if (event.getType().equals((Object)InitMapGenEvent.EventType.SCATTERED_FEATURE)) {
            event.setNewGen((MapGenBase)new BWMapGenScatteredFeature());
        }
    }

    @SubscribeEvent
    public void addStumpToTree(SaplingGrowTreeEvent event) {
        if (!BWConfig.hardcoreStumping) {
            return;
        }
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        if (state.func_177230_c() != Blocks.field_150345_g) {
            return;
        }
        event.setResult(Event.Result.DENY);
        HardcoreFunctions.generateTreeWithStump(event.getWorld(), event.getPos(), state, event.getRand());
    }
}

