/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.items.ItemBreedingHarness;
import betterwithmods.util.InvUtils;
import com.google.common.base.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BreedingHardnessEvent {
    private static final String TAG_HARNESS = "betterwithmods:harness";
    private static final DataParameter<Optional<ItemStack>> COW_DATA = EntityDataManager.func_187226_a(EntityCow.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Optional<ItemStack>> PIG_DATA = EntityDataManager.func_187226_a(EntityPig.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Optional<ItemStack>> SHEEP_DATA = EntityDataManager.func_187226_a(EntitySheep.class, (DataSerializer)DataSerializers.field_187196_f);

    private static DataParameter<Optional<ItemStack>> getHarnessData(Entity e) {
        if (e instanceof EntityCow) {
            return COW_DATA;
        }
        if (e instanceof EntityPig) {
            return PIG_DATA;
        }
        if (e instanceof EntitySheep) {
            return SHEEP_DATA;
        }
        return null;
    }

    public static boolean isValidAnimal(Entity animal) {
        return animal instanceof EntityCow || animal instanceof EntityPig || animal instanceof EntitySheep;
    }

    public static ItemStack getHarness(EntityLivingBase living) {
        return (ItemStack)((Optional)living.func_184212_Q().func_187225_a(BreedingHardnessEvent.getHarnessData((Entity)living))).orNull();
    }

    @SubscribeEvent
    public void onEntityInit(EntityEvent.EntityConstructing event) {
        if (BreedingHardnessEvent.isValidAnimal(event.getEntity())) {
            EntityDataManager manager = event.getEntity().func_184212_Q();
            manager.func_187214_a(BreedingHardnessEvent.getHarnessData(event.getEntity()), (Object)Optional.absent());
        }
    }

    @SubscribeEvent
    public void onEntity(EntityJoinWorldEvent e) {
        NBTTagCompound cmp;
        ItemStack nbtStack;
        EntityLiving animal;
        ItemStack dataStack;
        if (BreedingHardnessEvent.isValidAnimal(e.getEntity()) && (dataStack = (ItemStack)((Optional)(animal = (EntityLiving)e.getEntity()).func_184212_Q().func_187225_a(BreedingHardnessEvent.getHarnessData((Entity)animal))).orNull()) != (nbtStack = ItemStack.func_77949_a((NBTTagCompound)(cmp = animal.getEntityData().func_74775_l(TAG_HARNESS))))) {
            e.getEntity().func_184212_Q().func_187227_b(BreedingHardnessEvent.getHarnessData(e.getEntity()), (Object)Optional.of((Object)nbtStack));
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        Entity target = event.getTarget();
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        if (BreedingHardnessEvent.isValidAnimal(target) && !target.func_184188_bt().contains(player)) {
            EntityLiving animal = (EntityLiving)target;
            IItemHandlerModifiable playerInv = (IItemHandlerModifiable)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            ItemStack harness = BreedingHardnessEvent.getHarness((EntityLivingBase)animal);
            ItemStack held = player.func_184614_ca();
            if (harness != null) {
                if (held == null) {
                    InvUtils.addItemStackToInv((IItemHandler)playerInv, harness);
                    animal.func_184212_Q().func_187227_b(BreedingHardnessEvent.getHarnessData((Entity)animal), (Object)Optional.absent());
                    animal.getEntityData().func_74782_a(TAG_HARNESS, (NBTBase)new NBTTagCompound());
                    world.func_184133_a(null, animal.func_180425_c(), SoundEvents.field_187728_s, SoundCategory.NEUTRAL, 0.5f, 1.3f);
                    world.func_184133_a(null, animal.func_180425_c(), SoundEvents.field_187713_n, SoundCategory.NEUTRAL, 0.5f, 1.3f);
                }
            } else if (held != null && held.func_77973_b() instanceof ItemBreedingHarness) {
                if (BreedingHardnessEvent.getHarness((EntityLivingBase)animal) != null) {
                    return;
                }
                InvUtils.consumeItemsInInventory(playerInv, held, 1);
                ItemStack copyStack = held.func_77946_l();
                copyStack.field_77994_a = 1;
                NBTTagCompound cmp = new NBTTagCompound();
                copyStack.func_77955_b(cmp);
                animal.func_184212_Q().func_187227_b(BreedingHardnessEvent.getHarnessData((Entity)animal), (Object)Optional.of((Object)copyStack));
                animal.getEntityData().func_74782_a(TAG_HARNESS, (NBTBase)cmp);
                if (animal instanceof EntitySheep) {
                    ((EntitySheep)animal).func_70893_e(true);
                }
                world.func_184133_a(null, animal.func_180425_c(), SoundEvents.field_187728_s, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                world.func_184133_a(null, animal.func_180425_c(), SoundEvents.field_187713_n, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                player.func_184609_a(EnumHand.MAIN_HAND);
            }
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent e) {
        EntityLivingBase entity = e.getEntityLiving();
        if (BreedingHardnessEvent.isValidAnimal((Entity)entity)) {
            if (BreedingHardnessEvent.getHarness(entity) != null) {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(-1.0);
            } else {
                entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
            }
        }
    }
}

