/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.config.BWConfig;
import betterwithmods.util.DispenserBehaviorFiniteWater;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.RegistryDefaulted;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BucketEvent {
    public static void editModdedFluidDispenseBehavior() {
        if (!BWConfig.hardcoreFluidContainer) {
            return;
        }
        RegistryDefaulted reg = BlockDispenser.field_149943_a;
        for (Item item : Item.field_150901_e) {
            if (!BucketEvent.isFluidContainer(new ItemStack(item)) || !(reg.func_82594_a((Object)item) instanceof DispenseFluidContainer)) continue;
            BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)new DispenserBehaviorFiniteWater());
        }
    }

    private static boolean isFluidContainer(ItemStack stack) {
        return stack != null && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    private static boolean isNonVanillaBucket(ItemStack stack) {
        return stack.func_77973_b() != Items.field_151133_ar && stack.func_77973_b() != Items.field_151131_as && stack.func_77973_b() != Items.field_151129_at && stack.func_77973_b() != Items.field_151117_aB && BucketEvent.isFluidContainer(stack);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void fluidContainerUse(FillBucketEvent evt) {
        boolean dimValid;
        if (!BWConfig.hardcoreBuckets && !BWConfig.hardcoreFluidContainer) {
            return;
        }
        if (evt.getEmptyBucket() == null) {
            return;
        }
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)evt.getEmptyBucket());
        RayTraceResult target = evt.getTarget();
        EntityPlayer player = evt.getEntityPlayer();
        boolean bl = dimValid = evt.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD;
        if (dimValid && target != null && target.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = target.func_178782_a().func_177972_a(target.field_178784_b);
            IBlockState state = evt.getWorld().func_180495_p(pos);
            if (fluid != null && fluid.getFluid() != null && fluid.getFluid() == FluidRegistry.WATER && (state.func_177230_c().isAir(state, (IBlockAccess)evt.getWorld(), pos) || state.func_177230_c().func_176200_f((IBlockAccess)evt.getWorld(), pos)) && !player.field_71075_bZ.field_75098_d && (evt.getEmptyBucket().func_77973_b() == Items.field_151131_as && BWConfig.hardcoreBuckets || BucketEvent.isNonVanillaBucket(evt.getEmptyBucket()) && BWConfig.hardcoreFluidContainer)) {
                this.bucketEmpty(evt, pos, evt.getEmptyBucket());
            }
        }
    }

    private void bucketEmpty(FillBucketEvent evt, BlockPos pos, ItemStack equip) {
        if (this.isWater(evt.getWorld().func_180495_p(pos))) {
            IBlockState state = evt.getWorld().func_180495_p(pos);
            if (state.func_177230_c().func_176201_c(state) > 0) {
                this.emptyBucket(evt, pos, equip);
            }
        } else {
            this.emptyBucket(evt, pos, equip);
        }
    }

    private void emptyBucket(FillBucketEvent evt, BlockPos pos, ItemStack equip) {
        Item item = equip.func_77973_b();
        if (item.getContainerItem(equip) != null) {
            evt.getWorld().func_175656_a(pos, Blocks.field_150358_i.func_176203_a(2));
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos p2 = pos.func_177972_a(facing);
                if (this.isWater(evt.getWorld().func_180495_p(p2)) || !evt.getWorld().func_180495_p(p2).func_177230_c().isAir(evt.getWorld().func_180495_p(p2), (IBlockAccess)evt.getWorld(), p2) && !evt.getWorld().func_180495_p(p2).func_177230_c().func_176200_f((IBlockAccess)evt.getWorld(), p2)) continue;
                evt.getWorld().func_175656_a(p2, Blocks.field_150358_i.func_176203_a(5));
            }
            evt.getWorld().func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            evt.setFilledBucket(item.getContainerItem(equip).func_77946_l());
            evt.setResult(Event.Result.ALLOW);
        }
    }

    private boolean isWater(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i;
    }

    @SubscribeEvent
    public void fluidContainerUse(PlayerInteractEvent.RightClickBlock evt) {
        if (!BWConfig.hardcoreFluidContainer) {
            return;
        }
        ItemStack toCheck = evt.getEntityPlayer().func_184586_b(evt.getHand());
        if (toCheck == null || toCheck.func_77973_b() != Items.field_151131_as && !BucketEvent.isNonVanillaBucket(toCheck)) {
            return;
        }
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)toCheck);
        if (fluid == null || fluid.getFluid() == null || fluid.getFluid() != FluidRegistry.WATER) {
            return;
        }
        if (!evt.getWorld().field_72995_K) {
            Item item;
            evt.setUseBlock(Event.Result.DENY);
            IBlockState state = evt.getWorld().func_180495_p(evt.getPos());
            Block block = state.func_177230_c();
            boolean replaceable = block.func_176200_f((IBlockAccess)evt.getWorld(), evt.getPos());
            BlockPos pos = replaceable ? evt.getPos() : evt.getPos().func_177972_a(evt.getFace());
            state = evt.getWorld().func_180495_p(pos);
            if (evt.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD && !block.func_180639_a(evt.getWorld(), evt.getPos(), state, evt.getEntityPlayer(), evt.getHand(), toCheck, evt.getFace(), 0.5f, 0.5f, 0.5f) && (state.func_177230_c().isAir(state, (IBlockAccess)evt.getWorld(), pos) || state.func_177230_c().func_176200_f((IBlockAccess)evt.getWorld(), pos) || !state.func_185904_a().func_76220_a()) && (item = toCheck.func_77973_b()).func_77661_b(toCheck) == EnumAction.NONE) {
                if (this.isWater(state)) {
                    if (state.func_177230_c().func_176201_c(state) > 0) {
                        this.placeContainerFluid(evt, pos, toCheck);
                    }
                } else {
                    state.func_177230_c().func_176226_b(evt.getWorld(), pos, state, 0);
                    this.placeContainerFluid(evt, pos, toCheck);
                }
            }
        }
    }

    private void placeContainerFluid(PlayerInteractEvent.RightClickBlock evt, BlockPos pos, ItemStack equip) {
        if (!evt.getEntityPlayer().field_71075_bZ.field_75098_d && equip.func_77973_b().hasContainerItem(equip)) {
            Item item = equip.func_77973_b();
            evt.getWorld().func_175656_a(pos, Blocks.field_150358_i.func_176203_a(2));
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos p2 = pos.func_177972_a(facing);
                if (this.isWater(evt.getWorld().func_180495_p(p2)) || !evt.getWorld().func_180495_p(p2).func_177230_c().isAir(evt.getWorld().func_180495_p(p2), (IBlockAccess)evt.getWorld(), p2) && !evt.getWorld().func_180495_p(p2).func_177230_c().func_176200_f((IBlockAccess)evt.getWorld(), p2)) continue;
                evt.getWorld().func_175656_a(p2, Blocks.field_150358_i.func_176203_a(5));
            }
            if (equip.field_77994_a == 1) {
                EnumHand hand = evt.getHand();
                evt.getEntityPlayer().func_184201_a(hand == EnumHand.OFF_HAND ? EntityEquipmentSlot.OFFHAND : EntityEquipmentSlot.MAINHAND, item.getContainerItem(equip).func_77946_l());
            } else if (equip.field_77994_a > 1) {
                --equip.field_77994_a;
                if (item.hasContainerItem(equip)) {
                    evt.getEntityPlayer().field_71071_by.func_70441_a(item.getContainerItem(equip).func_77946_l());
                }
                evt.setUseItem(Event.Result.DENY);
            }
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void checkPlayerInventory(TickEvent.PlayerTickEvent e) {
        World world = e.player.func_130014_f_();
        if (BWConfig.hardcoreLavaBuckets && world.func_82737_E() % 10L == 0L && !e.player.func_70644_a(MobEffects.field_76426_n)) {
            IItemHandler inv = (IItemHandler)e.player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            BlockPos pos = e.player.func_180425_c();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (world.field_73012_v.nextInt(50) != 0 || stack == null || !stack.func_77969_a(new ItemStack(Items.field_151129_at))) continue;
                IFluidHandler bucket = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                bucket.drain(1000, true);
                world.func_184133_a(e.player, pos, SoundEvents.field_187627_L, SoundCategory.PLAYERS, 1.0f, 1.0f);
                this.placeLavaBucket(world, pos.func_177972_a(e.player.func_174811_aO()), 0);
            }
        }
    }

    public void placeLavaBucket(World world, BlockPos pos, int depth) {
        if (depth >= 5) {
            return;
        }
        if (world.func_175623_d(pos)) {
            world.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
        } else {
            this.placeLavaBucket(world, pos.func_177972_a(EnumFacing.field_82609_l[world.field_73012_v.nextInt(6)]), depth++);
        }
    }

    @SubscribeEvent
    public void onFillBucket(FillBucketEvent e) {
        if (BWConfig.hardcoreLavaBuckets) {
            Block block;
            if (e.getEntityPlayer().func_70644_a(MobEffects.field_76426_n)) {
                return;
            }
            if (e.getTarget() != null && e.getTarget().func_178782_a() != null && ((block = e.getWorld().func_180495_p(e.getTarget().func_178782_a()).func_177230_c()) == Blocks.field_150353_l || block == Blocks.field_150356_k)) {
                e.getEntityPlayer().func_70097_a(DamageSource.field_76371_c, 1.0f);
                e.getWorld().func_184133_a(null, e.getTarget().func_178782_a(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.5f);
                e.setCanceled(true);
            }
        }
    }
}

