/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.BWMBlocks;
import betterwithmods.BWMod;
import betterwithmods.client.gui.GuiHunger;
import betterwithmods.config.BWConfig;
import betterwithmods.util.BWMFoodStats;
import betterwithmods.util.player.EntityPlayerExt;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class HungerEventHandler {
    private static GuiHunger guiHunger = null;

    @SubscribeEvent
    public void replaceHungerGui(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD) {
            if (!(Minecraft.func_71410_x().field_71439_g.func_71024_bL() instanceof BWMFoodStats)) {
                return;
            }
            event.setCanceled(true);
            if (guiHunger == null) {
                guiHunger = new GuiHunger();
            }
            guiHunger.draw();
        }
    }

    @SubscribeEvent
    public void replaceFoodSystem(EntityJoinWorldEvent event) {
        if (!BWConfig.hardcoreHunger) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            this.applyFoodSystem(player);
        }
    }

    private void setFoodStats(EntityPlayer player, FoodStats foodStats) {
        ReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)foodStats, (String[])new String[]{"field_71100_bB", "foodStats"});
    }

    private void applyFoodSystem(EntityPlayer player) {
        if (player.func_71024_bL() instanceof BWMFoodStats) {
            return;
        }
        BWMFoodStats newFS = new BWMFoodStats(player);
        NBTTagCompound compound = player.getEntityData();
        newFS.func_75112_a(compound);
        this.setFoodStats(player, newFS);
        BWMod.logger.debug("Custom food system " + (Object)((Object)newFS) + " applied on " + player.func_70005_c_() + ".");
    }

    private void revertFoodSystem(EntityPlayer player) {
        if (!(player.func_71024_bL() instanceof BWMFoodStats)) {
            return;
        }
        BWMFoodStats originalFS = (BWMFoodStats)player.func_71024_bL();
        FoodStats newFS = new FoodStats();
        NBTTagCompound compound = player.getEntityData();
        newFS.func_75112_a(compound);
        if (compound.func_74764_b("bwmAdjustedFoodStats")) {
            newFS.func_75114_a(originalFS.func_75116_a() / 3);
            compound.func_74757_a("bwmAdjustedFoodStats", false);
            newFS.func_75117_b(compound);
        }
        this.setFoodStats(player, newFS);
        BWMod.logger.debug("Vanilla food system " + newFS + " applied on " + player.func_70005_c_() + ".");
    }

    @SubscribeEvent
    public void saveFoodSystem(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!(event.player.func_71024_bL() instanceof BWMFoodStats)) {
            return;
        }
        event.player.func_71024_bL().func_75117_b(event.player.getEntityData());
    }

    @SubscribeEvent
    public void onFood(LivingEntityUseItemEvent.Start event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        if (!(event.getItem().func_77973_b() instanceof ItemFood)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!(player.func_71024_bL() instanceof BWMFoodStats)) {
            return;
        }
        if (player.func_70644_a(MobEffects.field_76438_s)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void breakSpeedPenalty(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!(player.func_71024_bL() instanceof BWMFoodStats)) {
            return;
        }
        IBlockState state = event.getState();
        float f = player.field_71071_by.func_184438_a(state);
        if (state.func_177230_c() == BWMBlocks.STUMP) {
            f = 1.0f;
        }
        if (f > 1.0f) {
            int i = EnchantmentHelper.func_185293_e((EntityLivingBase)player);
            ItemStack itemstack = player.func_184614_ca();
            if (i > 0 && itemstack != null) {
                float intermediate = i * i + 1;
                f = !itemstack.func_150998_b(state) && f <= 1.0f ? (f += intermediate * 0.08f) : (f += intermediate);
            }
        }
        if (player.func_70644_a(MobEffects.field_76422_e)) {
            f *= 1.0f + (float)(player.func_70660_b(MobEffects.field_76422_e).func_76458_c() + 1) * 0.2f;
        }
        if (player.func_70644_a(MobEffects.field_76419_f)) {
            float f1;
            switch (player.func_70660_b(MobEffects.field_76419_f).func_76458_c()) {
                case 0: {
                    f1 = 0.3f;
                    break;
                }
                case 1: {
                    f1 = 0.09f;
                    break;
                }
                case 2: {
                    f1 = 0.0027f;
                    break;
                }
                default: {
                    f1 = 8.1E-4f;
                }
            }
            f *= f1;
        }
        if (player.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_185287_i((EntityLivingBase)player)) {
            f /= 5.0f;
        }
        if (!player.field_70122_E) {
            f /= 5.0f;
        }
        f *= EntityPlayerExt.getHealthAndExhaustionModifier(player);
        if (BWConfig.hardcoreHardness) {
            boolean canHarvestBlock = ForgeHooks.canHarvestBlock((Block)state.func_177230_c(), (EntityPlayer)player, (IBlockAccess)player.func_130014_f_(), (BlockPos)event.getPos());
            if (!EntityPlayerExt.isCurrentToolEffectiveOnBlock(player, event.getPos())) {
                f = !canHarvestBlock ? (f *= 0.5f) : (f *= 0.15f);
            }
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        event.setNewSpeed(f);
    }

    @SubscribeEvent
    public void walkingPenalty(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!EntityPlayerExt.isSurvival(player)) {
            return;
        }
        if (!(player.func_71024_bL() instanceof BWMFoodStats)) {
            return;
        }
        UUID penaltySpeedUUID = UUID.fromString("c5595a67-9410-4fb2-826a-bcaf432c6a6f");
        EntityPlayerExt.changeSpeed((EntityLivingBase)player, penaltySpeedUUID, "Health speed penalty", EntityPlayerExt.getHealthAndExhaustionModifier(player));
    }

    @SubscribeEvent
    public void swimmingPenalty(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!EntityPlayerExt.isSurvival(player)) {
            return;
        }
        if (!(player.func_71024_bL() instanceof BWMFoodStats)) {
            return;
        }
        if (player.func_70090_H() && !EntityPlayerExt.canSwim(player) && !EntityPlayerExt.isNearBottom(player)) {
            player.field_70181_x -= 0.02;
        }
    }

    @SubscribeEvent
    public void jumpingPenalty(LivingEvent.LivingJumpEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!EntityPlayerExt.isSurvival(player)) {
            return;
        }
        if (!(player.func_71024_bL() instanceof BWMFoodStats)) {
            return;
        }
        if (!EntityPlayerExt.canJump(player)) {
            event.getEntityLiving().field_70159_w = 0.0;
            event.getEntityLiving().field_70181_x = 0.0;
            event.getEntityLiving().field_70179_y = 0.0;
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        if (!BWConfig.hardcoreHunger) {
            return;
        }
        EntityPlayer player = event.getEntity();
        if (!(player.func_71024_bL() instanceof BWMFoodStats)) {
            return;
        }
        float modifier = EntityPlayerExt.getHealthAndExhaustionModifier(player);
        float f = 1.0f;
        if (player.field_71075_bZ.field_75100_b) {
            f *= 1.1f;
        }
        IAttributeInstance iattributeinstance = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
        double oldAttributeValue = iattributeinstance.func_111126_e() / (double)modifier;
        f = (float)((double)f * ((oldAttributeValue / (double)player.field_71075_bZ.func_75094_b() + 1.0) / 2.0));
        if (player.field_71075_bZ.func_75094_b() == 0.0f || Float.isNaN(f) || Float.isInfinite(f)) {
            f = 1.0f;
        }
        if (player.func_184587_cr() && player.func_184607_cu() != null && player.func_184607_cu().func_77973_b() == Items.field_151031_f) {
            int i = player.func_184612_cw();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            f *= 1.0f - f1 * 0.15f;
        }
        event.setNewfov(f);
    }
}

