/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.BWMBlocks;
import betterwithmods.BWMItems;
import betterwithmods.api.block.IDebarkable;
import betterwithmods.config.BWConfig;
import betterwithmods.craft.SawInteraction;
import betterwithmods.items.ItemMaterial;
import betterwithmods.items.tools.ItemKnife;
import betterwithmods.util.InvUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class LogHarvestEvent {
    public static IRecipe findMatchingRecipe(InventoryCrafting inv, World world) {
        for (int i = 0; i < CraftingManager.func_77594_a().func_77592_b().size(); ++i) {
            IRecipe recipe = (IRecipe)CraftingManager.func_77594_a().func_77592_b().get(i);
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe;
        }
        return null;
    }

    @SubscribeEvent
    public void debarkLog(PlayerInteractEvent.RightClickBlock evt) {
        World world = evt.getWorld();
        if (!world.field_72995_K) {
            BlockPos pos = evt.getPos();
            EntityPlayer player = evt.getEntityPlayer();
            Block block = world.func_180495_p(pos).func_177230_c();
            ItemStack playerStack = player.func_184586_b(evt.getHand());
            if (playerStack == null) {
                return;
            }
            BlockPos playerPos = pos.func_177972_a(evt.getFace());
            if (!(playerStack == null || !playerStack.func_77973_b().getToolClasses(playerStack).contains("axe") || playerStack.func_77973_b().getToolClasses(playerStack).contains("pickaxe") && playerStack.func_77973_b().getToolClasses(playerStack).contains("shovel"))) {
                if (block == Blocks.field_150364_r) {
                    IBlockState state = world.func_180495_p(pos);
                    IBlockState dbl = BWMBlocks.DEBARKED_OLD.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, state.func_177229_b((IProperty)BlockLog.field_176299_a)).func_177226_a((IProperty)BlockOldLog.field_176301_b, state.func_177229_b((IProperty)BlockOldLog.field_176301_b));
                    InvUtils.ejectStackWithOffset(world, playerPos, ((IDebarkable)dbl.func_177230_c()).getBark(dbl));
                    world.func_175656_a(pos, dbl);
                    world.func_184133_a(null, pos, SoundEvents.field_187927_ha, SoundCategory.BLOCKS, 0.5f, 2.5f);
                    playerStack.func_77972_a(1, (EntityLivingBase)player);
                } else if (block == Blocks.field_150363_s) {
                    IBlockState state = world.func_180495_p(pos);
                    IBlockState dbl = BWMBlocks.DEBARKED_NEW.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, state.func_177229_b((IProperty)BlockLog.field_176299_a)).func_177226_a((IProperty)BlockNewLog.field_176300_b, state.func_177229_b((IProperty)BlockNewLog.field_176300_b));
                    InvUtils.ejectStackWithOffset(world, playerPos, ((IDebarkable)dbl.func_177230_c()).getBark(dbl));
                    world.func_175656_a(pos, dbl);
                    world.func_184133_a(null, pos, SoundEvents.field_187927_ha, SoundCategory.BLOCKS, 0.5f, 2.5f);
                    playerStack.func_77972_a(1, (EntityLivingBase)player);
                } else {
                    IBlockState state = world.func_180495_p(pos);
                    if (SawInteraction.INSTANCE.contains(block, block.func_176201_c(state)) && InvUtils.listContains(new ItemStack(block, 1, block.func_180651_a(state)), OreDictionary.getOres((String)"logWood"))) {
                        InvUtils.ejectStackWithOffset(world, playerPos, new ItemStack(BWMItems.BARK, 1, 0));
                        IBlockState dbl = BWMBlocks.DEBARKED_OLD.func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
                        world.func_175656_a(pos, dbl);
                        world.func_184133_a(null, pos, SoundEvents.field_187927_ha, SoundCategory.BLOCKS, 0.5f, 2.5f);
                        playerStack.func_77972_a(1, (EntityLivingBase)player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void harvestLog(BlockEvent.HarvestDropsEvent evt) {
        EntityPlayer player = evt.getHarvester();
        if (!BWConfig.hardcoreLumber || player == null) {
            return;
        }
        if (player.func_180431_b(DamageSource.field_76367_g)) {
            return;
        }
        IBlockState state = evt.getState();
        Block block = state.func_177230_c();
        int harvestMeta = state.func_177230_c().func_180651_a(state);
        World world = evt.getWorld();
        if (!world.field_72995_K && !evt.isSilkTouching()) {
            Item item;
            boolean harvest = false;
            if (player != null && player.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && (item = player.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b()) != null && (item.getHarvestLevel(player.func_184582_a(EntityEquipmentSlot.MAINHAND), "axe", player, state) >= 0 || item.getToolClasses(player.func_184582_a(EntityEquipmentSlot.MAINHAND)).contains("axe")) && !(item instanceof ItemKnife)) {
                harvest = true;
            }
            if (!harvest) {
                int fortune = player != null && player.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && player.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemKnife ? evt.getFortuneLevel() : 0;
                boolean fort = fortune > 0;
                List logs = OreDictionary.getOres((String)"logWood");
                boolean isLog = logs.stream().filter(stack -> stack.func_77969_a(new ItemStack(block, 1, Short.MAX_VALUE))).findAny().isPresent();
                if (SawInteraction.INSTANCE.contains(block, harvestMeta) && isLog && !evt.isSilkTouching()) {
                    for (ItemStack logStack : evt.getDrops()) {
                        ItemBlock iBlock;
                        if (!(logStack.func_77973_b() instanceof ItemBlock) || (iBlock = (ItemBlock)logStack.func_77973_b()).func_179223_d() != block) continue;
                        List<ItemStack> outputs = SawInteraction.INSTANCE.getProducts(block, harvestMeta);
                        ArrayList newOutputs = Lists.newArrayList();
                        if (outputs.size() == 3) {
                            ItemStack planks = outputs.get(0).func_77946_l();
                            planks.field_77994_a = planks.field_77994_a / 2 + (fort ? world.field_73012_v.nextInt(2) : 0);
                            int barkStack = fort ? outputs.get((int)1).field_77994_a + world.field_73012_v.nextInt(fortune) : outputs.get((int)1).field_77994_a;
                            ItemStack bark = new ItemStack(outputs.get(1).func_77973_b(), barkStack, outputs.get(1).func_77952_i());
                            int sawdustStack = fort ? 1 + world.field_73012_v.nextInt(fortune) : 1;
                            ItemStack sawdust = ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST, sawdustStack);
                            newOutputs.add(planks);
                            newOutputs.add(bark);
                            newOutputs.add(sawdust);
                        }
                        evt.getDrops().remove(logStack);
                        evt.getDrops().addAll(newOutputs);
                        break;
                    }
                }
            }
        }
    }
}

