/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.BWMBlocks;
import betterwithmods.BWMItems;
import betterwithmods.blocks.BlockAesthetic;
import betterwithmods.config.BWConfig;
import betterwithmods.entity.EntityShearedCreeper;
import betterwithmods.items.ItemMaterial;
import betterwithmods.util.InvUtils;
import betterwithmods.util.player.EntityPlayerExt;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MobDropEvent {
    private static final int[] fearLevel = new int[]{1600, 1500, 1400, 1300, 1200, 1100, 1000, 900, 800, 700, 600, 500, 400, 300, 200, 100};
    private static final Random rand = new Random();
    public static FakePlayer player;

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load evt) {
        if (evt.getWorld() instanceof WorldServer) {
            player = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)evt.getWorld()));
            ItemStack sword = new ItemStack(Items.field_151048_u);
            sword.func_77966_a(Enchantment.func_180305_b((String)"looting"), 2);
            player.func_184611_a(EnumHand.MAIN_HAND, sword);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload evt) {
        if (evt.getWorld() instanceof WorldServer && player != null) {
            player.func_184611_a(EnumHand.MAIN_HAND, null);
            player = null;
        }
    }

    @SubscribeEvent
    public void mobDungProduction(LivingEvent.LivingUpdateEvent evt) {
        if (evt.getEntityLiving().func_130014_f_().field_72995_K) {
            return;
        }
        if (!BWConfig.produceDung) {
            return;
        }
        if (evt.getEntityLiving() instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)evt.getEntityLiving();
            if (animal instanceof EntityWolf && !animal.func_130014_f_().func_175678_i(animal.func_180425_c()) && animal.func_70874_b() > 99) {
                int light = animal.func_130014_f_().func_175699_k(animal.func_180425_c());
                if (animal.func_70874_b() == fearLevel[light]) {
                    evt.getEntityLiving().func_70099_a(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG), 0.0f);
                    animal.func_70873_a(99);
                }
            }
            if (!(animal instanceof EntityRabbit)) {
                if (animal.func_70874_b() == 100) {
                    evt.getEntityLiving().func_70099_a(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG), 0.0f);
                } else if (animal.func_70880_s() && rand.nextInt(1200) == 0) {
                    evt.getEntityLiving().func_70099_a(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG), 0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void mobDiesBySaw(LivingDropsEvent evt) {
        BlockPos pos = evt.getEntityLiving().func_180425_c().func_177977_b();
        if (this.isChoppingBlock(evt.getEntityLiving().func_130014_f_(), pos) || this.isBattleAxe(evt.getEntityLiving())) {
            int headChance;
            if (!(evt.getEntityLiving() instanceof EntityPlayer)) {
                for (EntityItem item : evt.getDrops()) {
                    ItemStack stack = item.func_92059_d();
                    if (stack.func_77976_d() == 1 || !evt.getEntity().func_130014_f_().field_73012_v.nextBoolean()) continue;
                    item.func_92058_a(new ItemStack(stack.func_77973_b(), stack.field_77994_a + 1, stack.func_77952_i()));
                }
            }
            if (evt.getEntityLiving() instanceof EntityAgeable) {
                this.addDrop(evt, ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG));
            }
            if ((headChance = evt.getEntityLiving().func_130014_f_().field_73012_v.nextInt(12)) < 5) {
                if (evt.getEntityLiving() instanceof EntitySkeleton) {
                    EntitySkeleton skeltal = (EntitySkeleton)evt.getEntityLiving();
                    if (skeltal.func_189771_df() != SkeletonType.STRAY) {
                        this.addDrop(evt, new ItemStack(Items.field_151144_bL, 1, skeltal.func_189771_df().func_190135_a()));
                    }
                } else if (evt.getEntityLiving() instanceof EntityZombie) {
                    this.addDrop(evt, new ItemStack(Items.field_151144_bL, 1, 2));
                } else if (evt.getEntityLiving() instanceof EntityCreeper) {
                    this.addDrop(evt, new ItemStack(Items.field_151144_bL, 1, 4));
                } else if (evt.getEntityLiving() instanceof EntityPlayer) {
                    this.addDrop(evt, EntityPlayerExt.getPlayerHead((EntityPlayer)evt.getEntityLiving()));
                }
            }
        }
    }

    private boolean isChoppingBlock(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == BWMBlocks.AESTHETIC) {
            IBlockState state = world.func_180495_p(pos);
            return state.func_177229_b(BlockAesthetic.blockType) == BlockAesthetic.EnumType.CHOPBLOCK || state.func_177229_b(BlockAesthetic.blockType) == BlockAesthetic.EnumType.CHOPBLOCKBLOOD;
        }
        return false;
    }

    private boolean isBattleAxe(EntityLivingBase entity) {
        ItemStack held;
        Entity e;
        DamageSource source = entity.func_189748_bU();
        return source != null && source.func_76364_f() != null && (e = source.func_76364_f()) instanceof EntityLivingBase && (held = ((EntityLivingBase)e).func_184614_ca()) != null && held.func_77969_a(new ItemStack(BWMItems.STEEL_BATTLEAXE));
    }

    @SubscribeEvent
    public void setDropChance(EntityJoinWorldEvent evt) {
        if (BWConfig.armorDrops && (evt.getEntity() instanceof EntityZombie || evt.getEntity() instanceof EntitySkeleton)) {
            EntityMob mob = (EntityMob)evt.getEntity();
            mob.func_98053_h(true);
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                mob.func_184642_a(slot, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void mobDrops(LivingDropsEvent evt) {
        if (!BWConfig.hardcoreGunpowder) {
            return;
        }
        if (evt.getEntity() instanceof EntityCreeper || evt.getEntity() instanceof EntityGhast) {
            for (EntityItem item : evt.getDrops()) {
                ItemStack stack = item.func_92059_d();
                if (stack.func_77973_b() != Items.field_151016_H) continue;
                item.func_92058_a(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NITER, stack.field_77994_a));
            }
        }
    }

    private boolean isNonDefaultArmor(EntityMob mob, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (mob instanceof EntitySkeleton ? item instanceof ItemBow || item instanceof ItemSword : mob instanceof EntityPigZombie && item == Items.field_151010_B) {
            return stack.func_77942_o();
        }
        return true;
    }

    private void createDamagedItem(LivingDropsEvent evt, ItemStack stack) {
        if (stack.func_77984_f()) {
            stack.func_77964_b((int)(rand.nextFloat() * (float)stack.func_77958_k()));
        }
        this.addDrop(evt, stack);
    }

    public void addDrop(LivingDropsEvent evt, ItemStack drop) {
        EntityItem item = new EntityItem(evt.getEntityLiving().func_130014_f_(), evt.getEntityLiving().field_70165_t, evt.getEntityLiving().field_70163_u, evt.getEntityLiving().field_70161_v, drop);
        item.func_174869_p();
        evt.getDrops().add(item);
    }

    @SubscribeEvent
    public void shearCreeper(PlayerInteractEvent.EntityInteractSpecific e) {
        Entity creeper = e.getTarget();
        if (creeper instanceof EntityCreeper && e.getSide().isServer() && creeper.func_70089_S() && e.getItemStack() != null && e.getItemStack().func_77973_b() instanceof ItemShears) {
            InvUtils.ejectStack(e.getWorld(), creeper.field_70165_t, creeper.field_70163_u, creeper.field_70161_v, new ItemStack(BWMItems.CREEPER_OYSTER));
            EntityShearedCreeper shearedCreeper = new EntityShearedCreeper(e.getWorld());
            creeper.func_70097_a(new DamageSource(""), 0.0f);
            this.copyEntityInfo(creeper, (Entity)shearedCreeper);
            e.getWorld().func_184148_a(null, shearedCreeper.field_70165_t, shearedCreeper.field_70163_u, shearedCreeper.field_70161_v, SoundEvents.field_187882_fq, SoundCategory.HOSTILE, 1.0f, 0.3f);
            e.getWorld().func_184148_a(null, shearedCreeper.field_70165_t, shearedCreeper.field_70163_u, shearedCreeper.field_70161_v, SoundEvents.field_187763_eJ, SoundCategory.HOSTILE, 1.0f, 1.0f);
            creeper.func_70106_y();
            e.getWorld().func_72838_d((Entity)shearedCreeper);
        }
    }

    public void copyEntityInfo(Entity copyFrom, Entity copyTo) {
        copyTo.func_70080_a(copyFrom.field_70165_t, copyFrom.field_70163_u, copyFrom.field_70161_v, copyFrom.field_70177_z, copyFrom.field_70125_A);
        copyTo.func_70034_d(copyFrom.func_70079_am());
    }
}

