/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.config.BWConfig;
import betterwithmods.entity.ai.EntityAIFlee;
import betterwithmods.entity.ai.EntityAISearchFood;
import betterwithmods.util.NetherSpawnWhitelist;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class NetherSpawnEvent {
    private static final Random rand = new Random();

    @SubscribeEvent
    public void addEntityAI(EntityJoinWorldEvent evt) {
        EntityLivingBase entity;
        if (evt.getEntity() instanceof EntityLivingBase && (entity = (EntityLivingBase)evt.getEntity()) instanceof EntityAnimal) {
            ((EntityAnimal)entity).field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAISearchFood((EntityAnimal)entity));
            if (!(entity instanceof EntityTameable)) {
                float speed = 1.25f;
                if (entity instanceof EntityCow) {
                    speed = 2.0f;
                } else if (entity instanceof EntityChicken) {
                    speed = 1.4f;
                }
                ((EntityAnimal)entity).field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIFlee((EntityCreature)entity, speed));
            }
        }
    }

    @SubscribeEvent
    public void giveEndermenEndStone(LivingSpawnEvent evt) {
        EntityLivingBase entity = evt.getEntityLiving();
        if (evt.getWorld().field_73011_w.func_186058_p() == DimensionType.THE_END && entity instanceof EntityEnderman && rand.nextInt(2000) == 0) {
            ((EntityEnderman)entity).func_175490_a(Blocks.field_150377_bs.func_176223_P());
        }
    }

    @SubscribeEvent
    public void generateMossNearSpawner(TickEvent.WorldTickEvent evt) {
        List<BlockPos> positions = evt.world.field_147482_g.stream().filter(t -> t instanceof TileEntityMobSpawner).map(TileEntity::func_174877_v).collect(Collectors.toList());
        try {
            positions.forEach(pos -> {
                int z;
                int y;
                int x = rand.nextInt(9) - 4;
                BlockPos check = pos.func_177982_a(x, y = rand.nextInt(5) - 1, z = rand.nextInt(9) - 4);
                IBlockState state = evt.world.func_180495_p(check);
                if ((state.func_177230_c() == Blocks.field_150347_e || state.func_177230_c() == Blocks.field_150417_aV && state.func_177230_c().func_176201_c(state) == 0) && rand.nextInt(30) == 0) {
                    IBlockState changeState = state.func_177230_c() == Blocks.field_150347_e ? Blocks.field_150341_Y.func_176223_P() : Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
                    evt.world.func_175656_a(check, changeState);
                }
            });
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void denySlimeSpawns(LivingSpawnEvent.CheckSpawn evt) {
        if (evt.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!BWConfig.slimeSpawn) {
            return;
        }
        if (evt.getWorld() != null && evt.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD && evt.getEntityLiving() instanceof EntitySlime) {
            BlockPos pos = new BlockPos(evt.getEntity().field_70165_t, evt.getEntity().field_70163_u - 1.0, evt.getEntity().field_70161_v);
            if (evt.getWorld().func_180495_p(pos).func_185904_a() != Material.field_151577_b && evt.getWorld().func_180495_p(pos).func_185904_a() != Material.field_151576_e && evt.getWorld().func_180495_p(pos).func_185904_a() != Material.field_151578_c) {
                evt.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void denyNetherSpawns(LivingSpawnEvent.CheckSpawn evt) {
        if (evt.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!BWConfig.netherSpawn) {
            return;
        }
        if (evt.getWorld() != null && evt.getWorld().field_73011_w.getDimension() == -1 && evt.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false)) {
            double monX = evt.getEntity().field_70165_t;
            double monY = evt.getEntity().field_70163_u;
            double monZ = evt.getEntity().field_70161_v;
            int x = MathHelper.func_76128_c((double)monX);
            int y = MathHelper.func_76128_c((double)monY);
            int z = MathHelper.func_76128_c((double)monZ);
            BlockPos pos = new BlockPos(x, y - 1, z);
            Block block = evt.getWorld().func_180495_p(pos).func_177230_c();
            int meta = evt.getWorld().func_180495_p(pos).func_177230_c().func_176201_c(evt.getWorld().func_180495_p(pos));
            if (!evt.getWorld().func_175623_d(pos) && !NetherSpawnWhitelist.contains(block, meta)) {
                evt.setResult(Event.Result.DENY);
            }
        }
    }
}

