/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.blocks.BlockStump;
import betterwithmods.config.BWConfig;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class StumpingEventHandler {
    private static boolean shouldBeSkipped(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150362_t || state.func_177230_c() == Blocks.field_150361_u || state.func_177230_c() == Blocks.field_150364_r || state.func_177230_c() == Blocks.field_150363_s || state.func_177230_c() == Blocks.field_150350_a;
    }

    private static boolean canSustainTree(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak;
    }

    @SubscribeEvent
    public void addStumpsToGeneratedTrees(DecorateBiomeEvent.Post event) {
        if (!BWConfig.hardcoreStumping) {
            return;
        }
        if (!event.getWorld().field_73011_w.func_76569_d()) {
            return;
        }
        for (int dx = 0; dx < 16; ++dx) {
            int x = event.getPos().func_177958_n() + dx;
            x += 8;
            for (int dz = 0; dz < 16; ++dz) {
                IBlockState stump;
                int z = event.getPos().func_177952_p() + dz;
                Chunk chunk = event.getWorld().func_175726_f(new BlockPos(x, 0, z += 8));
                int y = chunk.func_76611_b(x & 0xF, z & 0xF) - 1;
                BlockPos pos = new BlockPos(x, y, z);
                IBlockState state = event.getWorld().func_180495_p(pos);
                while (StumpingEventHandler.shouldBeSkipped(state)) {
                    pos = new BlockPos(x, --y, z);
                    state = event.getWorld().func_180495_p(pos);
                }
                if (!BlockStump.canPlaceStump(event.getWorld(), pos.func_177984_a()) || !StumpingEventHandler.canSustainTree(state) || (stump = BlockStump.getStump(event.getWorld().func_180495_p(pos.func_177984_a()))) == null) continue;
                event.getWorld().func_175656_a(pos.func_177984_a(), stump);
            }
        }
    }
}

