/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.integration;

import betterwithmods.BWMod;
import betterwithmods.config.BWConfig;
import betterwithmods.integration.BiomesOPlenty;
import betterwithmods.integration.Harvestcraft;
import betterwithmods.integration.ICompatModule;
import betterwithmods.integration.Quark;
import betterwithmods.integration.immersiveengineering.ImmersiveEngineering;
import betterwithmods.integration.minetweaker.MineTweaker;
import betterwithmods.integration.tcon.TConstruct;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;

public abstract class ModIntegration {
    public static Map<String, Class<? extends ICompatModule>> compatClasses = new HashMap<String, Class<? extends ICompatModule>>();
    public static Set<ICompatModule> loadedModules = new HashSet<ICompatModule>();

    public static void loadPreInit() {
        compatClasses.entrySet().stream().filter(e -> ModIntegration.isLoaded((String)e.getKey())).forEach(e -> {
            try {
                ICompatModule mod = (ICompatModule)((Class)e.getValue()).newInstance();
                loadedModules.add(mod);
                mod.preInit();
            }
            catch (Exception ex) {
                BWMod.logger.error("Compat module for " + (String)e.getKey() + " could not be preInitialized. Report this!");
            }
        });
    }

    public static void loadInit() {
        loadedModules.stream().forEach(ICompatModule::init);
    }

    public static void loadPostInit() {
        loadedModules.stream().forEach(ICompatModule::postInit);
    }

    public void preInit() {
    }

    public void init() {
    }

    public void postInit() {
    }

    public static boolean isLoaded(String modid) {
        boolean loaded = Loader.isModLoaded((String)modid) && BWConfig.config.get("Mod Compat", modid.toLowerCase() + "_compat", true).getBoolean();
        BWMod.logger.debug("Compat for " + modid + " is " + (loaded ? "loaded" : "not loaded"));
        BWConfig.config.save();
        return loaded;
    }

    static {
        compatClasses.put("biomesoplenty", BiomesOPlenty.class);
        compatClasses.put("harvestcraft", Harvestcraft.class);
        compatClasses.put("immersiveengineering", ImmersiveEngineering.class);
        compatClasses.put("MineTweaker3", MineTweaker.class);
        compatClasses.put("quark", Quark.class);
        compatClasses.put("tconstruct", TConstruct.class);
    }
}

