/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.integration.immersiveengineering;

import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.blocks.BWMBlock;
import betterwithmods.integration.immersiveengineering.TileEntityImmersiveAxle;
import betterwithmods.util.MechanicalUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockImmersiveAxle
extends BWMBlock
implements IMechanicalBlock,
ITileEntityProvider,
IMultiVariants {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyInteger AXLEDIR = PropertyInteger.func_177719_a((String)"dir", (int)0, (int)2);
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
    private static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);

    public BlockImmersiveAxle() {
        super(Material.field_151575_d);
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)AXLEDIR, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public String[] getVariants() {
        return new String[]{"active=false,dir=0"};
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int ori = (Integer)state.func_177229_b((IProperty)AXLEDIR);
        switch (ori) {
            case 0: {
                return Y_AABB;
            }
            case 1: {
                return Z_AABB;
            }
            case 2: {
                return X_AABB;
            }
        }
        return null;
    }

    @Deprecated
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase placer, ItemStack stack) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, placer, stack);
        return this.setAxisAlignment(state, side);
    }

    private IBlockState setAxisAlignment(IBlockState state, EnumFacing facing) {
        int axis;
        switch (facing) {
            case DOWN: 
            case UP: {
                axis = 0;
                break;
            }
            case NORTH: 
            case SOUTH: {
                axis = 1;
                break;
            }
            default: {
                axis = 2;
            }
        }
        return state.func_177226_a((IProperty)AXLEDIR, (Comparable)Integer.valueOf(axis)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, 1, 5);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.validatePower(state, world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        this.validatePower(state, world, pos);
    }

    private void validatePower(IBlockState state, World world, BlockPos pos) {
        boolean gettingPower;
        boolean powered = (Boolean)state.func_177229_b((IProperty)ACTIVE);
        if (powered != (gettingPower = this.isInputtingMechPower(world, pos))) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(gettingPower)));
        }
    }

    @Override
    public boolean isMechanicalOnFromState(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE);
    }

    @Override
    public void setMechanicalOn(World world, BlockPos pos, boolean active) {
        IBlockState state = world.func_180495_p(pos);
        if ((Boolean)state.func_177229_b((IProperty)ACTIVE) != active) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)));
        }
    }

    @Override
    public boolean isMechanicalOn(IBlockAccess world, BlockPos pos) {
        return this.isMechanicalOnFromState(world.func_180495_p(pos));
    }

    @Override
    public boolean isOutputtingMechPower(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    public EnumFacing getFacing(IBlockState state) {
        int axle = (Integer)state.func_177229_b((IProperty)AXLEDIR);
        return EnumFacing.func_82600_a((int)(axle * 2));
    }

    @Override
    public boolean canInputPowerToSide(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        EnumFacing dir = EnumFacing.func_82600_a((int)((Integer)world.func_180495_p(pos).func_177229_b((IProperty)AXLEDIR) * 2));
        return facing == dir || facing == dir.func_176734_d();
    }

    @Override
    public boolean isInputtingMechPower(World world, BlockPos pos) {
        EnumFacing facing = this.getFacing(world.func_180495_p(pos));
        return MechanicalUtil.isBlockPoweredOnSide(world, pos, facing) || MechanicalUtil.isBlockPoweredOnSide(world, pos, facing.func_176734_d());
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityImmersiveAxle) {
            ((TileEntityImmersiveAxle)te).setOverpowered();
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityImmersiveAxle();
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AXLEDIR) + ((Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        boolean active;
        boolean bl = active = meta > 7;
        if (active) {
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)).func_177226_a((IProperty)AXLEDIR, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, AXLEDIR});
    }
}

