/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.integration.immersiveengineering;

import betterwithmods.BWMBlocks;
import betterwithmods.config.BWConfig;
import betterwithmods.integration.ICompatModule;
import betterwithmods.integration.immersiveengineering.BlockImmersiveAxle;
import betterwithmods.integration.immersiveengineering.TileEntityImmersiveAxle;
import betterwithmods.items.ItemMaterial;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IERecipes;
import blusunrize.immersiveengineering.common.blocks.plant.BlockIECrop;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ImmersiveEngineering
implements ICompatModule {
    public static final Block TREATED_AXLE = (Block)new BlockImmersiveAxle().setRegistryName("immersive_axle");
    public static final String MODID = "immersiveengineering";
    public static boolean overrideIndustrialHempDrops;

    @Override
    public void preInit() {
        BWMBlocks.registerBlock(TREATED_AXLE);
        GameRegistry.registerTileEntity(TileEntityImmersiveAxle.class, (String)"bwm.immersive_axle");
        BWConfig.config.load();
        overrideIndustrialHempDrops = BWConfig.config.getBoolean("Override Hemp Drop", "Mod Compat", true, "Replaces drop from IE Industrial Hemp with BWM Hemp");
        BWConfig.config.save();
        if (overrideIndustrialHempDrops) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        BWMBlocks.setInventoryModel(TREATED_AXLE);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initClient() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postInitClient() {
    }

    @Override
    public void init() {
        ItemStack conveyorStack = ConveyorHandler.getConveyorStack((String)"immersiveengineering:conveyor");
        IERecipes.addOredictRecipe((ItemStack)Utils.copyStackWithAmount((ItemStack)conveyorStack, (int)8), (Object[])new Object[]{"LLL", "IRI", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('L'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_CUT)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(TREATED_AXLE), new Object[]{"W", "R", "W", Character.valueOf('W'), "plankTreatedWood", Character.valueOf('R'), BWMBlocks.ROPE}));
        Fluid seedOil = FluidRegistry.getFluid((String)"plantoil");
        SqueezerRecipe.addRecipe((FluidStack)new FluidStack(seedOil, 120), null, (Object)new ItemStack(BWMBlocks.HEMP, 1, 0), (int)6400);
    }

    @Override
    public void postInit() {
    }

    @SubscribeEvent
    public void overrideHempDrops(BlockEvent.HarvestDropsEvent e) {
        IBlockState state = e.getState();
        if (state.func_177230_c() instanceof BlockIECrop) {
            e.getDrops().clear();
            int meta = state.func_177230_c().func_176201_c(state);
            if (meta >= 4) {
                e.getDrops().add(new ItemStack((Item)IEContent.itemSeeds));
                e.getDrops().add(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP));
            }
        }
    }
}

