/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.integration.jei.category;

import betterwithmods.integration.jei.wrapper.other.SteelShapedRecipeWrapper;
import java.util.Collection;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SteelCraftingCategory
extends BlankRecipeCategory<IRecipeWrapper> {
    public static final String UID = "bwm.steel_anvil";
    public static final String TITLE = "inv.steel_anvil.name";
    public static final int WIDTH = 162;
    public static final int HEIGHT = 199;
    private final IDrawable background;
    private final ICraftingGridHelper craftingGridHelper;
    private final int craftInputSlot1;
    private final int craftOutputSlot;

    public SteelCraftingCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("betterwithmods", "textures/gui/jei/steel_anvil.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 162, 199);
        this.craftInputSlot1 = 1;
        this.craftOutputSlot = 0;
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(this.craftInputSlot1, this.craftOutputSlot);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)TITLE, (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, false, 112, 27);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int index = this.craftInputSlot1 + x + y * 4;
                stacks.init(index, true, x * 18, y * 18);
            }
        }
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        if (recipeWrapper instanceof SteelShapedRecipeWrapper) {
            SteelShapedRecipeWrapper wrapper = (SteelShapedRecipeWrapper)recipeWrapper;
            this.setInputStacks(stacks, inputs, wrapper.getWidth(), wrapper.getHeight());
            this.setOutput(stacks, outputs);
        } else {
            this.setInputStacks(stacks, inputs);
            this.setOutput(stacks, outputs);
        }
    }

    private void setInputStacks(IGuiItemStackGroup guiItemStacks, List<List<ItemStack>> input) {
        int width;
        int height;
        if (input.size() > 9) {
            height = 4;
            width = 4;
        } else if (input.size() > 4) {
            height = 3;
            width = 3;
        } else if (input.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        this.setInputStacks(guiItemStacks, input, width, height);
    }

    private void setInputStacks(IGuiItemStackGroup guiItemStacks, List<List<ItemStack>> input, int width, int height) {
        for (int i = 0; i < input.size(); ++i) {
            List<ItemStack> recipeItem = input.get(i);
            int index = this.getCraftingIndex(i, width, height);
            this.setInput(guiItemStacks, index, recipeItem);
        }
    }

    private int getCraftingIndex(int i, int width, int height) {
        int x = i % width;
        int y = i / width;
        return x + y * 4;
    }

    private void setInput(IGuiItemStackGroup guiItemStacks, int inputIndex, Collection<ItemStack> input) {
        guiItemStacks.set(this.craftInputSlot1 + inputIndex, input);
    }

    private void setOutput(IGuiItemStackGroup guiItemStacks, List<ItemStack> output) {
        guiItemStacks.set(this.craftOutputSlot, output);
    }
}

