/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.integration.minetweaker;

import betterwithmods.integration.minetweaker.utils.InputHelper;
import betterwithmods.integration.minetweaker.utils.ItemMapModification;
import betterwithmods.integration.minetweaker.utils.LogHelper;
import betterwithmods.util.item.ItemExt;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.betterwithmods.Buoyancy")
public class Buoyancy {
    @ZenMethod
    public static void set(IItemStack input, float buoyancy) {
        if (buoyancy * buoyancy >= 1.0f) {
            LogHelper.logError("Buoyancy must be [-1.0,1.0]");
        } else {
            ItemStack stack = InputHelper.toStack(input);
            MineTweakerAPI.apply((IUndoableAction)new BuoyancySet(stack.func_77973_b(), stack.func_77960_j(), buoyancy));
        }
    }

    private static class BuoyancySet
    extends ItemMapModification<Float> {
        protected BuoyancySet(Item item, int meta, float buoyancy) {
            super("buoyancy", Float.valueOf(-1.0f), ItemExt.getBuoyancyRegistry());
            ItemExt.getBuoyancyRegistry().put(item, meta, Float.valueOf(buoyancy));
        }
    }
}

