/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.integration.minetweaker.utils;

import betterwithmods.integration.minetweaker.utils.BaseMapModification;
import betterwithmods.integration.minetweaker.utils.LogHelper;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseMapAddition<K, V>
extends BaseMapModification<K, V> {
    protected final HashMap<K, V> overwritten = new HashMap();

    protected BaseMapAddition(String name, Map<K, V> map) {
        super(name, map);
    }

    protected BaseMapAddition(String name, Map<K, V> map, Map<K, V> recipes) {
        this(name, map);
        this.recipes.putAll(recipes);
    }

    public void apply() {
        if (this.recipes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.recipes.entrySet()) {
            Object value;
            Object key = entry.getKey();
            Object oldValue = this.map.put(key, value = entry.getValue());
            if (oldValue != null) {
                LogHelper.logWarning(String.format("Overwritten %s Recipe for %s", this.name, this.getRecipeInfo(new AbstractMap.SimpleEntry(entry.getKey(), value))));
                this.overwritten.put(key, oldValue);
            }
            this.successful.put(key, value);
        }
    }

    public void undo() {
        Object value;
        Object key;
        if (this.successful.isEmpty() && this.overwritten.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.successful.entrySet()) {
            key = entry.getKey();
            value = this.map.remove(key);
            if (value != null) continue;
            LogHelper.logError(String.format("Error removing %s Recipe: null object", this.name));
        }
        for (Map.Entry entry : this.overwritten.entrySet()) {
            key = entry.getKey();
            Object oldValue = this.map.put(key, value = entry.getValue());
            if (oldValue == null) continue;
            LogHelper.logWarning(String.format("Overwritten %s Recipe which should not exist for %s", this.name, this.getRecipeInfo(new AbstractMap.SimpleEntry(entry.getKey(), value))));
        }
    }

    @Override
    public String describe() {
        return String.format("[ModTweaker] Adding %d %s Recipe(s) for %s", this.recipes.size(), this.name, this.getRecipeInfo());
    }

    @Override
    public String describeUndo() {
        return String.format("[ModTweaker] Removing %d %s Recipe(s) for %s", this.recipes.size(), this.name, this.getRecipeInfo());
    }
}

