/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.integration.minetweaker.utils;

import betterwithmods.integration.minetweaker.utils.BaseMapModification;
import betterwithmods.integration.minetweaker.utils.LogHelper;
import java.util.Map;

public abstract class BaseMapRemoval<K, V>
extends BaseMapModification<K, V> {
    protected BaseMapRemoval(String name, Map<K, V> map) {
        super(name, map);
    }

    protected BaseMapRemoval(String name, Map<K, V> map, Map<K, V> recipes) {
        this(name, map);
        if (recipes != null) {
            this.recipes.putAll(recipes);
        }
    }

    public void apply() {
        if (this.recipes.isEmpty()) {
            return;
        }
        for (Object key : this.recipes.keySet()) {
            Object oldValue = this.map.remove(key);
            if (oldValue != null) {
                this.successful.put(key, oldValue);
                continue;
            }
            LogHelper.logError(String.format("Error removing %s Recipe : null object", this.name));
        }
    }

    public void undo() {
        if (this.successful.isEmpty()) {
            return;
        }
        for (Map.Entry entry : this.successful.entrySet()) {
            Object oldValue;
            if (entry == null || (oldValue = this.map.put(entry.getKey(), entry.getValue())) == null) continue;
            LogHelper.logWarning(String.format("Overwritten %s Recipe for %s while restoring.", this.name, this.getRecipeInfo(entry)));
        }
    }

    @Override
    public String describe() {
        return String.format("[ModTweaker] Removing %d %s Recipe(s) for %s", this.recipes.size(), this.name, this.getRecipeInfo());
    }

    @Override
    public String describeUndo() {
        return String.format("[ModTweaker] Restoring %d %s Recipe(s) for %s", this.recipes.size(), this.name, this.getRecipeInfo());
    }
}

