/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.integration.minetweaker.utils;

import betterwithmods.integration.minetweaker.utils.BaseUndoable;
import betterwithmods.integration.minetweaker.utils.LogHelper;
import betterwithmods.util.item.ItemStackMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemMapModification<T>
extends BaseUndoable {
    protected ItemStackMap<T> map;
    protected final ItemStackMap<T> recipes;
    protected final ItemStackMap<T> successful;
    protected final ItemStackMap<T> overwritten;

    protected ItemMapModification(String name, T defaultValue, ItemStackMap<T> map) {
        super(name);
        this.map = map;
        this.recipes = new ItemStackMap<T>(defaultValue);
        this.successful = new ItemStackMap<T>(defaultValue);
        this.overwritten = new ItemStackMap<T>(defaultValue);
    }

    protected ItemMapModification(String name, T defaultValue, ItemStackMap<T> map, Map<? extends ItemStack, ? extends T> recipes) {
        this(name, defaultValue, map);
        this.recipes.putAll(recipes);
    }

    @Override
    public boolean canUndo() {
        return !this.recipes.isEmpty();
    }

    @Override
    protected String getRecipeInfo() {
        if (!this.recipes.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Item, HashMap<Integer, T>> recipe : this.recipes.entrySet()) {
                if (recipe == null) continue;
                sb.append(this.getRecipeInfo(recipe)).append(", ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return super.getRecipeInfo();
    }

    public void apply() {
        if (this.recipes.isEmpty()) {
            return;
        }
        for (Map.Entry<Item, HashMap<Integer, T>> entry : this.recipes.entrySet()) {
            Item key = entry.getKey();
            HashMap<Integer, T> value = entry.getValue();
            for (Map.Entry<Integer, T> e : value.entrySet()) {
                if (this.recipes.containsKey(key, e.getKey())) {
                    this.overwritten.put(key, (int)e.getKey(), e.getValue());
                }
                this.successful.put(key, (int)e.getKey(), e.getValue());
            }
        }
    }

    public void undo() {
        Item key;
        if (this.successful.isEmpty() && this.overwritten.isEmpty()) {
            return;
        }
        for (Map.Entry<Item, HashMap<Integer, T>> entry : this.successful.entrySet()) {
            key = entry.getKey();
            for (Map.Entry<Integer, T> val : entry.getValue().entrySet()) {
                T value = this.map.remove(key, val.getKey());
                if (value != null) continue;
                LogHelper.logError(String.format("Error removing %s Recipe: null object", this.name));
            }
        }
        for (Map.Entry<Item, HashMap<Integer, T>> entry : this.overwritten.entrySet()) {
            key = entry.getKey();
            for (Map.Entry<Integer, T> val : entry.getValue().entrySet()) {
                T oldValue = this.map.remove(key, val.getKey());
                if (oldValue == null) continue;
                LogHelper.logWarning(String.format("Overwritten %s Recipe which should not exist for %s", this.name, this.getRecipeInfo()));
            }
        }
    }

    protected String getRecipeInfo(Map.Entry<Item, HashMap<Integer, T>> recipe) {
        return null;
    }
}

