/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.integration.minetweaker.utils;

import betterwithmods.integration.minetweaker.utils.LogHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class ReflectionHelper {
    public static <T> T getInstance(Constructor<T> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (Exception e) {
            LogHelper.logError("Exception creating instance of " + constructor.getClass().getName(), e);
            return null;
        }
    }

    public static Constructor<?> getConstructor(String className, Class<?> ... argumentTypes) {
        if (className == null || argumentTypes == null) {
            LogHelper.logError("The provided class name or arguments can't be null.");
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(argumentTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception ex) {
            LogHelper.logError("Exception getting constructor of " + className, ex);
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... types) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(types);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception ex) {
            LogHelper.logError("Exception getting constructor of " + clazz.getName(), ex);
            return null;
        }
    }

    public static <T> T getObject(Object object, String ... fieldNames) {
        Class<?> cls = object.getClass();
        for (String field : fieldNames) {
            try {
                Field result = cls.getDeclaredField(field);
                result.setAccessible(true);
                return (T)result.get(object);
            }
            catch (Exception ex) {
                LogHelper.logError("Exception in getObject()", ex);
            }
        }
        LogHelper.logError("Could not retrieve any object for the provided field names.");
        return null;
    }

    public static <T> T getFinalObject(Object object, String ... fieldNames) {
        Class<?> cls = object.getClass();
        for (String field : fieldNames) {
            try {
                Field result = cls.getDeclaredField(field);
                result.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(result, result.getModifiers() & 0xFFFFFFEF);
                return (T)result.get(object);
            }
            catch (Exception ex) {
                LogHelper.logError("Exception in getFinalObject()", ex);
            }
        }
        LogHelper.logError("Could not retrieve any final object for the provided field names.");
        return null;
    }

    public static <T> T getStaticObject(Class<?> clazz, String ... fieldNames) {
        for (String field : fieldNames) {
            try {
                Field result = clazz.getDeclaredField(field);
                result.setAccessible(true);
                return (T)result.get(null);
            }
            catch (Exception e) {
                LogHelper.logError("Exception in getStaticObject()", e);
            }
        }
        LogHelper.logError("Could not retrieve any static object for the provided field names.");
        return null;
    }

    public static <T> T getStaticObject(String className, String ... fieldNames) {
        try {
            Class<?> clazz = Class.forName(className);
            return ReflectionHelper.getStaticObject(clazz, fieldNames);
        }
        catch (ClassNotFoundException e) {
            LogHelper.logError("Exception in getStaticObject()", e);
            LogHelper.logError("Could not retrieve any static object for the provided field names.");
            return null;
        }
    }

    public static void setPrivateValue(Class<?> cls, String field, int var) {
        try {
            Field f = cls.getDeclaredField(field);
            f.setAccessible(true);
            f.setInt(null, var);
        }
        catch (Exception e) {
            LogHelper.logError("Exception in setPrivateValue()", e);
        }
    }

    public static void setPrivateValue(Class cls, Object o, String field, Object var) {
        net.minecraftforge.fml.relauncher.ReflectionHelper.setPrivateValue((Class)cls, (Object)o, (Object)var, (String[])new String[]{field});
    }
}

