/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.integration.tcon;

import betterwithmods.integration.ICompatModule;
import betterwithmods.integration.tcon.TraitMending;
import betterwithmods.util.NetherSpawnWhitelist;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.fluid.FluidMolten;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.smeltery.OreCastingRecipe;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockTinkerFluid;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTraits;

public class TConstruct
implements ICompatModule {
    public static final String MODID = "tconstruct";
    public final slimeknights.tconstruct.library.materials.Material soulforgedSteel = this.newTinkerMaterial("soulforgedSteel", 0x4D4D4D);
    public final slimeknights.tconstruct.library.materials.Material hellfire = this.newTinkerMaterial("hellfire", 14426647);
    public AbstractTrait mending;
    public FluidMolten soulforgeFluid;
    public FluidMolten hellfireFluid;
    public Block blockSoulforgeFluid;
    public Block blockHellfireFluid;

    @Override
    public void preInit() {
        this.soulforgeFluid = this.fluidMetal("soulforged_steel", 0x4D4D4D);
        this.soulforgeFluid.setTemperature(681);
        this.blockSoulforgeFluid = (Block)new BlockTinkerFluid((Fluid)this.soulforgeFluid, Material.field_151587_i).setRegistryName("molten_soulforged_steel");
        this.hellfireFluid = this.fluidMetal("hellfire", 14426647);
        this.hellfireFluid.setTemperature(850);
        this.blockHellfireFluid = (Block)new BlockTinkerFluid((Fluid)this.hellfireFluid, Material.field_151587_i).setRegistryName("molten_hellfire");
    }

    @Override
    public void init() {
        this.mending = new TraitMending();
        this.soulforgedSteel.addItem("ingotSoulforgedSteel", 1, 144);
        this.soulforgedSteel.addTrait((ITrait)this.mending);
        this.hellfire.addItem("ingotHellfire", 1, 144);
        this.hellfire.addTrait((ITrait)TinkerTraits.autosmelt);
        TinkerRegistry.addMaterialStats((slimeknights.tconstruct.library.materials.Material)this.soulforgedSteel, (IMaterialStats)new HeadMaterialStats(875, 12.0f, 6.0f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, 225), new ExtraMaterialStats(50)});
        TinkerRegistry.addMaterialStats((slimeknights.tconstruct.library.materials.Material)this.hellfire, (IMaterialStats)new HeadMaterialStats(325, 8.0f, 4.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.75f, 75), new ExtraMaterialStats(25)});
        this.registerMaterial(this.soulforgedSteel, (Fluid)this.soulforgeFluid, "SoulforgedSteel", 16);
        this.registerMaterial(this.hellfire, (Fluid)this.hellfireFluid, "Hellfire", 9, 8);
        this.netherWhitelist();
    }

    @Override
    public void postInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        this.registerRenderInfo(this.soulforgedSteel, 0x4D4D4D, 0.1f, 0.3f, 0.1f);
        this.registerRenderInfo(this.hellfire, 14426647, 0.0f, 0.2f, 0.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postInitClient() {
    }

    @SideOnly(value=Side.CLIENT)
    private void registerRenderInfo(slimeknights.tconstruct.library.materials.Material material, int color, float shininess, float brightness, float hueshift) {
        material.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.Metal(color, shininess, brightness, hueshift));
    }

    private void netherWhitelist() {
        Block ore = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(MODID, "ore"));
        NetherSpawnWhitelist.addBlock(ore, 0);
        NetherSpawnWhitelist.addBlock(ore, 1);
        NetherSpawnWhitelist.addBlock((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(MODID, "slime_congealed")), 3);
        NetherSpawnWhitelist.addBlock((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(MODID, "slime_congealed")), 4);
        NetherSpawnWhitelist.addBlock((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(MODID, "slime_dirt")), 3);
        Block slimeGrass = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(MODID, "slime_grass"));
        NetherSpawnWhitelist.addBlock(slimeGrass, 4);
        NetherSpawnWhitelist.addBlock(slimeGrass, 9);
        NetherSpawnWhitelist.addBlock(slimeGrass, 14);
    }

    private void registerMaterial(slimeknights.tconstruct.library.materials.Material material, Fluid fluid, String oreSuffix, int blockValue) {
        this.registerMaterial(material, fluid, oreSuffix, blockValue, 1);
    }

    private void registerMaterial(slimeknights.tconstruct.library.materials.Material material, Fluid fluid, String oreSuffix, int blockValue, int dustDivision) {
        MaterialIntegration mat = new MaterialIntegration(material, fluid, oreSuffix).setRepresentativeItem("ingot" + oreSuffix);
        mat.integrate();
        this.registerMeltingStuff(oreSuffix, fluid, blockValue, dustDivision);
        TinkerSmeltery.registerToolpartMeltingCasting((slimeknights.tconstruct.library.materials.Material)material);
        mat.registerRepresentativeItem();
    }

    private slimeknights.tconstruct.library.materials.Material newTinkerMaterial(String name, int color) {
        slimeknights.tconstruct.library.materials.Material mat = new slimeknights.tconstruct.library.materials.Material(name, color);
        TinkerMaterials.materials.add(mat);
        return mat;
    }

    private FluidMolten fluidMetal(String name, int color) {
        FluidMolten fluid = new FluidMolten(name, color);
        return this.registerFluid(fluid);
    }

    private <T extends Fluid> T registerFluid(T fluid) {
        fluid.setUnlocalizedName("betterwithmods:" + fluid.getName());
        FluidRegistry.registerFluid(fluid);
        return fluid;
    }

    private void fixHellfireDust() {
        Pair dustOre = Pair.of((Object)OreDictionary.getOres((String)"dustHellfire"), (Object)18);
        TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((List)((List)dustOre.getLeft()), (int)((Integer)dustOre.getRight())), (Fluid)this.hellfireFluid));
    }

    private void registerMeltingStuff(String ore, Fluid fluid, int blockValue, int dustDivision) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Pair nuggetOre = Pair.of((Object)OreDictionary.getOres((String)("nugget" + ore)), (Object)16);
        Pair ingotOre = Pair.of((Object)OreDictionary.getOres((String)("ingot" + ore)), (Object)144);
        Pair plateOre = Pair.of((Object)OreDictionary.getOres((String)("plate" + ore)), (Object)144);
        Pair gearOre = Pair.of((Object)OreDictionary.getOres((String)("gear" + ore)), (Object)576);
        Pair blockOre = Pair.of((Object)OreDictionary.getOres((String)("block" + ore)), (Object)(144 * blockValue));
        Pair dustOre = Pair.of((Object)OreDictionary.getOres((String)("dust" + ore)), (Object)(144 / dustDivision));
        builder.add((Object[])new Pair[]{nuggetOre, ingotOre, plateOre, gearOre, blockOre, dustOre});
        ImmutableSet knownOres = builder.build();
        for (Pair pair : knownOres) {
            TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((List)((List)pair.getLeft()), (int)((Integer)pair.getRight())), fluid));
        }
        TinkerRegistry.registerTableCasting((ICastingRecipe)new OreCastingRecipe((List)ingotOre.getLeft(), RecipeMatch.ofNBT((ItemStack)TinkerSmeltery.castIngot), fluid, ((Integer)ingotOre.getRight()).intValue()));
        TinkerRegistry.registerTableCasting((ICastingRecipe)new OreCastingRecipe((List)nuggetOre.getLeft(), RecipeMatch.ofNBT((ItemStack)TinkerSmeltery.castNugget), fluid, ((Integer)nuggetOre.getRight()).intValue()));
        TinkerRegistry.registerBasinCasting((ICastingRecipe)new OreCastingRecipe((List)blockOre.getLeft(), null, fluid, ((Integer)blockOre.getRight()).intValue()));
        TinkerRegistry.registerTableCasting((ICastingRecipe)new OreCastingRecipe((List)plateOre.getLeft(), RecipeMatch.ofNBT((ItemStack)TinkerSmeltery.castPlate), fluid, ((Integer)plateOre.getRight()).intValue()));
        TinkerRegistry.registerTableCasting((ICastingRecipe)new OreCastingRecipe((List)gearOre.getLeft(), RecipeMatch.ofNBT((ItemStack)TinkerSmeltery.castGear), fluid, ((Integer)gearOre.getRight()).intValue()));
        for (FluidStack fs : TinkerSmeltery.castCreationFluids) {
            TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(TinkerSmeltery.castIngot, RecipeMatch.of((List)((List)ingotOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(TinkerSmeltery.castNugget, RecipeMatch.of((List)((List)nuggetOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(TinkerSmeltery.castPlate, RecipeMatch.of((List)((List)plateOre.getLeft())), fs, true, true));
            TinkerRegistry.registerTableCasting((ICastingRecipe)new CastingRecipe(TinkerSmeltery.castGear, RecipeMatch.of((List)((List)gearOre.getLeft())), fs, true, true));
        }
    }
}

