/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.proxy;

import betterwithmods.BWMBlocks;
import betterwithmods.BWMItems;
import betterwithmods.BWMod;
import betterwithmods.blocks.tile.TileEntityCauldron;
import betterwithmods.blocks.tile.TileEntityCrucible;
import betterwithmods.blocks.tile.TileEntityFilteredHopper;
import betterwithmods.blocks.tile.TileEntityTurntable;
import betterwithmods.blocks.tile.gen.TileEntityWaterwheel;
import betterwithmods.blocks.tile.gen.TileEntityWindmillHorizontal;
import betterwithmods.blocks.tile.gen.TileEntityWindmillVertical;
import betterwithmods.client.BWStateMapper;
import betterwithmods.client.ColorHandlers;
import betterwithmods.client.model.TESRCauldron;
import betterwithmods.client.model.TESRCrucible;
import betterwithmods.client.model.TESRFilteredHopper;
import betterwithmods.client.model.TESRTurntable;
import betterwithmods.client.model.TESRVerticalWindmill;
import betterwithmods.client.model.TESRWaterwheel;
import betterwithmods.client.model.TESRWindmill;
import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.client.render.RenderBroadheadArrow;
import betterwithmods.client.render.RenderCowHarness;
import betterwithmods.client.render.RenderExtendingRope;
import betterwithmods.client.render.RenderMiningCharge;
import betterwithmods.client.render.RenderPigHarness;
import betterwithmods.client.render.RenderShearedCreeper;
import betterwithmods.client.render.RenderSheepHarness;
import betterwithmods.entity.EntityBroadheadArrow;
import betterwithmods.entity.EntityDynamite;
import betterwithmods.entity.EntityExtendingRope;
import betterwithmods.entity.EntityMiningCharge;
import betterwithmods.entity.EntityShearedCreeper;
import betterwithmods.integration.ICompatModule;
import betterwithmods.proxy.IProxy;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
implements IProxy {
    @Override
    public void preInit() {
        this.registerRenderInformation();
        this.initRenderers();
        BWMod.getLoadedModules().forEach(ICompatModule::preInitClient);
    }

    @Override
    public void init() {
        this.registerColors();
        BWMod.getLoadedModules().forEach(ICompatModule::initClient);
    }

    @Override
    public void postInit() {
        BWMod.getLoadedModules().forEach(ICompatModule::postInitClient);
    }

    private void registerRenderInformation() {
        BWMBlocks.linkBlockModels();
        BWMItems.linkItemModels();
        RenderUtils.registerFilters();
        ModelLoader.setCustomStateMapper((Block)BWMBlocks.STOKED_FLAME, (IStateMapper)new BWStateMapper(BWMBlocks.STOKED_FLAME.getRegistryName().toString()));
        ModelLoader.setCustomStateMapper((Block)BWMBlocks.WINDMILL_BLOCK, (IStateMapper)new BWStateMapper(BWMBlocks.WINDMILL_BLOCK.getRegistryName().toString()));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindmillHorizontal.class, (TileEntitySpecialRenderer)new TESRWindmill());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindmillVertical.class, (TileEntitySpecialRenderer)new TESRVerticalWindmill());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWaterwheel.class, (TileEntitySpecialRenderer)new TESRWaterwheel());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFilteredHopper.class, (TileEntitySpecialRenderer)new TESRFilteredHopper());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTurntable.class, (TileEntitySpecialRenderer)new TESRTurntable());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCrucible.class, (TileEntitySpecialRenderer)new TESRCrucible());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCauldron.class, (TileEntitySpecialRenderer)new TESRCauldron());
    }

    private void registerColors() {
        BlockColors col = Minecraft.func_71410_x().func_184125_al();
        col.func_186722_a(ColorHandlers.BlockPlanterColor, new Block[]{BWMBlocks.PLANTER});
        col.func_186722_a(ColorHandlers.BlockFoliageColor, new Block[]{BWMBlocks.VINE_TRAP});
        ItemColors itCol = Minecraft.func_71410_x().getItemColors();
        itCol.func_186731_a(ColorHandlers.ItemPlanterColor, new Block[]{BWMBlocks.PLANTER});
        itCol.func_186731_a(ColorHandlers.ItemFoliageColor, new Block[]{BWMBlocks.VINE_TRAP});
        col.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0), new Block[]{BWMBlocks.DIRT_SLAB});
        itCol.func_186731_a((stack, tintIndex) -> {
            IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return col.func_186724_a(iblockstate, null, null, tintIndex);
        }, new Block[]{BWMBlocks.DIRT_SLAB});
    }

    private void initRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, manager -> new RenderSnowball(manager, BWMItems.DYNAMITE, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(EntityMiningCharge.class, RenderMiningCharge::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityExtendingRope.class, RenderExtendingRope::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityShearedCreeper.class, RenderShearedCreeper::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCow.class, RenderCowHarness::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPig.class, RenderPigHarness::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySheep.class, RenderSheepHarness::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBroadheadArrow.class, RenderBroadheadArrow::new);
    }
}

