/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.util.player.EntityPlayerExt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BWMFoodStats
extends FoodStats {
    private static final int EXHAUSTION_WITH_TIME_PERIOD = 600;
    private static final float EXHAUSTION_WITH_TIME_AMOUNT = 0.5f;
    private final EntityPlayer player;
    private int exhaustionTimer = 0;

    public BWMFoodStats(EntityPlayer playerIn) {
        this.player = playerIn;
    }

    public void func_75113_a(float exhaustion) {
        super.func_75113_a(exhaustion * EntityPlayerExt.getArmorExhaustionModifier(this.player));
    }

    private void updateExhaustionWithTime(EntityPlayer player) {
        ++this.exhaustionTimer;
        if (this.exhaustionTimer >= 600) {
            if (!player.field_71075_bZ.field_75102_a) {
                this.func_75113_a(0.5f);
            }
            this.exhaustionTimer = 0;
        }
    }

    private boolean shouldBurnFat() {
        return this.func_75115_e() > (float)((this.func_75116_a() + 5) / 6) * 2.0f;
    }

    public void func_75122_a(int foodLevelIn, float foodSaturationModifier) {
        int currentFoodLevel = this.func_75116_a();
        this.func_75114_a(Math.min(foodLevelIn + currentFoodLevel, 60));
        int overWeight = foodLevelIn - (this.func_75116_a() - currentFoodLevel);
        if (overWeight > 0) {
            this.setSaturation(Math.min(this.func_75115_e() + (float)overWeight * foodSaturationModifier / 3.0f, 20.0f));
        }
    }

    public void func_75118_a(EntityPlayer player) {
        EnumDifficulty enumdifficulty = player.func_130014_f_().func_175659_aa();
        this.setPrevFoodLevel(this.func_75116_a());
        if (enumdifficulty != EnumDifficulty.PEACEFUL) {
            this.updateExhaustionWithTime(player);
            while (this.func_75116_a() > 0 && this.getExhaustion() >= 1.33f && !this.shouldBurnFat()) {
                this.setExhaustion(this.getExhaustion() - 1.0f);
                this.func_75114_a(Math.max(this.func_75116_a() - 1, 0));
            }
            while (this.getExhaustion() >= 0.5f && this.shouldBurnFat()) {
                this.setExhaustion(this.getExhaustion() - 0.5f);
                this.setSaturation(Math.max(this.func_75115_e() - 0.125f, 0.0f));
            }
        } else {
            this.setExhaustion(0.0f);
        }
        if (player.func_130014_f_().func_82736_K().func_82766_b("naturalRegeneration") && this.func_75116_a() >= 24 && player.func_70996_bM()) {
            this.setFoodTimer(this.getFoodTimer() + 1);
            if (this.getFoodTimer() >= 600) {
                player.func_70691_i(1.0f);
                this.setFoodTimer(0);
            }
        } else if (this.func_75116_a() <= 0 && this.func_75115_e() <= 0.01f) {
            this.setFoodTimer(this.getFoodTimer() + 1);
            if (this.getFoodTimer() >= 80) {
                if (enumdifficulty != EnumDifficulty.PEACEFUL) {
                    player.func_70097_a(DamageSource.field_76366_f, 1.0f);
                }
                this.setFoodTimer(0);
            }
        } else {
            this.setFoodTimer(0);
        }
    }

    public void func_75112_a(NBTTagCompound compound) {
        super.func_75112_a(compound);
        if (compound.func_74764_b("foodExhaustionTimer")) {
            this.exhaustionTimer = compound.func_74762_e("foodExhaustionTimer");
        }
        if (!compound.func_74764_b("bwmAdjustedFoodStats")) {
            this.func_75114_a(this.func_75116_a() * 3);
            this.setSaturation(0.0f);
        }
        if (this.func_75116_a() > 60) {
            this.func_75114_a(60);
        }
        if (this.func_75115_e() > 20.0f) {
            this.setSaturation(20.0f);
        }
    }

    public void func_75117_b(NBTTagCompound compound) {
        super.func_75117_b(compound);
        compound.func_74768_a("foodExhaustionTimer", this.exhaustionTimer);
        compound.func_74757_a("bwmAdjustedFoodStats", true);
    }

    public boolean func_75121_c() {
        return (float)this.func_75116_a() < 60.0f;
    }

    public float getExhaustion() {
        return ((Float)ReflectionHelper.getPrivateValue(FoodStats.class, (Object)((Object)this), (String[])new String[]{"field_75126_c", "foodExhaustionLevel"})).floatValue();
    }

    public void setExhaustion(float exhaustionIn) {
        ReflectionHelper.setPrivateValue(FoodStats.class, (Object)((Object)this), (Object)Float.valueOf(exhaustionIn), (String[])new String[]{"field_75126_c", "foodExhaustionLevel"});
    }

    public int getFoodTimer() {
        return (Integer)ReflectionHelper.getPrivateValue(FoodStats.class, (Object)((Object)this), (String[])new String[]{"field_75123_d", "foodTimer"});
    }

    public void setFoodTimer(int foodTimerIn) {
        ReflectionHelper.setPrivateValue(FoodStats.class, (Object)((Object)this), (Object)foodTimerIn, (String[])new String[]{"field_75123_d", "foodTimer"});
    }

    public void setPrevFoodLevel(int prevFoodLevel) {
        ReflectionHelper.setPrivateValue(FoodStats.class, (Object)((Object)this), (Object)prevFoodLevel, (String[])new String[]{"field_75124_e", "prevFoodLevel"});
    }

    private void setSaturation(float saturation) {
        ReflectionHelper.setPrivateValue(FoodStats.class, (Object)((Object)this), (Object)Float.valueOf(saturation), (String[])new String[]{"field_75125_b", "foodSaturationLevel"});
    }
}

