/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.api.block.ITurnable;
import com.google.common.base.Predicate;
import java.util.Objects;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DirUtils {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static final PropertyDirection HORIZONTAL = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyDirection TILTING = PropertyDirection.func_177712_a((String)"facing", facing -> facing != EnumFacing.DOWN);
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");

    public static void setEntityOrientationFacing(EntityLivingBase entity, EnumFacing side) {
        float pitch = 0.0f;
        float yaw = 0.0f;
        switch (side) {
            case UP: {
                pitch = 61.0f;
                break;
            }
            case DOWN: {
                pitch = -61.0f;
                break;
            }
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
                break;
            }
            case SOUTH: {
                yaw = 0.0f;
                break;
            }
            case EAST: {
                yaw = -90.0f;
            }
        }
        entity.field_70177_z = yaw;
        entity.field_70125_A = pitch;
    }

    public static EnumFacing convertEntityOrientationToFacing(EntityLivingBase entity, EnumFacing side) {
        if (entity == null) {
            return side;
        }
        float pitch = entity.field_70125_A;
        if (pitch > 60.0f) {
            return EnumFacing.UP;
        }
        if (pitch < -60.0f) {
            return EnumFacing.DOWN;
        }
        return DirUtils.convertEntityOrientationToFlatFacing(entity, side);
    }

    public static EnumFacing convertEntityOrientationToFlatFacing(EntityLivingBase entity, EnumFacing side) {
        if (entity == null) {
            return side;
        }
        return entity.func_174811_aO().func_176734_d();
    }

    public static EnumFacing convertEntityOrientationToFlatFacing(EntityLivingBase entity) {
        return entity.func_174811_aO().func_176734_d();
    }

    public static EnumFacing getOpposite(EnumFacing facing) {
        return facing.func_176734_d();
    }

    public static EnumFacing rotateFacingAroundY(EnumFacing facing, boolean reverse) {
        if (facing.ordinal() >= 2) {
            switch (facing) {
                case NORTH: {
                    facing = EnumFacing.EAST;
                    break;
                }
                case SOUTH: {
                    facing = EnumFacing.WEST;
                    break;
                }
                case WEST: {
                    facing = EnumFacing.NORTH;
                    break;
                }
                case EAST: {
                    facing = EnumFacing.SOUTH;
                    break;
                }
            }
            if (reverse) {
                facing = DirUtils.getOpposite(facing);
            }
        }
        return facing;
    }

    public static boolean rotateAroundY(ITurnable block, World world, BlockPos pos, boolean reverse) {
        IBlockState state = world.func_180495_p(pos);
        IBlockState newState = DirUtils.rotateStateAroundY(block, state, reverse);
        if (newState != state) {
            world.func_175656_a(pos, newState);
            world.func_175704_b(pos, pos);
            return true;
        }
        return false;
    }

    public static IBlockState rotateStateAroundY(ITurnable block, IBlockState state, boolean reverse) {
        EnumFacing facing = block.getFacingFromBlockState(state);
        EnumFacing newFacing = DirUtils.rotateFacingAroundY(facing, reverse);
        state = block.setFacingInBlock(state, newFacing);
        return state;
    }

    public static EnumFacing cycleFacing(EnumFacing facing, boolean reverse) {
        if (reverse) {
            switch (facing) {
                case DOWN: {
                    facing = EnumFacing.UP;
                    break;
                }
                case UP: {
                    facing = EnumFacing.NORTH;
                    break;
                }
                case NORTH: {
                    facing = EnumFacing.EAST;
                    break;
                }
                case SOUTH: {
                    facing = EnumFacing.WEST;
                    break;
                }
                case WEST: {
                    facing = EnumFacing.DOWN;
                    break;
                }
                case EAST: {
                    facing = EnumFacing.SOUTH;
                }
            }
        } else {
            switch (facing) {
                case DOWN: {
                    facing = EnumFacing.WEST;
                    break;
                }
                case UP: {
                    facing = EnumFacing.DOWN;
                    break;
                }
                case NORTH: {
                    facing = EnumFacing.UP;
                    break;
                }
                case SOUTH: {
                    facing = EnumFacing.EAST;
                    break;
                }
                case WEST: {
                    facing = EnumFacing.SOUTH;
                    break;
                }
                case EAST: {
                    facing = EnumFacing.NORTH;
                }
            }
        }
        return facing;
    }

    public static int getPlacementMeta(String type, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (Objects.equals(type, "siding")) {
            return side.func_176734_d().ordinal();
        }
        if (Objects.equals(type, "moulding")) {
            return DirUtils.getMoulding(side, hitX, hitY, hitZ).getMeta();
        }
        if (Objects.equals(type, "corner")) {
            if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
                boolean up;
                boolean bl = up = side == EnumFacing.UP;
                if (hitX < 0.5f && hitZ < 0.5f) {
                    return up ? 1 : 5;
                }
                if (hitX < 0.5f && hitZ > 0.5f) {
                    return up ? 0 : 4;
                }
                if (hitX > 0.5f && hitZ < 0.5f) {
                    return up ? 3 : 7;
                }
                return up ? 2 : 6;
            }
            if (side == EnumFacing.SOUTH || side == EnumFacing.NORTH) {
                boolean south;
                boolean bl = south = side == EnumFacing.SOUTH;
                if (hitX < 0.5f && hitY < 0.5f) {
                    return south ? 1 : 0;
                }
                if (hitX < 0.5f && hitY > 0.5f) {
                    return south ? 5 : 4;
                }
                if (hitX > 0.5f && hitY < 0.5f) {
                    return south ? 3 : 2;
                }
                return south ? 7 : 6;
            }
            if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                boolean east;
                boolean bl = east = side == EnumFacing.EAST;
                if (hitZ > 0.5f && hitY < 0.5f) {
                    return east ? 0 : 2;
                }
                if (hitZ > 0.5f && hitY > 0.5f) {
                    return east ? 4 : 6;
                }
                if (hitZ < 0.5f && hitY < 0.5f) {
                    return east ? 1 : 3;
                }
                return east ? 5 : 7;
            }
        }
        return 0;
    }

    private static EnumMoulding getMoulding(EnumFacing side, float hitX, float hitY, float hitZ) {
        float rX = 1.0f - hitX;
        float rY = 1.0f - hitY;
        float rZ = 1.0f - hitZ;
        if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
            if (hitX < 0.25f && hitZ < 0.25f) {
                return EnumMoulding.VERTNORTHWEST;
            }
            if (hitX > 0.75f && hitZ < 0.25f) {
                return EnumMoulding.VERTNORTHEAST;
            }
            if (hitX < 0.25f && hitZ > 0.75f) {
                return EnumMoulding.VERTSOUTHWEST;
            }
            if (hitX > 0.75f && hitZ > 0.75f) {
                return EnumMoulding.VERTSOUTHEAST;
            }
            if (side == EnumFacing.UP) {
                if (hitX < 0.5f && hitZ < 0.5f) {
                    return hitX < hitZ ? EnumMoulding.DOWNWEST : EnumMoulding.DOWNNORTH;
                }
                if (hitX < 0.5f && hitZ > 0.5f) {
                    return hitX < rZ ? EnumMoulding.DOWNWEST : EnumMoulding.DOWNSOUTH;
                }
                if (hitX > 0.5f && hitZ < 0.5f) {
                    return rX < hitZ ? EnumMoulding.DOWNEAST : EnumMoulding.DOWNSOUTH;
                }
                return hitX < hitZ ? EnumMoulding.DOWNNORTH : EnumMoulding.DOWNEAST;
            }
            if (hitX < 0.5f && hitZ < 0.5f) {
                return hitX < hitZ ? EnumMoulding.UPWEST : EnumMoulding.UPNORTH;
            }
            if (hitX < 0.5f && hitZ > 0.5f) {
                return hitX < rZ ? EnumMoulding.UPWEST : EnumMoulding.UPSOUTH;
            }
            if (hitX > 0.5f && hitZ < 0.5f) {
                return rX < hitZ ? EnumMoulding.UPEAST : EnumMoulding.UPSOUTH;
            }
            return hitX < hitZ ? EnumMoulding.UPNORTH : EnumMoulding.UPEAST;
        }
        if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
            if (hitX < 0.25f && hitY < 0.25f) {
                return EnumMoulding.DOWNWEST;
            }
            if (hitX > 0.75f && hitY < 0.25f) {
                return EnumMoulding.DOWNEAST;
            }
            if (hitX < 0.25f && hitY > 0.75f) {
                return EnumMoulding.UPWEST;
            }
            if (hitX > 0.75f && hitY > 0.75f) {
                return EnumMoulding.UPEAST;
            }
            if (side == EnumFacing.SOUTH) {
                if (hitX < 0.5f && hitY < 0.5f) {
                    return hitX < hitY ? EnumMoulding.VERTNORTHWEST : EnumMoulding.DOWNNORTH;
                }
                if (hitX < 0.5f && hitY > 0.5f) {
                    return hitX < rY ? EnumMoulding.VERTNORTHWEST : EnumMoulding.UPNORTH;
                }
                if (hitX > 0.5f && hitY < 0.5f) {
                    return rX < hitY ? EnumMoulding.VERTNORTHEAST : EnumMoulding.DOWNNORTH;
                }
                return hitX < hitY ? EnumMoulding.VERTNORTHEAST : EnumMoulding.UPNORTH;
            }
            if (hitX < 0.5f && hitY < 0.5f) {
                return hitX < hitY ? EnumMoulding.VERTSOUTHWEST : EnumMoulding.DOWNSOUTH;
            }
            if (hitX < 0.5f && hitY > 0.5f) {
                return hitX < rY ? EnumMoulding.VERTSOUTHWEST : EnumMoulding.UPSOUTH;
            }
            if (hitX > 0.5f && hitY < 0.5f) {
                return rX < hitY ? EnumMoulding.VERTSOUTHEAST : EnumMoulding.DOWNSOUTH;
            }
            return hitX < hitY ? EnumMoulding.VERTSOUTHEAST : EnumMoulding.UPSOUTH;
        }
        if (side == EnumFacing.WEST || side == EnumFacing.EAST) {
            if (hitZ < 0.25f && hitY < 0.25f) {
                return EnumMoulding.DOWNNORTH;
            }
            if (hitZ > 0.75f && hitY < 0.25f) {
                return EnumMoulding.DOWNSOUTH;
            }
            if (hitZ < 0.25f && hitY > 0.75f) {
                return EnumMoulding.UPNORTH;
            }
            if (hitZ > 0.75f && hitY > 0.75f) {
                return EnumMoulding.UPSOUTH;
            }
            if (side == EnumFacing.EAST) {
                if (hitZ < 0.5f && hitY < 0.5f) {
                    return hitZ < hitY ? EnumMoulding.VERTNORTHWEST : EnumMoulding.DOWNWEST;
                }
                if (hitZ < 0.5f && hitY > 0.5f) {
                    return hitZ < rY ? EnumMoulding.VERTNORTHWEST : EnumMoulding.UPWEST;
                }
                if (hitZ > 0.5f && hitY < 0.5f) {
                    return rZ < hitY ? EnumMoulding.VERTSOUTHWEST : EnumMoulding.DOWNWEST;
                }
                return hitZ < hitY ? EnumMoulding.VERTSOUTHWEST : EnumMoulding.UPWEST;
            }
            if (hitZ < 0.5f && hitY < 0.5f) {
                return hitZ < hitY ? EnumMoulding.VERTNORTHEAST : EnumMoulding.DOWNEAST;
            }
            if (hitZ < 0.5f && hitY > 0.5f) {
                return hitZ < rY ? EnumMoulding.VERTNORTHEAST : EnumMoulding.UPEAST;
            }
            if (hitZ > 0.5f && hitY < 0.5f) {
                return rZ < hitY ? EnumMoulding.VERTSOUTHEAST : EnumMoulding.DOWNEAST;
            }
            return hitZ < hitY ? EnumMoulding.VERTSOUTHEAST : EnumMoulding.UPEAST;
        }
        return EnumMoulding.DOWNWEST;
    }

    public static BlockPos movePos(BlockPos source, EnumFacing facing) {
        return source.func_177971_a(facing.func_176730_m());
    }

    public static EnumFacing.Axis getNextAxis(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return EnumFacing.Axis.Y;
            }
            case Y: {
                return EnumFacing.Axis.Z;
            }
        }
        return EnumFacing.Axis.X;
    }

    public static int getLegacyAxis(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return 2;
            }
            case Y: {
                return 0;
            }
        }
        return 1;
    }

    public static EnumFacing.Axis getAxisFromLegacy(int axis) {
        switch (axis) {
            case 0: {
                return EnumFacing.Axis.Y;
            }
            case 1: {
                return EnumFacing.Axis.Z;
            }
        }
        return EnumFacing.Axis.X;
    }

    private static enum EnumMoulding {
        DOWNWEST(0),
        DOWNNORTH(1),
        DOWNSOUTH(2),
        DOWNEAST(3),
        UPWEST(4),
        UPNORTH(5),
        UPSOUTH(6),
        UPEAST(7),
        VERTNORTHWEST(8),
        VERTNORTHEAST(9),
        VERTSOUTHWEST(10),
        VERTSOUTHEAST(11);

        private final int meta;

        private EnumMoulding(int meta) {
            this.meta = meta;
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

