/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DispenserBehaviorFiniteWater
extends BehaviorDefaultDispenseItem {
    private final BehaviorDefaultDispenseItem dispenseBehavior = new BehaviorDefaultDispenseItem();

    public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
        if (FluidUtil.getFluidContained((ItemStack)stack) != null) {
            return this.dumpContainer(source, stack);
        }
        return this.fillContainer(source, stack);
    }

    private ItemStack fillContainer(IBlockSource source, ItemStack stack) {
        World world = source.func_82618_k();
        EnumFacing dispenserFacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        BlockPos blockpos = source.func_180699_d().func_177972_a(dispenserFacing);
        ItemStack result = FluidUtil.tryPickUpFluid((ItemStack)stack, null, (World)world, (BlockPos)blockpos, (EnumFacing)dispenserFacing.func_176734_d());
        if (result == null) {
            return super.func_82487_b(source, stack);
        }
        if (--stack.field_77994_a == 0) {
            stack.deserializeNBT(result.serializeNBT());
        } else if (((TileEntityDispenser)source.func_150835_j()).func_146019_a(result) < 0) {
            this.dispenseBehavior.func_82482_a(source, result);
        }
        return stack;
    }

    private ItemStack dumpContainer(IBlockSource source, ItemStack stack) {
        ItemStack dispensedStack = stack.func_77946_l();
        dispensedStack.field_77994_a = 1;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)dispensedStack);
        if (fluidHandler == null) {
            return super.func_82487_b(source, stack);
        }
        FluidStack fluidStack = fluidHandler.drain(1000, false);
        EnumFacing dispenserFacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        BlockPos blockpos = source.func_180699_d().func_177972_a(dispenserFacing);
        if (fluidStack != null && fluidStack.amount == 1000 && FluidUtil.tryPlaceFluid(null, (World)source.func_82618_k(), (FluidStack)fluidStack, (BlockPos)blockpos)) {
            if (fluidStack.getFluid() == FluidRegistry.WATER) {
                source.func_82618_k().func_175656_a(blockpos, Blocks.field_150358_i.func_176203_a(2));
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    BlockPos off = blockpos.func_177972_a(face);
                    if (!source.func_82618_k().func_175623_d(off) && !source.func_82618_k().func_180495_p(off).func_177230_c().func_176200_f((IBlockAccess)source.func_82618_k(), off)) continue;
                    source.func_82618_k().func_175656_a(off, Blocks.field_150358_i.func_176203_a(5));
                }
            }
            fluidHandler.drain(1000, true);
            if (--stack.field_77994_a == 0) {
                stack.deserializeNBT(dispensedStack.serializeNBT());
            } else if (((TileEntityDispenser)source.func_150835_j()).func_146019_a(dispensedStack) < 0) {
                this.dispenseBehavior.func_82482_a(source, dispensedStack);
            }
            return stack;
        }
        return this.dispenseBehavior.func_82482_a(source, stack);
    }
}

