/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.BWMod;
import betterwithmods.config.BWConfig;
import betterwithmods.util.RecipeUtils;
import betterwithmods.util.item.ToolsManager;
import betterwithmods.world.gen.feature.WorldGenBigTreeWithStump;
import betterwithmods.world.gen.feature.WorldGenBirchTreeWithStump;
import betterwithmods.world.gen.feature.WorldGenCanopyTreeWithStump;
import betterwithmods.world.gen.feature.WorldGenMegaJungleWithStump;
import betterwithmods.world.gen.feature.WorldGenMegaPineTreeWithStump;
import betterwithmods.world.gen.feature.WorldGenSavannaTreeWithStump;
import betterwithmods.world.gen.feature.WorldGenTaiga2WithStump;
import betterwithmods.world.gen.feature.WorldGenTreesWithStump;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.oredict.OreDictionary;

public final class HardcoreFunctions {
    private HardcoreFunctions() {
    }

    @Nullable
    public static BlockPlanks.EnumType getWoodType(IBlockState state) {
        if (state.func_177228_b().containsKey((Object)BlockPlanks.field_176383_a)) {
            return (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockPlanks.field_176383_a);
        }
        if (state.func_177228_b().containsKey((Object)BlockOldLog.field_176301_b)) {
            return (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockOldLog.field_176301_b);
        }
        if (state.func_177228_b().containsKey((Object)BlockNewLog.field_176300_b)) {
            return (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockNewLog.field_176300_b);
        }
        return null;
    }

    private static boolean isTwoByTwoOfType(BlockSapling sapling, World worldIn, BlockPos pos, int p_181624_3_, int p_181624_4_, BlockPlanks.EnumType type) {
        return sapling.func_176477_a(worldIn, pos.func_177982_a(p_181624_3_, 0, p_181624_4_), type) && sapling.func_176477_a(worldIn, pos.func_177982_a(p_181624_3_ + 1, 0, p_181624_4_), type) && sapling.func_176477_a(worldIn, pos.func_177982_a(p_181624_3_, 0, p_181624_4_ + 1), type) && sapling.func_176477_a(worldIn, pos.func_177982_a(p_181624_3_ + 1, 0, p_181624_4_ + 1), type);
    }

    public static void generateTreeWithStump(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!(state.func_177230_c() instanceof BlockSapling)) {
            return;
        }
        BlockSapling sapling = (BlockSapling)state.func_177230_c();
        Object worldgenerator = rand.nextInt(10) == 0 ? new WorldGenBigTreeWithStump(true) : new WorldGenTreesWithStump(true);
        int i = 0;
        int j = 0;
        boolean flag = false;
        switch ((BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockSapling.field_176480_a)) {
            case SPRUCE: {
                block7: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!HardcoreFunctions.isTwoByTwoOfType(sapling, worldIn, pos, i, j, BlockPlanks.EnumType.SPRUCE)) continue;
                        worldgenerator = new WorldGenMegaPineTreeWithStump(false, rand.nextBoolean());
                        flag = true;
                        break block7;
                    }
                }
                if (flag) break;
                i = 0;
                j = 0;
                worldgenerator = new WorldGenTaiga2WithStump(true);
                break;
            }
            case BIRCH: {
                worldgenerator = new WorldGenBirchTreeWithStump(true, false);
                break;
            }
            case JUNGLE: {
                IBlockState iblockstate = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
                IBlockState iblockstate1 = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
                block9: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!HardcoreFunctions.isTwoByTwoOfType(sapling, worldIn, pos, i, j, BlockPlanks.EnumType.JUNGLE)) continue;
                        worldgenerator = new WorldGenMegaJungleWithStump(true, 10, 20, iblockstate, iblockstate1);
                        flag = true;
                        break block9;
                    }
                }
                if (flag) break;
                i = 0;
                j = 0;
                worldgenerator = new WorldGenTreesWithStump(true, 4 + rand.nextInt(7), iblockstate, iblockstate1, false);
                break;
            }
            case ACACIA: {
                worldgenerator = new WorldGenSavannaTreeWithStump(true);
                break;
            }
            case DARK_OAK: {
                block11: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!HardcoreFunctions.isTwoByTwoOfType(sapling, worldIn, pos, i, j, BlockPlanks.EnumType.DARK_OAK)) continue;
                        worldgenerator = new WorldGenCanopyTreeWithStump(true);
                        flag = true;
                        break block11;
                    }
                }
                if (flag) break;
                return;
            }
        }
        IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
        if (flag) {
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate2, 4);
        } else {
            worldIn.func_180501_a(pos, iblockstate2, 4);
        }
        if (!worldgenerator.func_180709_b(worldIn, rand, pos.func_177982_a(i, 0, j))) {
            if (flag) {
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
            } else {
                worldIn.func_180501_a(pos, state, 4);
            }
        }
    }

    public static void applyHCHardness() {
        Blocks.field_150480_ab.func_180686_a((Block)Blocks.field_150362_t, 60, 100);
        Blocks.field_150480_ab.func_180686_a((Block)Blocks.field_150361_u, 60, 100);
        HardcoreFunctions.rebalanceVanillaHardness();
        HardcoreFunctions.changeVanillaToolMaterials();
        ToolsManager.setAxesAsEffectiveAgainst(new Block[]{Blocks.field_150375_by, Blocks.field_150465_bP, Blocks.field_150395_bd, Blocks.field_150321_G, Blocks.field_150434_aF});
        if (BWConfig.axeOnLeaves) {
            ToolsManager.setAxesAsEffectiveAgainst(new Block[]{Blocks.field_150362_t, Blocks.field_150361_u});
            for (ItemStack stack : OreDictionary.getOres((String)"treeLeaves")) {
                Block block;
                if (!(stack.func_77973_b() instanceof ItemBlock) || (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) == Blocks.field_150362_t || block == Blocks.field_150361_u) continue;
                if (block instanceof BlockLeaves) {
                    ToolsManager.setAxesAsEffectiveAgainst(block);
                    block.setHarvestLevel("axe", 0);
                    continue;
                }
                ToolsManager.setAxesAsEffectiveAgainst(block);
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    block.setHarvestLevel("axe", 0);
                    continue;
                }
                if (stack.func_77952_i() >= 16) continue;
                for (int i = 0; i < 4; ++i) {
                    int multi = 4 * i;
                    int meta = stack.func_77960_j() + multi;
                    if (meta >= 16) continue;
                    IBlockState state = block.func_176203_a(meta);
                    block.setHarvestLevel("axe", 0, state);
                }
            }
        }
        ToolsManager.setPickaxesAsEffectiveAgainst(new Block[]{Blocks.field_150442_at, Blocks.field_150359_w, Blocks.field_150399_cn, Blocks.field_150410_aZ, Blocks.field_150397_co, Blocks.field_150430_aB, Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_180384_M, Blocks.field_150426_aN, Blocks.field_150461_bJ, Blocks.field_150418_aU, Blocks.field_150379_bu, Blocks.field_150374_bv});
    }

    public static void removeLowTierToolRecipes() {
        RecipeUtils.removeRecipes(Items.field_151053_p, Short.MAX_VALUE);
        RecipeUtils.removeRecipes(Items.field_151017_I, Short.MAX_VALUE);
        RecipeUtils.removeRecipes(Items.field_151041_m, Short.MAX_VALUE);
        RecipeUtils.removeRecipes(Items.field_151018_J, Short.MAX_VALUE);
        RecipeUtils.removeRecipes(Items.field_151052_q, Short.MAX_VALUE);
    }

    private static void rebalanceVanillaHardness() {
        Blocks.field_150348_b.func_149711_c(2.25f).func_149752_b(10.0f);
        Blocks.field_150344_f.func_149711_c(1.0f).func_149752_b(5.0f);
        Blocks.field_150364_r.func_149711_c(1.25f);
        Blocks.field_150363_s.func_149711_c(1.25f);
        Blocks.field_150322_A.func_149711_c(1.5f);
        Blocks.field_150486_ae.func_149711_c(1.5f);
        Blocks.field_150462_ai.func_149711_c(1.5f);
        Blocks.field_150460_al.func_149711_c(3.0f);
        Blocks.field_150470_am.func_149711_c(3.0f);
        Blocks.field_180413_ao.func_149711_c(1.5f);
        Blocks.field_180414_ap.func_149711_c(1.5f);
        Blocks.field_180412_aq.func_149711_c(1.5f);
        Blocks.field_180411_ar.func_149711_c(1.5f);
        Blocks.field_180410_as.func_149711_c(1.5f);
        Blocks.field_180409_at.func_149711_c(1.5f);
        Blocks.field_150456_au.func_149711_c(1.5f);
        Blocks.field_150421_aI.func_149711_c(1.5f).func_149752_b(10.0f);
        Blocks.field_180407_aO.func_149711_c(1.5f);
        Blocks.field_180408_aP.func_149711_c(1.5f);
        Blocks.field_180404_aQ.func_149711_c(1.5f);
        Blocks.field_180403_aR.func_149711_c(1.5f);
        Blocks.field_180405_aT.func_149711_c(1.5f);
        Blocks.field_180406_aS.func_149711_c(1.5f);
        Blocks.field_150426_aN.func_149711_c(0.6f);
        Blocks.field_150415_aT.func_149711_c(1.5f);
        Blocks.field_150418_aU.func_149711_c(1.5f);
        Blocks.field_150417_aV.func_149711_c(2.25f);
        Blocks.field_180390_bo.func_149711_c(1.5f).func_149752_b(5.0f);
        Blocks.field_180391_bp.func_149711_c(1.5f).func_149752_b(5.0f);
        Blocks.field_180392_bq.func_149711_c(1.5f).func_149752_b(5.0f);
        Blocks.field_180386_br.func_149711_c(1.5f).func_149752_b(5.0f);
        Blocks.field_180387_bt.func_149711_c(1.5f).func_149752_b(5.0f);
        Blocks.field_180385_bs.func_149711_c(1.5f).func_149752_b(5.0f);
        Blocks.field_150376_bx.func_149711_c(1.0f).func_149752_b(5.0f);
        Blocks.field_150449_bY.func_149711_c(1.0f).func_149752_b(5.0f);
        Blocks.field_150371_ca.func_149711_c(2.0f);
        Blocks.field_150370_cb.func_149711_c(2.0f);
    }

    private static void changeVanillaToolMaterials() {
        for (Item.ToolMaterial material : Item.ToolMaterial.values()) {
            ToolMaterialOverride newValues = ToolMaterialOverride.getOverride(material);
            if (newValues == null) continue;
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)newValues.getMaxUses(), (String[])new String[]{"field_78002_g", "maxUses"});
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)Float.valueOf(newValues.getEfficiencyOnProperMaterial()), (String[])new String[]{"field_78010_h", "efficiencyOnProperMaterial"});
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)newValues.getEnchantability(), (String[])new String[]{"field_78008_j", "enchantability"});
        }
        for (Item item : BWMod.itemRegistry) {
            ItemTool tool;
            ToolMaterialOverride newValues;
            if (!(item instanceof ItemTool) || (newValues = ToolMaterialOverride.getOverride((tool = (ItemTool)item).func_150913_i())) == null) continue;
            tool.func_77656_e(newValues.getMaxUses());
            ReflectionHelper.setPrivateValue(ItemTool.class, (Object)tool, (Object)Float.valueOf(newValues.getEfficiencyOnProperMaterial()), (String[])new String[]{"field_77864_a", "efficiencyOnProperMaterial"});
        }
    }

    private static enum ToolMaterialOverride {
        WOOD(BWConfig.woodDurability - 1, 1.01f, 0),
        STONE(BWConfig.stoneDurability - 1, 1.01f, 5),
        IRON(BWConfig.ironDurability - 1, 6.0f, 14),
        DIAMOND(BWConfig.diamondDurability - 1, 8.0f, 14),
        GOLD(BWConfig.goldDurability - 1, 12.0f, 22);

        private final int maxUses;
        private final float efficiencyOnProperMaterial;
        private final int enchantability;

        private ToolMaterialOverride(int par4, float par5, int par7) {
            this.maxUses = par4;
            this.efficiencyOnProperMaterial = par5;
            this.enchantability = par7;
        }

        public static ToolMaterialOverride getOverride(Item.ToolMaterial material) {
            switch (material) {
                case WOOD: {
                    return WOOD;
                }
                case STONE: {
                    return STONE;
                }
                case IRON: {
                    return IRON;
                }
                case DIAMOND: {
                    return DIAMOND;
                }
                case GOLD: {
                    return GOLD;
                }
            }
            return null;
        }

        public int getMaxUses() {
            return this.maxUses;
        }

        public float getEfficiencyOnProperMaterial() {
            return this.efficiencyOnProperMaterial;
        }

        public int getEnchantability() {
            return this.enchantability;
        }
    }
}

