/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.craft.OreStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.oredict.OreDictionary;

public class InvUtils {
    public static List<ItemStack> dustNames;
    public static List<ItemStack> oreNames;
    public static List<ItemStack> ingotNames;
    public static List<ItemStack> cropNames;

    public static void postInitOreDictGathering() {
        dustNames = InvUtils.getOreNames("dust");
        oreNames = InvUtils.getOreNames("ore");
        ingotNames = InvUtils.getOreNames("ingot");
        cropNames = InvUtils.getOreNames("crop");
    }

    public static ItemStack getMatchingSuffixStack(ItemStack stack, String startingPrefix, String resultingPrefix) {
        List<ItemStack> list = InvUtils.getMatchingSuffix(stack, startingPrefix, resultingPrefix);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static List<ItemStack> getMatchingSuffix(ItemStack stack, String startingPrefix, String resultingPrefix) {
        return IntStream.of(OreDictionary.getOreIDs((ItemStack)stack)).mapToObj(OreDictionary::getOreName).filter(ore -> ore.startsWith(startingPrefix)).map(ore -> OreDictionary.getOres((String)(resultingPrefix + ore.substring(startingPrefix.length())))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static ArrayList<ItemStack> getOreNames(String prefix) {
        String[] var2;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (String name : var2 = OreDictionary.getOreNames()) {
            if (!name.startsWith(prefix) || OreDictionary.getOres((String)name).size() <= 0) continue;
            list.addAll(OreDictionary.getOres((String)name));
        }
        return list;
    }

    public static int listContains(Object obj, ArrayList<Object> list) {
        if (list != null && list.size() > 0 && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Object toCheck;
                Object stack;
                if (obj instanceof ItemStack && list.get(i) instanceof ItemStack) {
                    stack = (ItemStack)obj;
                    toCheck = (ItemStack)list.get(i);
                    if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)toCheck)) continue;
                    if (toCheck.func_77942_o()) {
                        if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)toCheck)) continue;
                        return i;
                    }
                    if (stack.func_77942_o()) {
                        return -1;
                    }
                    return i;
                }
                if (!(obj instanceof OreStack) || !(list.get(i) instanceof OreStack)) continue;
                stack = (OreStack)obj;
                toCheck = (OreStack)list.get(i);
                if (!((OreStack)stack).getOreName().equals(((OreStack)toCheck).getOreName())) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isOre(ItemStack stack, String ore) {
        return InvUtils.listContains(stack, OreDictionary.getOres((String)ore));
    }

    public static boolean listContains(ItemStack check, List<ItemStack> list) {
        if (list != null) {
            if (list.isEmpty()) {
                return false;
            }
            for (ItemStack item : list) {
                if (!ItemStack.func_179545_c((ItemStack)check, (ItemStack)item) && (check.func_77973_b() != item.func_77973_b() || item.func_77952_i() != Short.MAX_VALUE)) continue;
                return !item.func_77942_o() || ItemStack.func_77970_a((ItemStack)check, (ItemStack)item);
            }
        }
        return false;
    }

    public static boolean listContainsArmor(ItemStack stack, List<ItemStack> list) {
        if (list != null) {
            if (list.isEmpty()) {
                return false;
            }
            Item item = stack.func_77973_b();
            boolean isTool = stack.func_77984_f();
            for (ItemStack check : list) {
                if (isTool && item == check.func_77973_b()) {
                    return true;
                }
                if (!ItemStack.func_179545_c((ItemStack)check, (ItemStack)stack) && (check.func_77973_b() != stack.func_77973_b() || check.func_77952_i() != Short.MAX_VALUE)) continue;
                return !stack.func_77942_o() || ItemStack.func_77970_a((ItemStack)check, (ItemStack)stack);
            }
        }
        return false;
    }

    public static void ejectInventoryContents(World world, BlockPos pos, IItemHandler inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null) continue;
            float fX = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
            float fY = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
            float fZ = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
            while (stack.field_77994_a > 0) {
                int j = world.field_73012_v.nextInt(21) + 10;
                if (j > stack.field_77994_a) {
                    j = stack.field_77994_a;
                }
                stack.field_77994_a -= j;
                EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + fX), (double)((float)pos.func_177956_o() + fY), (double)((float)pos.func_177952_p() + fZ), new ItemStack(stack.func_77973_b(), j, stack.func_77952_i()));
                float f1 = 0.05f;
                item.field_70159_w = (float)world.field_73012_v.nextGaussian() * f1;
                item.field_70181_x = (float)world.field_73012_v.nextGaussian() * f1 + 0.2f;
                item.field_70179_y = (float)world.field_73012_v.nextGaussian() * f1;
                InvUtils.copyTags(item.func_92059_d(), stack);
                world.func_72838_d((Entity)item);
            }
        }
    }

    public static void clearInventory(IItemHandlerModifiable inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null) continue;
            inv.setStackInSlot(i, null);
        }
    }

    public static void copyTags(ItemStack destStack, ItemStack sourceStack) {
        if (sourceStack.func_77942_o()) {
            destStack.func_77982_d(sourceStack.func_77978_p().func_74737_b());
        }
    }

    public static ItemStack decrStackSize(IItemHandlerModifiable inv, int slot, int amount) {
        if (inv.getStackInSlot(slot) != null) {
            if (inv.getStackInSlot((int)slot).field_77994_a <= amount) {
                ItemStack splitStack = inv.getStackInSlot(slot);
                inv.setStackInSlot(slot, null);
                return splitStack;
            }
            ItemStack splitStack = inv.getStackInSlot(slot).func_77979_a(amount);
            if (inv.getStackInSlot((int)slot).field_77994_a < 1) {
                inv.setStackInSlot(slot, null);
            }
            return splitStack;
        }
        return null;
    }

    private static boolean canInsertStack(IItemHandler inv, ItemStack stack, int minSlot, int maxSlot) {
        return InvUtils.insertingStacks(inv, stack, minSlot, maxSlot, true);
    }

    public static boolean addSingleItemToInv(IItemHandler inv, Item item, int meta) {
        ItemStack stack = new ItemStack(item, 1, meta);
        return InvUtils.attemptToInsertStack(inv, stack, 0, inv.getSlots());
    }

    private static boolean attemptToInsertStack(IItemHandler inv, ItemStack stack, int minSlot, int maxSlot) {
        return InvUtils.insertingStacks(inv, stack, minSlot, maxSlot, false);
    }

    private static boolean insertingStacks(IItemHandler inv, ItemStack stack, int minSlot, int maxSlot, boolean simulate) {
        ItemStack leftovers = stack.func_77946_l();
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            if ((leftovers = inv.insertItem(slot, leftovers, simulate)) != null) continue;
            stack.field_77994_a = 0;
            return true;
        }
        stack.field_77994_a = leftovers.field_77994_a;
        return false;
    }

    public static int getFirstOccupiedStackInRange(IItemHandler inv, int minSlot, int maxSlot) {
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (inv.getStackInSlot(slot) == null) continue;
            return slot;
        }
        return -1;
    }

    public static int getFirstEmptyStackInRange(IItemHandler inv, int minSlot, int maxSlot) {
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (inv.getStackInSlot(slot) != null) continue;
            return slot;
        }
        return -1;
    }

    public static int getOccupiedStacks(IItemHandler inv) {
        return InvUtils.getOccupiedStacks(inv, 0, inv.getSlots() - 1);
    }

    public static int getOccupiedStacks(IItemHandler inv, int min, int max) {
        int count = 0;
        for (int i = min; i <= max; ++i) {
            if (inv.getStackInSlot(i) == null) continue;
            ++count;
        }
        return count;
    }

    public static int countItemStacksInInventory(IItemHandler inv, ItemStack toCheck) {
        int itemCount = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null || !ItemStack.func_179545_c((ItemStack)toCheck, (ItemStack)stack) && (toCheck.func_77973_b() != stack.func_77973_b() || toCheck.func_77952_i() != Short.MAX_VALUE)) continue;
            if (toCheck.func_77942_o()) {
                if (!ItemStack.func_77970_a((ItemStack)toCheck, (ItemStack)stack)) continue;
                itemCount += stack.field_77994_a;
                continue;
            }
            itemCount += stack.field_77994_a;
        }
        return itemCount;
    }

    public static int countItemsInInventory(IItemHandler inv, Item item) {
        return InvUtils.countItemsInInventory(inv, item, Short.MAX_VALUE);
    }

    public static int countItemsInInventory(IItemHandler inv, ItemStack stack) {
        return InvUtils.countItemsInInventory(inv, stack.func_77973_b(), stack.func_77960_j());
    }

    public static int countItemsInInventory(IItemHandler inv, Item item, int meta) {
        int itemCount = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null || stack.func_77973_b() != item || meta != Short.MAX_VALUE && stack.func_77952_i() != meta) continue;
            itemCount += inv.getStackInSlot((int)i).field_77994_a;
        }
        return itemCount;
    }

    public static int countOresInInventory(IItemHandler inv, List<ItemStack> list) {
        int ret = 0;
        if (list != null && !list.isEmpty() && list.size() > 0) {
            for (ItemStack oreStack : list) {
                ret += InvUtils.countItemStacksInInventory(inv, oreStack);
            }
        }
        return ret;
    }

    public static boolean consumeItemsInInventory(IItemHandlerModifiable inv, ItemStack toCheck, int stackSize) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null || !ItemStack.func_179545_c((ItemStack)toCheck, (ItemStack)stack) && (toCheck.func_77973_b() != stack.func_77973_b() || toCheck.func_77952_i() != Short.MAX_VALUE)) continue;
            if (toCheck.func_77942_o()) {
                if (!ItemStack.func_77970_a((ItemStack)toCheck, (ItemStack)stack)) continue;
                if (stack.field_77994_a >= stackSize) {
                    InvUtils.decrStackSize(inv, i, stackSize);
                    return true;
                }
                stackSize -= stack.field_77994_a;
                inv.setStackInSlot(i, null);
                continue;
            }
            if (stack.field_77994_a >= stackSize) {
                InvUtils.decrStackSize(inv, i, stackSize);
                return true;
            }
            stackSize -= stack.field_77994_a;
            inv.setStackInSlot(i, null);
        }
        return false;
    }

    public static boolean consumeItemsInInventory(IItemHandlerModifiable inv, Item item, int meta, int stackSize) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null || stack.func_77973_b() != item || meta != Short.MAX_VALUE && stack.func_77952_i() != meta) continue;
            if (stack.field_77994_a >= stackSize) {
                InvUtils.decrStackSize(inv, i, stackSize);
                return false;
            }
            stackSize -= stack.field_77994_a;
            inv.setStackInSlot(i, null);
        }
        return false;
    }

    public static boolean consumeOresInInventory(IItemHandlerModifiable inv, List<?> list, int stackSize) {
        if (list.size() > 0) {
            for (Object aList : list) {
                ItemStack tempStack = (ItemStack)aList;
                Item item = tempStack.func_77973_b();
                int meta = tempStack.func_77952_i();
                for (int j = 0; j < inv.getSlots(); ++j) {
                    ItemStack stack = inv.getStackInSlot(j);
                    if (stack == null || stack.func_77973_b() != item || stack.func_77952_i() != meta && meta != Short.MAX_VALUE) continue;
                    if (tempStack.func_77942_o()) {
                        if (!ItemStack.func_77970_a((ItemStack)tempStack, (ItemStack)stack)) continue;
                        if (stack.field_77994_a >= stackSize) {
                            InvUtils.decrStackSize(inv, j, stackSize);
                            return false;
                        }
                        stackSize -= stack.field_77994_a;
                        inv.setStackInSlot(j, null);
                        continue;
                    }
                    if (stack.field_77994_a >= stackSize) {
                        InvUtils.decrStackSize(inv, j, stackSize);
                        return false;
                    }
                    stackSize -= stack.field_77994_a;
                    inv.setStackInSlot(j, null);
                }
            }
        }
        return false;
    }

    public static int getFirstOccupiedStackNotOfItem(IItemHandler inv, Item item) {
        return InvUtils.getFirstOccupiedStackNotOfItem(inv, item, Short.MAX_VALUE);
    }

    public static int getFirstOccupiedStackNotOfItem(IItemHandler inv, Item item, int meta) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i) == null) continue;
            int tempMeta = inv.getStackInSlot(i).func_77952_i();
            if (inv.getStackInSlot(i).func_77973_b() == item || meta != Short.MAX_VALUE && tempMeta == meta) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstOccupiedStackOfItem(IItemHandler inv, ItemStack stack) {
        return InvUtils.getFirstOccupiedStackOfItem(inv, stack.func_77973_b(), stack.func_77960_j());
    }

    public static int getFirstOccupiedStackOfItem(IItemHandler inv, Item item, int meta) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i) == null) continue;
            int tempMeta = inv.getStackInSlot(i).func_77952_i();
            if (inv.getStackInSlot(i).func_77973_b() != item || meta != Short.MAX_VALUE && tempMeta != meta) continue;
            return i;
        }
        return -1;
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack == null) continue;
            InvUtils.ejectStackWithOffset(world, pos, stack.func_77946_l());
        }
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack == null) continue;
            InvUtils.ejectStackWithOffset(world, pos, stack.func_77946_l());
        }
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, ItemStack stack) {
        if (stack == null) {
            return;
        }
        float xOff = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
        float yOff = world.field_73012_v.nextFloat() * 0.2f + 0.1f;
        float zOff = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
        InvUtils.ejectStack(world, (float)pos.func_177958_n() + xOff, (float)pos.func_177956_o() + yOff, (float)pos.func_177952_p() + zOff, stack, 10);
    }

    public static void ejectStack(World world, double x, double y, double z, ItemStack stack, int pickupDelay) {
        EntityItem item = new EntityItem(world, x, y, z, stack);
        float velocity = 0.05f;
        item.field_70159_w = (float)world.field_73012_v.nextGaussian() * velocity;
        item.field_70181_x = (float)world.field_73012_v.nextGaussian() * velocity + 0.2f;
        item.field_70179_y = (float)world.field_73012_v.nextGaussian() * velocity;
        item.func_174867_a(pickupDelay);
        world.func_72838_d((Entity)item);
    }

    public static void ejectStack(World world, double x, double y, double z, ItemStack stack) {
        InvUtils.ejectStack(world, x, y, z, stack, 10);
    }

    public static boolean addItemStackToInv(IItemHandler inventory, ItemStack stack) {
        return InvUtils.attemptToInsertStack(inventory, stack, 0, inventory.getSlots());
    }

    public static boolean checkItemStackInsert(IItemHandler inv, ItemStack stack) {
        return InvUtils.canInsertStack(inv, stack, 0, inv.getSlots());
    }

    public static void ejectBrokenItems(World world, BlockPos pos, ResourceLocation lootLocation) {
        if (!world.field_72995_K) {
            LootContext.Builder build = new LootContext.Builder((WorldServer)world);
            List stacks = world.func_184146_ak().func_186521_a(lootLocation).func_186462_a(world.field_73012_v, build.func_186471_a());
            if (!stacks.isEmpty()) {
                InvUtils.ejectStackWithOffset(world, pos, stacks);
            }
        }
    }

    public static void writeToStack(IItemHandler inv, ItemStack stack) {
        NBTTagCompound tag = InvUtils.saveAllItems(new NBTTagCompound(), inv);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(tag);
        }
    }

    public static void readFromStack(IItemHandler inv, ItemStack stack) {
        NBTTagCompound tag;
        if (stack != null && stack.func_77942_o() && (tag = stack.func_77978_p()) != null) {
            InvUtils.loadAllItems(tag, inv);
        }
    }

    public static int calculateComparatorLevel(@Nonnull IItemHandler inventory) {
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inventory.getSlots(); ++j) {
            ItemStack itemstack = inventory.getStackInSlot(j);
            if (itemstack == null) continue;
            f += (float)itemstack.field_77994_a / (float)itemstack.func_77976_d();
            ++i;
        }
        return MathHelper.func_76141_d((float)((f /= (float)inventory.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    private static NBTTagCompound saveAllItems(NBTTagCompound tag, IItemHandler inv) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        if (!list.func_82582_d()) {
            tag.func_74782_a("Items", (NBTBase)list);
        }
        return tag;
    }

    private static void loadAllItems(NBTTagCompound tag, IItemHandler inv) {
        NBTTagList list = tag.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            int slot = compound.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= inv.getSlots()) continue;
            inv.insertItem(slot, ItemStack.func_77949_a((NBTTagCompound)compound), false);
        }
    }
}

