/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ReportedException;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackMap<T> {
    private final HashMap<Item, HashMap<Integer, T>> map = new HashMap();
    private final T defaultValue;

    public ItemStackMap(T defaultValueIn) {
        this.defaultValue = defaultValueIn;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(ItemStack stack) {
        return this.containsKey(stack.func_77973_b(), stack.func_77960_j());
    }

    public boolean containsKey(Item item, int meta) {
        if (this.map.containsKey(item)) {
            HashMap<Integer, T> metaToValue = this.map.get(item);
            if (metaToValue.containsKey(meta)) {
                return true;
            }
            return metaToValue.containsKey(Short.MAX_VALUE);
        }
        return false;
    }

    public T get(ItemStack stack) {
        return this.get(stack.func_77973_b(), stack.func_77960_j());
    }

    public T get(Item item, int meta) {
        if (this.map.containsKey(item)) {
            HashMap<Integer, T> metaToValue = this.map.get(item);
            if (metaToValue.containsKey(meta)) {
                return metaToValue.get(meta);
            }
            if (metaToValue.containsKey(Short.MAX_VALUE)) {
                return metaToValue.get(Short.MAX_VALUE);
            }
            return this.defaultValue;
        }
        return this.defaultValue;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public T put(Item item, int meta, T value) {
        if (this.map.containsKey(item)) {
            this.map.get(item).put(meta, value);
        } else {
            HashMap<Integer, T> metaToValue = new HashMap<Integer, T>();
            metaToValue.put(meta, value);
            this.map.put(item, metaToValue);
        }
        return value;
    }

    public T put(Item item, T value) {
        return this.put(item, 0, value);
    }

    public T put(Block block, int meta, T value) {
        try {
            ItemStack stack = new ItemStack(block, meta);
            return this.put(stack, value);
        }
        catch (NullPointerException e) {
            CrashReport report = new CrashReport("The block " + block.getRegistryName() + " cannot be converted into an item.", (Throwable)e);
            throw new ReportedException(report);
        }
    }

    public T put(Block block, T value) {
        return this.put(block, 0, value);
    }

    public T put(String oreDictName, T value) {
        List itemStacks = OreDictionary.getOres((String)oreDictName);
        for (ItemStack stack : itemStacks) {
            this.put(stack, value);
        }
        return value;
    }

    public T put(ItemStack stack, T value) {
        return this.put(stack.func_77973_b(), stack.func_77960_j(), value);
    }

    public void putAll(Map<? extends ItemStack, ? extends T> arg0) {
        for (Map.Entry<ItemStack, T> entry : arg0.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set<Map.Entry<Item, HashMap<Integer, T>>> entrySet() {
        return this.map.entrySet();
    }

    public T remove(Item item, int meta) {
        if (this.containsKey(item, meta)) {
            HashMap<Integer, T> prev = this.map.remove(item);
            return prev.get(meta);
        }
        return null;
    }
}

