/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util.player;

import betterwithmods.BWMBlocks;
import betterwithmods.util.item.ItemExt;
import betterwithmods.util.player.FatPenalty;
import betterwithmods.util.player.HealthPenalty;
import betterwithmods.util.player.HungerPenalty;
import betterwithmods.util.player.IPlayerPenalty;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public final class EntityPlayerExt {
    private EntityPlayerExt() {
    }

    public static boolean isSurvival(EntityPlayer player) {
        boolean isAdventure = player.func_130014_f_().func_72912_H().func_76077_q() == GameType.ADVENTURE;
        boolean isCreative = player.field_71075_bZ.field_75098_d;
        return !isAdventure && !isCreative;
    }

    public static float getHealthAndExhaustionModifier(EntityPlayer player) {
        return EntityPlayerExt.getWorstPenalty(player).getModifier();
    }

    public static IPlayerPenalty getWorstPenalty(EntityPlayer player) {
        HealthPenalty healthPenalty = EntityPlayerExt.getHealthPenalty(player);
        HungerPenalty hungerPenalty = EntityPlayerExt.getHungerPenalty(player);
        FatPenalty fatPenalty = EntityPlayerExt.getFatPenalty(player);
        int maximumOrdinal = Math.max(healthPenalty.ordinal(), Math.max(hungerPenalty.ordinal(), fatPenalty.ordinal()));
        if (maximumOrdinal == healthPenalty.ordinal()) {
            return healthPenalty;
        }
        if (maximumOrdinal == hungerPenalty.ordinal()) {
            return hungerPenalty;
        }
        if (maximumOrdinal == fatPenalty.ordinal()) {
            return fatPenalty;
        }
        return healthPenalty;
    }

    public static HungerPenalty getHungerPenalty(EntityPlayer player) {
        int level = player.func_71024_bL().func_75116_a();
        if (level > 24) {
            return HungerPenalty.NO_PENALTY;
        }
        if (level > 18) {
            return HungerPenalty.PECKISH;
        }
        if (level > 12) {
            return HungerPenalty.HUNGRY;
        }
        if (level > 6) {
            return HungerPenalty.FAMISHED;
        }
        if (level > 0 || player.func_71024_bL().func_75115_e() > 0.0f) {
            return HungerPenalty.STARVING;
        }
        return HungerPenalty.DYING;
    }

    private static FatPenalty getFatPenalty(EntityPlayer player) {
        int level = (int)player.func_71024_bL().func_75115_e();
        if (level < 12) {
            return FatPenalty.NO_PENALTY;
        }
        if (level < 14) {
            return FatPenalty.PLUMP;
        }
        if (level < 16) {
            return FatPenalty.CHUBBY;
        }
        if (level < 18) {
            return FatPenalty.FAT;
        }
        return FatPenalty.OBESE;
    }

    private static HealthPenalty getHealthPenalty(EntityPlayer player) {
        int level = (int)player.func_110143_aJ();
        if (level > 10) {
            return HealthPenalty.NO_PENALTY;
        }
        if (level > 8) {
            return HealthPenalty.HURT;
        }
        if (level > 6) {
            return HealthPenalty.INJURED;
        }
        if (level > 4) {
            return HealthPenalty.WOUNDED;
        }
        if (level > 2) {
            return HealthPenalty.CRIPPLED;
        }
        return HealthPenalty.DYING;
    }

    public static boolean canJump(EntityPlayer player) {
        return player.func_110143_aJ() > 4.0f && player.func_71024_bL().func_75116_a() > 12 && (double)player.func_71024_bL().func_75115_e() < 18.0;
    }

    public static boolean canSwim(EntityPlayer player) {
        return !EntityPlayerExt.isWeighted(player) && player.func_110143_aJ() > 4.0f;
    }

    public static boolean isNearBottom(EntityPlayer player) {
        Block toCheck = player.func_130014_f_().func_180495_p(player.func_180425_c().func_177977_b()).func_177230_c();
        Block toCheck2 = player.func_130014_f_().func_180495_p(player.func_180425_c().func_177979_c(2)).func_177230_c();
        return !toCheck.func_176200_f((IBlockAccess)player.func_130014_f_(), player.func_180425_c().func_177977_b()) || !toCheck2.func_176200_f((IBlockAccess)player.func_130014_f_(), player.func_180425_c().func_177979_c(2));
    }

    public static void changeSpeed(EntityLivingBase entity, UUID speedModifierUUID, String name, double modifier) {
        AttributeModifier speedModifier = new AttributeModifier(speedModifierUUID, name, modifier - 1.0, 2);
        IAttributeInstance iattributeinstance = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (iattributeinstance.func_111127_a(speedModifierUUID) != null) {
            iattributeinstance.func_111124_b(speedModifier);
        }
        iattributeinstance.func_111121_a(speedModifier);
    }

    private static int getWornArmorWeight(EntityPlayer player) {
        int weight = 0;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack == null) continue;
            weight = (int)((float)weight + ItemExt.getWeight(stack));
        }
        return weight;
    }

    private static boolean isWeighted(EntityPlayer player) {
        return EntityPlayerExt.getWornArmorWeight(player) >= 10 || EntityPlayerExt.hasHeadCrab(player);
    }

    private static boolean hasHeadCrab(EntityPlayer player) {
        return player.func_184218_aH() && player.func_184187_bx() instanceof EntitySquid;
    }

    public static float getArmorExhaustionModifier(EntityPlayer player) {
        float modifier = 1.0f;
        int weight = EntityPlayerExt.getWornArmorWeight(player);
        if (weight > 0) {
            modifier += (float)weight / 44.0f;
        }
        return modifier;
    }

    public static boolean isCurrentToolEffectiveOnBlock(EntityPlayer player, BlockPos pos) {
        World world;
        IBlockState state;
        ItemStack stack = player.func_184614_ca();
        return EntityPlayerExt.isCurrentToolEffectiveOnBlock(stack, state = (world = player.func_130014_f_()).func_180495_p(pos).func_185899_b((IBlockAccess)world, pos)) && ForgeHooks.isToolEffective((IBlockAccess)player.func_130014_f_(), (BlockPos)pos, (ItemStack)stack);
    }

    public static boolean isCurrentToolEffectiveOnBlock(ItemStack stack, IBlockState state) {
        if (stack == null) {
            return false;
        }
        if (state.func_177230_c() == BWMBlocks.STUMP) {
            return false;
        }
        for (String type : stack.func_77973_b().getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getPlayerHead(EntityPlayer player) {
        ItemStack head = new ItemStack(Items.field_151144_bL, 1, 3);
        NBTTagCompound name = new NBTTagCompound();
        name.func_74778_a("SkullOwner", player.getDisplayNameString());
        head.func_77982_d(name);
        return head;
    }
}

