/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods;

import betterwithmods.BWMod;
import betterwithmods.craft.HardcoreWoodInteraction;
import betterwithmods.craft.KilnInteraction;
import betterwithmods.craft.OreStack;
import betterwithmods.craft.TurntableInteraction;
import betterwithmods.craft.bulk.CraftingManagerBulk;
import betterwithmods.craft.bulk.CraftingManagerCauldron;
import betterwithmods.craft.bulk.CraftingManagerCauldronStoked;
import betterwithmods.craft.bulk.CraftingManagerCrucible;
import betterwithmods.craft.bulk.CraftingManagerCrucibleStoked;
import betterwithmods.craft.bulk.CraftingManagerMill;
import betterwithmods.craft.heat.BWMHeatRegistry;
import betterwithmods.util.NetherSpawnWhitelist;
import com.google.common.collect.ImmutableList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class BWIMCHandler {
    public static void processIMC(ImmutableList<FMLInterModComms.IMCMessage> message) {
        Logger log = BWMod.logger;
        for (FMLInterModComms.IMCMessage m : message) {
            try {
                int meta;
                Block block;
                ItemStack blockStack;
                NBTTagCompound tag;
                String k = m.key;
                log.debug("[BWIMCHandler] %s from %s", new Object[]{k, m.getSender()});
                if ("addCauldronRecipe".equals(k)) {
                    BWIMCHandler.addBulkRecipe(m, CraftingManagerCauldron.getInstance());
                    continue;
                }
                if ("addStokedCauldronRecipe".equals(k)) {
                    BWIMCHandler.addBulkRecipe(m, CraftingManagerCauldronStoked.getInstance());
                    continue;
                }
                if ("addCrucibleRecipe".equals(k)) {
                    BWIMCHandler.addBulkRecipe(m, CraftingManagerCrucible.getInstance());
                    continue;
                }
                if ("addStokedCrucibleRecipe".equals(k)) {
                    BWIMCHandler.addBulkRecipe(m, CraftingManagerCrucibleStoked.getInstance());
                    continue;
                }
                if ("addMillRecipe".equals(k)) {
                    BWIMCHandler.addBulkRecipe(m, CraftingManagerMill.getInstance());
                    continue;
                }
                if ("addKilnRecipe".equals(k)) {
                    if (!m.isNBTMessage()) continue;
                    tag = m.getNBTValue();
                    blockStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Input"));
                    block = null;
                    meta = 0;
                    if (blockStack.func_77973_b() instanceof ItemBlock) {
                        block = ((ItemBlock)blockStack.func_77973_b()).func_179223_d();
                        meta = blockStack.func_77952_i();
                    }
                    if (block == null) continue;
                    if (meta != Short.MAX_VALUE) {
                        KilnInteraction.addBlockRecipe(block, meta, ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Output")));
                        continue;
                    }
                    KilnInteraction.addBlockRecipe(block, ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Output")));
                    continue;
                }
                if ("addTurntableRecipe".equals(k)) {
                    if (!m.isNBTMessage()) continue;
                    tag = m.getNBTValue();
                    blockStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Input"));
                    block = null;
                    meta = 0;
                    if (blockStack.func_77973_b() instanceof ItemBlock) {
                        block = ((ItemBlock)blockStack.func_77973_b()).func_179223_d();
                        meta = blockStack.func_77952_i();
                    }
                    if (block == null) continue;
                    if (meta != Short.MAX_VALUE) {
                        TurntableInteraction.addBlockRecipe(block, meta, ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Output")));
                        continue;
                    }
                    TurntableInteraction.addBlockRecipe(block, ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Output")));
                    continue;
                }
                if ("addHeatRegistry".equals(k)) {
                    if (!m.isNBTMessage()) continue;
                    tag = m.getNBTValue();
                    blockStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Input"));
                    block = null;
                    meta = 0;
                    int value = tag.func_74762_e("HeatValue");
                    if (blockStack.func_77973_b() instanceof ItemBlock) {
                        block = ((ItemBlock)blockStack.func_77973_b()).func_179223_d();
                        meta = blockStack.func_77952_i();
                    }
                    if (block == null) continue;
                    if (meta != Short.MAX_VALUE) {
                        BWMHeatRegistry.setBlockHeatRegistry(block, meta, value);
                        continue;
                    }
                    BWMHeatRegistry.setBlockHeatRegistry(block, value);
                    continue;
                }
                if ("addNetherSpawnBlock".equals(k)) {
                    if (!m.isNBTMessage()) continue;
                    tag = m.getNBTValue();
                    blockStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Spawn"));
                    block = null;
                    meta = 0;
                    if (blockStack.func_77973_b() instanceof ItemBlock) {
                        block = ((ItemBlock)blockStack.func_77973_b()).func_179223_d();
                        meta = blockStack.func_77952_i();
                    }
                    if (block == null) continue;
                    if (meta != Short.MAX_VALUE) {
                        NetherSpawnWhitelist.addBlock(block, meta);
                        continue;
                    }
                    NetherSpawnWhitelist.addBlock(block);
                    continue;
                }
                if (!"addLogHarvest".equals(k) || !m.isNBTMessage()) continue;
                tag = m.getNBTValue();
                blockStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Input"));
                block = null;
                meta = 0;
                ItemStack plankStack = null;
                if (tag.func_74764_b("Output")) {
                    plankStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Output"));
                }
                if (blockStack.func_77973_b() instanceof ItemBlock) {
                    block = ((ItemBlock)blockStack.func_77973_b()).func_179223_d();
                    meta = blockStack.func_77952_i();
                }
                if (block == null) continue;
                if (meta != Short.MAX_VALUE) {
                    HardcoreWoodInteraction.addBlock(block, meta, plankStack);
                    continue;
                }
                HardcoreWoodInteraction.addBlock(block, plankStack);
            }
            catch (Throwable t) {
                BWIMCHandler.bigWarning(log, Level.ERROR, "Bad IMC message (%s)\nfrom %s", m.key, m.getSender());
                log.catching(t);
            }
        }
    }

    private static void addBulkRecipe(FMLInterModComms.IMCMessage m, CraftingManagerBulk craft) {
        if (m.isNBTMessage()) {
            NBTTagCompound tag = m.getNBTValue();
            NBTTagCompound outputs = tag.func_74775_l("Outputs");
            ItemStack output = ItemStack.func_77949_a((NBTTagCompound)outputs.func_74775_l("Output"));
            ItemStack second = null;
            if (outputs.func_74764_b("Secondary")) {
                second = ItemStack.func_77949_a((NBTTagCompound)outputs.func_74775_l("Secondary"));
            }
            NBTTagCompound inputs = tag.func_74775_l("Inputs");
            Object[] inputStacks = new Object[inputs.func_74762_e("InputLength")];
            for (int i = 0; i < inputs.func_74762_e("InputLength"); ++i) {
                NBTBase obj = inputs.func_74781_a("Input_" + i);
                if (obj instanceof NBTTagCompound) {
                    inputStacks[i] = ItemStack.func_77949_a((NBTTagCompound)inputs.func_74775_l("Input_" + i));
                    continue;
                }
                if (!(obj instanceof NBTTagString)) continue;
                if (i + 1 < inputs.func_74762_e("InputLength")) {
                    NBTBase nextObj = inputs.func_74781_a("Input_" + (i + 1));
                    if (nextObj instanceof NBTTagInt) {
                        inputStacks[i] = new OreStack(inputs.func_74779_i("Input_" + i), inputs.func_74762_e("Input_" + (i + 1)));
                        ++i;
                        continue;
                    }
                    inputStacks[i] = new OreStack(inputs.func_74779_i("Input_" + i), 1);
                    continue;
                }
                inputStacks[i] = new OreStack(inputs.func_74779_i("Input_" + i), 1);
            }
            craft.addOreRecipe(output, second, inputStacks);
        }
    }

    public static void bigWarning(Logger log, Level level, String format, Object ... data) {
        String o = String.format(format, data);
        String err = "************************";
        err = err + err;
        log.log(level, err);
        log.log(level, err);
        for (String str : o.split("\n", 0)) {
            log.log(level, str);
        }
        log.log(level, err);
        log.log(level, err);
    }
}

