/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods;

import betterwithmods.BWCrafting;
import betterwithmods.BWFuelHandler;
import betterwithmods.BWIMCHandler;
import betterwithmods.BWRegistry;
import betterwithmods.BWSounds;
import betterwithmods.client.container.BWGuiHandler;
import betterwithmods.config.BWConfig;
import betterwithmods.entity.EntityDynamite;
import betterwithmods.event.BucketEvent;
import betterwithmods.event.LogHarvestEvent;
import betterwithmods.event.MobDropEvent;
import betterwithmods.event.NetherSpawnEvent;
import betterwithmods.integration.ModIntegration;
import betterwithmods.proxy.CommonProxy;
import betterwithmods.util.ColorUtils;
import betterwithmods.util.RecipeUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="betterwithmods", name="Better With Mods", version="0.9 Beta", dependencies="before:survivalist;after:TContruct;after:minechem;after:Natura;after:terrafirmacraft", acceptedMinecraftVersions="[1.9.4]")
public class BWMod {
    @SidedProxy(serverSide="betterwithmods.proxy.CommonProxy", clientSide="betterwithmods.proxy.ClientProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="betterwithmods")
    public static BWMod instance;
    public static final Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        BWConfig.init(new File(evt.getModConfigurationDirectory() + "/betterwithmods.cfg"));
        BWRegistry.init();
        BWCrafting.init();
        EntityRegistry.registerModEntity(EntityDynamite.class, (String)"BWMDynamite", (int)1, (Object)this, (int)10, (int)50, (boolean)true);
        proxy.registerRenderInformation();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new BWGuiHandler());
        proxy.registerColors();
        BWRegistry.registerHeatSources();
        GameRegistry.registerFuelHandler((IFuelHandler)new BWFuelHandler());
        BWRegistry.registerNetherWhitelist();
        BWRegistry.registerWood();
        ModIntegration.init();
        BWSounds.registerSounds();
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent evt) {
        BWIMCHandler.processIMC((ImmutableList<FMLInterModComms.IMCMessage>)evt.getMessages());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        RecipeUtils.sawRecipeInit();
        RecipeUtils.gatherCookableFood();
        proxy.postRender();
        ColorUtils.initColors();
        MinecraftForge.EVENT_BUS.register((Object)new MobDropEvent());
        MinecraftForge.EVENT_BUS.register((Object)new BucketEvent());
        MinecraftForge.EVENT_BUS.register((Object)new NetherSpawnEvent());
        MinecraftForge.EVENT_BUS.register((Object)new LogHarvestEvent());
    }

    @Mod.EventHandler
    public void onMissingMapping(FMLMissingMappingsEvent evt) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : evt.get()) {
            if (!mapping.name.contains("betterwithmods:")) continue;
            logger.warn("Converting " + mapping.name + " to " + this.convertToLowercase(mapping.name) + " to conform to future standards. Downgrading Better With Mods may remove this item!");
            if (mapping.type == GameRegistry.Type.BLOCK) {
                mapping.remap((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(this.convertToLowercase(mapping.name))));
            }
            if (mapping.type != GameRegistry.Type.ITEM) continue;
            mapping.remap((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.convertToLowercase(mapping.name))));
        }
    }

    private String convertToLowercase(String name) {
        char[] chars = name.toCharArray();
        StringBuilder build = new StringBuilder();
        for (char ch : chars) {
            if (ch >= 'A' && ch <= 'Z') {
                ch = (char)(ch + 32);
                build.append('_');
            }
            build.append(ch);
        }
        return build.toString();
    }

    static {
        logger = LogManager.getLogger((String)"betterwithmods");
    }
}

