/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.api;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class InterModCommsHelper {
    public static void registerLogInteractionRecipe(String message, Block inputBlock, int inputMeta, ItemStack output) {
        ItemStack input = new ItemStack(inputBlock, 1, inputMeta);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound inputTag = new NBTTagCompound();
        input.func_77955_b(inputTag);
        tag.func_74782_a("Input", (NBTBase)inputTag);
        if (output != null) {
            NBTTagCompound outputTag = new NBTTagCompound();
            output.func_77955_b(outputTag);
            tag.func_74782_a("Output", (NBTBase)outputTag);
        }
        InterModCommsHelper.sendMessage(message, tag);
    }

    public static void registerWhitelistRecipe(String message, Block block, int meta) {
        ItemStack input = new ItemStack(block, 1, meta);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound inputTag = new NBTTagCompound();
        input.func_77955_b(inputTag);
        tag.func_74782_a("Spawn", (NBTBase)inputTag);
        InterModCommsHelper.sendMessage(message, tag);
    }

    public static void registerHeatInteractionRecipe(String message, Block inputBlock, int inputMeta, int heatValue) {
        ItemStack input = new ItemStack(inputBlock, 1, inputMeta);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("HeatValue", heatValue);
        NBTTagCompound inputTag = new NBTTagCompound();
        input.func_77955_b(inputTag);
        tag.func_74782_a("Input", (NBTBase)inputTag);
        InterModCommsHelper.sendMessage(message, tag);
    }

    public static void registerInteractionRecipe(String message, Block inputBlock, int inputMeta, ItemStack output) {
        ItemStack input = new ItemStack(inputBlock, 1, inputMeta);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound inputTag = new NBTTagCompound();
        input.func_77955_b(inputTag);
        tag.func_74782_a("Input", (NBTBase)inputTag);
        NBTTagCompound outputTag = new NBTTagCompound();
        output.func_77955_b(outputTag);
        tag.func_74782_a("Output", (NBTBase)outputTag);
        InterModCommsHelper.sendMessage(message, tag);
    }

    public static void registerBulkRecipe(String message, ItemStack output, ItemStack secondary, Object[] inputs) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound outputTags = new NBTTagCompound();
        NBTTagCompound item = new NBTTagCompound();
        output.func_77955_b(item);
        outputTags.func_74782_a("Output", (NBTBase)item);
        if (secondary != null) {
            item = new NBTTagCompound();
            secondary.func_77955_b(item);
            outputTags.func_74782_a("Secondary", (NBTBase)item);
        }
        tag.func_74782_a("Outputs", (NBTBase)outputTags);
        NBTTagCompound inputTags = new NBTTagCompound();
        int inputLength = inputs.length;
        inputTags.func_74768_a("InputLength", inputLength);
        for (int i = 0; i < inputLength; ++i) {
            ItemStack stack;
            item = new NBTTagCompound();
            Object obj = inputs[i];
            if (obj instanceof Item) {
                stack = new ItemStack((Item)obj);
                stack.func_77955_b(item);
                inputTags.func_74782_a("Input_" + i, (NBTBase)item);
                continue;
            }
            if (obj instanceof Block) {
                stack = new ItemStack((Block)obj);
                stack.func_77955_b(item);
                inputTags.func_74782_a("Input_" + i, (NBTBase)item);
                continue;
            }
            if (obj instanceof ItemStack) {
                ((ItemStack)obj).func_77955_b(item);
                inputTags.func_74782_a("Input_" + i, (NBTBase)item);
                continue;
            }
            if (obj instanceof String) {
                inputTags.func_74778_a("Input_" + i, (String)obj);
                continue;
            }
            if (!(obj instanceof Integer)) continue;
            inputTags.func_74768_a("Input_" + i, ((Integer)obj).intValue());
        }
        tag.func_74782_a("Inputs", (NBTBase)inputTags);
        InterModCommsHelper.sendMessage(message, tag);
    }

    public static void sendMessage(String message, NBTTagCompound tag) {
        if (!Loader.isModLoaded((String)"betterwithmods") || Loader.instance().activeModContainer() == null) {
            return;
        }
        try {
            FMLInterModComms.sendMessage((String)"betterwithmods", (String)message, (NBTTagCompound)tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

